<?php
spl_autoload_register("medicenter_elementor_widgets_autoloader");
function medicenter_elementor_widgets_autoloader($class_name)
{
	if(strpos($class_name, 'MediCenterWidget')!==false)
	{
		$classes_dir = realpath(plugin_dir_path(__FILE__)) . DIRECTORY_SEPARATOR . 'class' . DIRECTORY_SEPARATOR;
		if(file_exists($classes_dir . $class_name . '.php'))
		{
			require_once($classes_dir . $class_name . '.php');
		}
	}
}
function mc_theme_elementor_enqueue_styles()
{
	wp_enqueue_style("mc-elementor-styles", get_template_directory_uri() ."/elementor/style/elementor.css");
}
add_action("elementor/frontend/after_enqueue_styles", "mc_theme_elementor_enqueue_styles");

function mc_theme_elementor_enqueue_styles_admin() 
{
	wp_enqueue_style("mc-elementor-styles-admin", get_template_directory_uri() ."/elementor/admin/style/elementor.css");
}
add_action('elementor/editor/before_enqueue_styles', 'mc_theme_elementor_enqueue_styles_admin');

function mc_theme_elementor_before_enqueue_scripts()
{
	wp_enqueue_script("mc-elementor-script", get_template_directory_uri() ."/elementor/js/elementor.js", array("jquery"), false, true);
}
add_action('elementor/editor/before_enqueue_scripts', "mc_theme_elementor_before_enqueue_scripts");

function mc_theme_register_elementor_locations($elementor_theme_manager)
{
	$elementor_theme_manager->register_all_core_location();
}
add_action('elementor/theme/register_locations', 'mc_theme_register_elementor_locations');

if(class_exists("Elementor\Core\Modules_Manager"))
{
	function mc_theme_add_elementor_widget_categories($elements_manager)
	{
		$categories = [];
		$categories['medicenter'] =
		[
			'title' => esc_html__("MediCenter", 'medicenter'),
			'icon'  => 'fa fa-plug'
		];

		$old_categories = $elements_manager->get_categories();
		$categories = array_merge($categories, $old_categories);

		$set_categories = function ($categories)
		{
			$this->categories = $categories;
		};

		$set_categories->call($elements_manager, $categories);
	}
	add_action('elementor/elements/categories_registered', 'mc_theme_add_elementor_widget_categories');
	
	function mc_theme_register_elementor_widgets($widgets_manager) 
	{
		$widgets_manager->register(new \MediCenterWidget_Announcement_Box());
		$widgets_manager->register(new \MediCenterWidget_Blog());
		$widgets_manager->register(new \MediCenterWidget_Carousel());
		$widgets_manager->register(new \MediCenterWidget_Contact_Form());
		$widgets_manager->register(new \MediCenterWidget_Counter_Box());
		$widgets_manager->register(new \MediCenterWidget_Doctor_Box());
		$widgets_manager->register(new \MediCenterWidget_Doctor_Description_Box());
		$widgets_manager->register(new \MediCenterWidget_Dropcap());
		$widgets_manager->register(new \MediCenterWidget_Google_Map());
		$widgets_manager->register(new \MediCenterWidget_Icon());
		$widgets_manager->register(new \MediCenterWidget_Info_Box());
		$widgets_manager->register(new \MediCenterWidget_Items_List());
		$widgets_manager->register(new \MediCenterWidget_MediCenter_Menu());
		$widgets_manager->register(new \MediCenterWidget_Notification_Box());
		$widgets_manager->register(new \MediCenterWidget_Our_Clients_List());
		$widgets_manager->register(new \MediCenterWidget_Photostream());
		$widgets_manager->register(new \MediCenterWidget_Sentence());
		$widgets_manager->register(new \MediCenterWidget_Service_Box());
		$widgets_manager->register(new \MediCenterWidget_Single_Doctor());
		$widgets_manager->register(new \MediCenterWidget_Single_Post());
		$widgets_manager->register(new \MediCenterWidget_Single_Service());
		$widgets_manager->register(new \MediCenterWidget_Small_Slider());
		$widgets_manager->register(new \MediCenterWidget_Testimonials());
		$widgets_manager->register(new \MediCenterWidget_Timeline_Item());
		$widgets_manager->register(new \MediCenterWidget_Timetable());		
	}
	add_action('elementor/widgets/register', 'mc_theme_register_elementor_widgets');
}

function mc_theme_elementor_document_settings_before_section_end(\Elementor\Core\DocumentTypes\PageBase $page)
{
	if(!$page instanceof \Elementor\Core\DocumentTypes\PageBase || !$page::get_property('has_elements'))
	{
		return;
	}
	//get theme sidebars
	$theme_sidebars = array();
	$theme_sidebars_array = get_posts(array(
		'post_type' => 'medicenter_sidebars',
		'posts_per_page' => '-1',
		'nopaging' => true,
		'post_status' => 'publish',
		'orderby' => 'menu_order',
		'order' => 'ASC'
	));
	$theme_sidebars["-1"] = esc_html__("None", 'medicenter');
	for($i=1; $i<=count($theme_sidebars_array); $i++)
	{
		$theme_sidebars[$theme_sidebars_array[$i-1]->ID] = $theme_sidebars_array[$i-1]->post_title;
	}
	$sliderAllShortcodeIds = array();
	//get revolution sliders
	if(is_plugin_active('revslider/revslider.php'))
	{
		global $wpdb;
		$rs = $wpdb->get_results( 
		"
		SELECT id, title, alias
		FROM ".$wpdb->prefix."revslider_sliders
		ORDER BY id ASC LIMIT 100
		"
		);
		if($rs) 
		{
			foreach($rs as $slider)
			{
				$sliderAllShortcodeIds["revolution_slider_settings_" . $slider->alias] = $slider->alias;
			}
		}
	}
	//get layer sliders
	if(is_plugin_active('LayerSlider/layerslider.php'))
	{
		global $wpdb;
		$ls = $wpdb->get_results(
		"
		SELECT id, name, date_c
		FROM ".$wpdb->prefix."layerslider
		WHERE flag_hidden = '0' AND flag_deleted = '0'
		ORDER BY date_c ASC LIMIT 999
		"
		);
		$layer_sliders = array();
		if($ls)
		{
			foreach($ls as $slider)
			{
				$sliderAllShortcodeIds["aaaaalayer_slider_settings_" . $slider->id] = $slider->id;
			}
		}
	}
	//sort slider ids
	$sliderAllShortcodeIds[''] = esc_html__("None", 'medicenter');
	asort($sliderAllShortcodeIds);
	$page->add_control(
		'main_slider',
		[
			'type' => \Elementor\Controls_Manager::SELECT,
			'label' => esc_html__("Main Slider", 'medicenter'),
			'options' => $sliderAllShortcodeIds,
			'condition' => [
				'template' => "template-home.php"
			]
		]
	);
	$page->add_control(
		'page_sidebar_header',
		[
			'type' => \Elementor\Controls_Manager::SELECT,
			'label' => esc_html__("Sidebar header", 'medicenter'),
			'options' => $theme_sidebars,
			'condition' => [
				'template' => ["default", "template-blog.php", "single.php", "single-features.php", "single-doctors.php", "single-ql_services.php", "search.php", "404.php"]
			]
		]
	);
	$page->add_control(
		'page_sidebar_top',
		[
			'type' => \Elementor\Controls_Manager::SELECT,
			'label' => esc_html__("Sidebar top", 'medicenter'),
			'options' => $theme_sidebars,
			'condition' => [
				'template' => ["template-home.php"]
			]
		]
	);
	$page->add_control(
		'page_sidebar_footer_top',
		[
			'type' => \Elementor\Controls_Manager::SELECT,
			'label' => esc_html__("Sidebar footer top", 'medicenter'),
			'options' => $theme_sidebars,
			'condition' => [
				'template' => ["default", "template-blog.php", "single.php", "single-features.php", "single-doctors.php", "single-ql_services.php", "search.php", "template-default-without-breadcrumbs.php", "template-home.php", "404.php", "template-empty-with-footer.php"]
			]
		]
	);
	$page->add_control(
		'page_sidebar_footer_bottom',
		[
			'type' => \Elementor\Controls_Manager::SELECT,
			'label' => esc_html__("Sidebar footer bottom", 'medicenter'),
			'options' => $theme_sidebars,
			'condition' => [
				'template' => ["default", "template-blog.php", "single.php", "single-features.php", "single-doctors.php", "single-ql_services.php", "search.php", "template-default-without-breadcrumbs.php", "template-home.php", "404.php", "template-empty-with-footer.php"]
			]
		]
	);
}
add_action('elementor/element/wp-page/document_settings/before_section_end', 'mc_theme_elementor_document_settings_before_section_end');

function mc_theme_elementor_document_settings_post_before_section_end(\Elementor\Core\DocumentTypes\Post $post)
{
	if(!$post instanceof \Elementor\Core\DocumentTypes\Post || !$post::get_property('has_elements'))
	{
		return;
	}
	if(get_post_type()=="post")
	{
		for($i=1; $i<=5; $i++)
		{
			$post->add_control(
				'image_url' . $i,
				[
					'label' => sprintf(esc_html__("Image url %d", 'medicenter'), $i),
					'type' => \Elementor\Controls_Manager::MEDIA,
					'default' => [
						'url' => '',
					]
				]
			);
			$post->add_control(
				'image_title' . $i,
				[
					'type' => \Elementor\Controls_Manager::TEXT,
					'label' => sprintf(esc_html__("Image description %d", 'medicenter'), $i),
					'label_block' => false
				]
			);
			$post->add_control(
				'video' . $i,
				[
					'type' => \Elementor\Controls_Manager::TEXT,
					'label' => sprintf(esc_html__("Video url %d", 'medicenter'), $i),
					'label_block' => false
				]
			);
			$post->add_control(
				'iframe' . $i,
				[
					'type' => \Elementor\Controls_Manager::TEXT,
					'label' => sprintf(esc_html__("Iframe url %d", 'medicenter'), $i),
					'label_block' => false
				]
			);
			$post->add_control(
				'external_url' . $i,
				[
					'type' => \Elementor\Controls_Manager::TEXT,
					'label' => sprintf(esc_html__("External url %d", 'medicenter'), $i),
					'label_block' => false
				]
			);
		}
		$post->add_control(
			'features_images_loop',
			[
				'type' => \Elementor\Controls_Manager::SELECT,
				'label' => esc_html__("Featured images lightbox loop", 'medicenter'),
				'options' => [
					'yes' => esc_html__("yes", 'medicenter'),
					'no' => esc_html__("no", 'medicenter')
				],
				'default' => 'yes'
			]
		);
		$post->add_control(
			'show_images_in',
			[
				'type' => \Elementor\Controls_Manager::SELECT,
				'label' => esc_html__("Show featured images lightbox", 'medicenter'),
				'options' => [
					'post' => esc_html__("in single post", 'medicenter'),
					'blog' => esc_html__("on post list", 'medicenter'),
					'both' => esc_html__("both", 'medicenter')
				],
				'default' => 'post'
			]
		);
		$post->add_control(
			'hover_icons',
			[
				'type' => \Elementor\Controls_Manager::SELECT,
				'label' => esc_html__("Show hover icons on the images", 'medicenter'),
				'options' => [
					'yes' => esc_html__("yes", 'medicenter'),
					'no' => esc_html__("no", 'medicenter')
				],
				'default' => 'yes'
			]
		);
	}
	else if(get_post_type()=="ql_services")
	{
		$post->add_control(
			'icon',
			[
				'type' => \Elementor\Controls_Manager::SELECT,
				'label' => esc_html__("Icon", 'medicenter'),
				'options' => [
					'-' => esc_html__("none", 'medicenter'),
					'features-address' => esc_html__("address", 'medicenter'),
					'features-ambulance' => esc_html__("ambulance", 'medicenter'),
					'features-app' => esc_html__("app", 'medicenter'),
					'features-baby' => esc_html__("baby", 'medicenter'),
					'features-baby-bed' => esc_html__("baby-bed", 'medicenter'),
					'features-baby-bottle' => esc_html__("baby-bottle", 'medicenter'),
					'features-bacteria' => esc_html__("bacteria", 'medicenter'),
					'features-balance' => esc_html__("balance", 'medicenter'),
					'features-battery' => esc_html__("battery", 'medicenter'),
					'features-book' => esc_html__("book", 'medicenter'),
					'features-box' => esc_html__("box", 'medicenter'),
					'features-brain' => esc_html__("brain", 'medicenter'),
					'features-briefcase' => esc_html__("briefcase", 'medicenter'),
					'features-burns' => esc_html__("burns", 'medicenter'),
					'features-cart' => esc_html__("cart", 'medicenter'),
					'features-cat' => esc_html__("cat", 'medicenter'),
					'features-certificate' => esc_html__("certificate", 'medicenter'),
					'features-chart' => esc_html__("chart", 'medicenter'),
					'features-chat' => esc_html__("chat", 'medicenter'),
					'features-clock' => esc_html__("clock", 'medicenter'),
					'features-config' => esc_html__("config", 'medicenter'),
					'features-credit-card' => esc_html__("credit-card", 'medicenter'),
					'features-cross' => esc_html__("cross", 'medicenter'),
					'features-dental-shield' => esc_html__("dental-shield", 'medicenter'),
					'features-dentist' => esc_html__("dentist", 'medicenter'),
					'features-diary' => esc_html__("diary", 'medicenter'),
					'features-dna' => esc_html__("dna", 'medicenter'),
					'features-doctor' => esc_html__("doctor", 'medicenter'),
					'features-document' => esc_html__("document", 'medicenter'),
					'features-document-missing' => esc_html__("document-missing", 'medicenter'),
					'features-dog' => esc_html__("dog", 'medicenter'),
					'features-drip' => esc_html__("drip", 'medicenter'),
					'features-ear' => esc_html__("ear", 'medicenter'),
					'features-email' => esc_html__("email", 'medicenter'),
					'features-eye' => esc_html__("eye", 'medicenter'),
					'features-facebook' => esc_html__("facebook", 'medicenter'),
					'features-first-aid' => esc_html__("first-aid", 'medicenter'),
					'features-fitness' => esc_html__("fitness", 'medicenter'),
					'features-frostbite' => esc_html__("frostbite", 'medicenter'),
					'features-gallery' => esc_html__("gallery", 'medicenter'),
					'features-glasses' => esc_html__("glasses", 'medicenter'),
					'features-graph' => esc_html__("graph", 'medicenter'),
					'features-healthcare' => esc_html__("healthcare", 'medicenter'),
					'features-heart' => esc_html__("heart", 'medicenter'),
					'features-heart-beat' => esc_html__("heart-beat", 'medicenter'),
					'features-home' => esc_html__("home", 'medicenter'),
					'features-hospital' => esc_html__("hospital", 'medicenter'),
					'features-id' => esc_html__("id", 'medicenter'),
					'features-image' => esc_html__("image", 'medicenter'),
					'features-keyboard' => esc_html__("keyboard", 'medicenter'),
					'features-lab' => esc_html__("lab", 'medicenter'),
					'features-laptop' => esc_html__("laptop", 'medicenter'),
					'features-leaf' => esc_html__("leaf", 'medicenter'),
					'features-lifeline' => esc_html__("lifeline", 'medicenter'),
					'features-list' => esc_html__("list", 'medicenter'),
					'features-location' => esc_html__("location", 'medicenter'),
					'features-lock' => esc_html__("lock", 'medicenter'),
					'features-map' => esc_html__("map", 'medicenter'),
					'features-medical-bed' => esc_html__("medical-bed", 'medicenter'),
					'features-medical-cast' => esc_html__("medical-cast", 'medicenter'),
					'features-medical-cross' => esc_html__("medical-cross", 'medicenter'),
					'features-medical-document' => esc_html__("medical-document", 'medicenter'),
					'features-medical-results' => esc_html__("medical-results", 'medicenter'),
					'features-medical-scissors' => esc_html__("medical-scissors", 'medicenter'),
					'features-medical-staff' => esc_html__("medical-staff", 'medicenter'),
					'features-minus' => esc_html__("minus", 'medicenter'),
					'features-mobile' => esc_html__("mobile", 'medicenter'),
					'features-molecule' => esc_html__("molecule", 'medicenter'),
					'features-money' => esc_html__("money", 'medicenter'),
					'features-mortar' => esc_html__("mortar", 'medicenter'),
					'features-movie' => esc_html__("movie", 'medicenter'),
					'features-network' => esc_html__("network", 'medicenter'),
					'features-paypal' => esc_html__("paypal", 'medicenter'),
					'features-pen' => esc_html__("pen", 'medicenter'),
					'features-people' => esc_html__("people", 'medicenter'),
					'features-pet-box' => esc_html__("pet-box", 'medicenter'),
					'features-phone' => esc_html__("phone", 'medicenter'),
					'features-piano' => esc_html__("piano", 'medicenter'),
					'features-pill' => esc_html__("pill", 'medicenter'),
					'features-pin' => esc_html__("task", 'medicenter'),
					'features-plaster' => esc_html__("plaster", 'medicenter'),
					'features-play' => esc_html__("play", 'medicenter'),
					'features-plus' => esc_html__("plus", 'medicenter'),
					'features-printer' => esc_html__("printer", 'medicenter'),
					'features-pulse' => esc_html__("pulse", 'medicenter'),
					'features-quote' => esc_html__("quote", 'medicenter'),
					'features-science' => esc_html__("science", 'medicenter'),
					'features-screen' => esc_html__("screen", 'medicenter'),
					'features-signpost' => esc_html__("signpost", 'medicenter'),
					'features-spa' => esc_html__("spa", 'medicenter'),
					'features-spa-bamboo' => esc_html__("spa-bamboo", 'medicenter'),
					'features-spa-lotion' => esc_html__("spa-lotion", 'medicenter'),
					'features-speaker' => esc_html__("speaker", 'medicenter'),
					'features-stethoscope' => esc_html__("stethoscope", 'medicenter'),
					'features-syringe' => esc_html__("syringe", 'medicenter'),
					'features-tablet' => esc_html__("tablet", 'medicenter'),
					'features-tags' => esc_html__("tags", 'medicenter'),
					'features-teddy-bear' => esc_html__("teddy-bear", 'medicenter'),
					'features-test-tube' => esc_html__("test-tube", 'medicenter'),
					'features-tick' => esc_html__("tick", 'medicenter'),
					'features-time' => esc_html__("time", 'medicenter'),
					'features-toothbrush' => esc_html__("toothbrush", 'medicenter'),
					'features-twitter' => esc_html__("twitter", 'medicenter'),
					'features-video' => esc_html__("video", 'medicenter'),
					'features-wallet' => esc_html__("wallet", 'medicenter'),
					'features-x-ray' => esc_html__("x-ray", 'medicenter')					
				]
			]
		);
		$post->add_control(
			'ql_services_custom_url',
			[
				'type' => \Elementor\Controls_Manager::TEXT,
				'label' => esc_html__("Custom url", 'medicenter'),
				'label_block' => true
			]
		);
	}
}
add_action('elementor/element/wp-post/document_settings/before_section_end', 'mc_theme_elementor_document_settings_post_before_section_end');

function mc_theme_elementor_after_save($post_id, $editor_data)
{
	global $themename;
	$page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers('page');

	// Retrieve the settings model for the current page
	$page_settings_model = $page_settings_manager->get_model($post_id);

	// Retrieve data from a custom control
	$main_slider = $page_settings_model->get_settings('main_slider');
	$page_sidebar_header = $page_settings_model->get_settings('page_sidebar_header');
	$page_sidebar_top = $page_settings_model->get_settings('page_sidebar_top');
	$page_sidebar_footer_top = $page_settings_model->get_settings('page_sidebar_footer_top');
	$page_sidebar_footer_bottom = $page_settings_model->get_settings('page_sidebar_footer_bottom');
	update_post_meta($post_id, "main_slider", $main_slider);
	update_post_meta($post_id, "page_sidebar_header", $page_sidebar_header);
	update_post_meta($post_id, "page_sidebar_top", $page_sidebar_top);
	update_post_meta($post_id, "page_sidebar_footer_top", $page_sidebar_footer_top);
	update_post_meta($post_id, "page_sidebar_footer_bottom", $page_sidebar_footer_bottom);
	update_post_meta($post_id, $themename . "_page_sidebars", array_values(array_filter(array(
		(!empty($_POST["page_sidebar_header"]) ? $_POST["page_sidebar_header"] : NULL),
		(!empty($_POST["page_sidebar_top"]) ? $_POST["page_sidebar_top"] : NULL),
		(!empty($_POST["page_sidebar_footer_top"]) ? $_POST["page_sidebar_footer_top"] : NULL),
		(!empty($_POST["page_sidebar_footer_bottom"]) ? $_POST["page_sidebar_footer_bottom"] : NULL)
	))));
	$attachment_ids = array();
	$images = array();
	$images_titles = array();
	$videos = array();
	$iframes = array();
	$external_urls = array();
	for($i=1; $i<=5; $i++)
	{
		$attachment_ids[] = $page_settings_model->get_settings("image_url" . $i)["id"];
		$images[] = $page_settings_model->get_settings("image_url" . $i)["url"];
		$images_titles[] = $page_settings_model->get_settings("image_title" . $i);
		$videos[] = $page_settings_model->get_settings("video" . $i);
		$iframes[] = $page_settings_model->get_settings("iframe" . $i);
		$external_urls[] = $page_settings_model->get_settings("external_url" . $i);
	}
	while(end($attachment_ids)==="")
	{
		array_pop($attachment_ids);
	}
	update_post_meta($post_id, "medicenter_attachment_ids", $attachment_ids);
	update_post_meta($post_id, "medicenter_images", $images);
	update_post_meta($post_id, "medicenter_images_titles", $images_titles);
	update_post_meta($post_id, "medicenter_videos", $videos);
	update_post_meta($post_id, "medicenter_iframes", $iframes);
	update_post_meta($post_id, "medicenter_external_urls", $external_urls);
	update_post_meta($post_id, "medicenter_features_images_loop", $page_settings_model->get_settings('features_images_loop'));
	update_post_meta($post_id, "medicenter_show_images_in", $page_settings_model->get_settings('show_images_in'));
	update_post_meta($post_id, "medicenter_hover_icons", $page_settings_model->get_settings('hover_icons'));
	update_post_meta($post_id, "icon", $page_settings_model->get_settings('icon'));
	update_post_meta($post_id, "ql_services_custom_url", $page_settings_model->get_settings('ql_services_custom_url'));
}
add_action('elementor/editor/after_save', 'mc_theme_elementor_after_save', 10, 2);

function mc_theme_elementor_nested_tabs($widget, $args)
{
	$widget->add_control(
		'type',
		[
			'type' => \Elementor\Controls_Manager::SELECT,
			'label' => esc_html__("Type", 'medicenter'),
			'options' => [
				'default' => esc_html__("Default", 'medicenter'),
				'big' => esc_html__("Big", 'medicenter')
			],
			'default' => 'default'
		]
	);
}
add_action('elementor/element/nested-tabs/section_tabs/after_section_start', 'mc_theme_elementor_nested_tabs', 10, 2);

function mc_theme_elementor_add_custom_tab_url($widget, $args)
{
	$control_data = \Elementor\Plugin::instance()->controls_manager->get_control_from_stack($widget->get_unique_name(), 'tabs');
	if(is_wp_error($control_data))
	{
		return;
	}

	$control_data['fields']['custom_tab_url'] = [
		'name' => 'custom_tab_url',
		'type' => \Elementor\Controls_Manager::TEXT,
		'label' => esc_html__("Tab url", 'medicenter'),
		'default' => ''
	];
	$widget->update_control('tabs', $control_data);
}
add_action('elementor/element/nested-tabs/section_tabs/before_section_end', 'mc_theme_elementor_add_custom_tab_url', 10, 2);

function mc_theme_elementor_render_nested_tabs($widget_content, $widget)
{
	if($widget->get_name()==='nested-tabs')
	{
		$settings = $widget->get_settings_for_display();
		$document = new DOMDocument();
		libxml_use_internal_errors(true);
		$document->loadHTML("<?xml encoding='UTF-8'>" . $widget_content);
		if($settings["type"]=="big")
		{
			$finder = new DomXPath($document);
			$classname="e-n-tabs";
			$nodes = $finder->query("//*[contains(@class, '$classname')]");
			$nodes->item(0)->setAttribute("class", $nodes->item(0)->getAttribute("class") . " type-big");
			$id="e-n-tab-title-";
			$nodes = $finder->query("//*[contains(@id, '$id')]");
			$itemWidth = 100/$nodes->length;
			foreach($nodes as $node)
			{
				$node->setAttribute("style", $node->getAttribute("style") . " flex-basis: " . $itemWidth . "%");
			}
		}
		
		$buttons = $document->getElementsByTagName("button");
		if(isset($buttons))
		{
			$i = $buttons->length-1;
			while($buttons->item($i))
			{
				$childnodes = array();
				foreach($buttons->item($i)->childNodes as $child)
				{
					$childnodes[] = $child;
				}
				$newnode = $buttons->item($i)->ownerDocument->createElement("a");
				foreach ($childnodes as $child)
				{
					$child2 = $buttons->item($i)->ownerDocument->importNode($child, true);
					$newnode->appendChild($child2);
				}
				foreach($buttons->item($i)->attributes as $attrName => $attrNode)
				{
					$attrName = $attrNode->nodeName;
					$attrValue = $attrNode->nodeValue;
					$newnode->setAttribute($attrName, $attrValue);
				}
				if(!empty($settings["tabs"][$i]["custom_tab_url"]) && $settings["tabs"][$i]["custom_tab_url"]!="")
				{
					$newnode->setAttribute("href", esc_attr($settings["tabs"][$i]["custom_tab_url"]));
				}
				$buttons->item($i)->parentNode->replaceChild($newnode, $buttons->item($i));
				$i--;
			}
		}
		$widget_content = $document->saveHTML();
	}
	return $widget_content;
}
add_filter('elementor/widget/render_content', 'mc_theme_elementor_render_nested_tabs', 10, 2);

function mc_theme_elementor_render_custom_accordion_item_id($widget_content, $widget)
{
	if($widget->get_name()==='nested-accordion')
	{
		$settings = $widget->get_settings_for_display();
		
		$document = new DOMDocument();
		libxml_use_internal_errors(true);
		$document->loadHTML("<?xml encoding='UTF-8'>" . $widget_content);
		$items = $document->getElementsByTagName("summary");
		$i = 0;
		while($items->item($i))
		{
			if(!empty($settings["items"][$i]["custom_item_id"]) && $settings["items"][$i]["custom_item_id"]!="")
			{
				$items->item($i)->setAttribute("id", esc_attr($settings["items"][$i]["custom_item_id"]));
			}
			$i++;
		}
		$widget_content = $document->saveHTML();
	}

	return $widget_content;
}
add_filter('elementor/widget/render_content', 'mc_theme_elementor_render_custom_accordion_item_id', 10, 2);

function mc_theme_elementor_add_custom_item_id($widget, $args)
{
	$control_data = \Elementor\Plugin::instance()->controls_manager->get_control_from_stack($widget->get_unique_name(), 'items');
	if(is_wp_error($control_data))
	{
		return;
	}
	$control_data['fields']['custom_item_id'] = [
		'name' => 'custom_item_id',
		'type' => \Elementor\Controls_Manager::TEXT,
		'label' => esc_html__("Item id", 'medicenter'),
		'default' => ''
	];
	$widget->update_control('items', $control_data);
}
add_action('elementor/element/nested-accordion/section_items/before_section_end', 'mc_theme_elementor_add_custom_item_id', 10, 2);

function mc_theme_elementor_slider_revolution($widget, $args)
{
	$widget->add_control(
		'mc_navigation',
		[
			'type' => \Elementor\Controls_Manager::SELECT,
			'label' => esc_html__("MediCenter navigation", 'medicenter'),
			'options' => [
				'1' => esc_html__("Enable", 'medicenter'),
				'0' => esc_html__("Disable", 'medicenter')
			],
			'default' => '1'
		]
	);
}
add_action('elementor/element/slider_revolution/content_section/before_section_end', 'mc_theme_elementor_slider_revolution', 10, 2);

function mc_theme_elementor_render_slider_revolution($widget_content, $widget)
{
	if($widget->get_name()==='slider_revolution')
	{
		$settings = $widget->get_settings_for_display();
		if((int)$settings["mc_navigation"])
		{
			$document = new DOMDocument();
			libxml_use_internal_errors(true);
			$document->loadHTML("<?xml encoding='UTF-8'>" . $widget_content);
			$finder = new DomXPath($document);
			$classname="wp-block-themepunch-revslider";
			$nodes = $finder->query("//*[contains(@class, '$classname')]");
			$nodes->item(0)->setAttribute("class", $nodes->item(0)->getAttribute("class") . " mc-navigation mc-navigation-elementor");
			$widget_content = $document->saveHTML();
		}
	}
	return $widget_content;
}
add_filter('elementor/widget/render_content', 'mc_theme_elementor_render_slider_revolution', 10, 2);

function mc_theme_elementor_render_sidebar($widget_content, $widget)
{
	if($widget->get_name()==='sidebar')
	{
		$widget_content = trim($widget_content);
		$widget_content = ('<li'===substr($widget_content, 0, 3) ? '<ul>' . $widget_content . '</ul>' : $widget_content);	
	}
	return $widget_content;
}
add_filter('elementor/widget/render_content', 'mc_theme_elementor_render_sidebar', 10, 2);

function mc_theme_elementor_after_save_system_colors($object, $data)
{
	if(is_object($object) && get_class($object)=="Elementor\Core\Kits\Documents\Kit")
	{
		if(isset($data) && isset($data["settings"]) && isset($data["settings"]["system_colors"]) && isset($data["settings"]["system_colors"][0]))
		{
			global $themename;
			$theme_options = array(
				"favicon_url" => '',
				"logo_url" => '',
				"logo_text" => '',
				"footer_text_left" => '',
				"sticky_menu" => '',
				"responsive" => '',
				"scroll_top" => '',
				"layout" => '',
				"layout_picker" => '',
				"direction" => '',
				"animations" => '',
				"collapsible_mobile_submenus" => '',
				"google_api_code" => '',
				"google_recaptcha" => '',
				"google_recaptcha_comments" => '',
				"recaptcha_site_key" => '',
				"recaptcha_secret_key" => '',
				"ga_tracking_id" => '',
				"ga_tracking_code" => '',
				//"home_page_top_hint" => '',
				"cf_admin_name" => '',
				"cf_admin_email" => '',
				"cf_admin_name_from" => '',
				"cf_admin_email_from" => '',
				"cf_smtp_host" => '',
				"cf_smtp_username" => '',
				"cf_smtp_password" => '',
				"cf_smtp_port" => '',
				"cf_smtp_secure" => '',
				"cf_email_subject" => '',
				"cf_template" => '',
				"cf_first_name_message" => '',
				"cf_last_name_message" => '',
				"cf_date_message" => '',
				"cf_security_number_message" => '',
				"cf_phone_message" => '',
				"cf_email_message" => '',
				"cf_message_message" => '',
				"cf_recaptcha_message" => '',
				"cf_terms_message" => '',
				"cf_thankyou_message" => '',
				"cf_error_message" => '',
				"cf_name_message_comments" => '',
				"cf_email_message_comments" => '',
				"cf_comment_message_comments" => '',
				"cf_recaptcha_message_comments" => '',
				"cf_terms_message_comments" => '',
				"cf_thankyou_message_comments" => '',
				"cf_error_message_comments" => '',
				"color_scheme" => '',
				"primary_color" => '',
				"secondary_color" => '',
				"tertiary_color" => '',
				"site_background_color" => '',
				"header_background_color" => '',
				"body_background_color" => '',
				"footer_background_color" => '',
				"copyright_area_background_color" => '',
				"link_color" => '',
				"link_hover_color" => '',
				"footer_link_color" => '',
				"footer_link_hover_color" => '',
				"body_headers_color" => '',
				"body_headers_border_color" => '',
				"body_text_color" => '',
				"timeago_label_color" => '',
				"footer_headers_color" => '',
				"footer_headers_border_color" => '',
				"footer_text_color" => '',
				"footer_timeago_label_color" => '',
				"sentence_color" => '',
				"quote_color" => '',
				"logo_text_color" => '',
				"categories_and_pagination_color" => '',
				"categories_and_pagination_hover_color" => '',
				"categories_and_pagination_border_color" => '',
				"categories_and_pagination_border_hover_color" => '',
				"categories_and_pagination_background_color" => '',
				"categories_and_pagination_hover_background_color" => '',
				"light_button_color" => '',
				"light_button_hover_color" => '',
				"light_button_border_color" => '',
				"light_button_border_hover_color" => '',
				"light_button_background_color" => '',
				"light_button_hover_background_color" => '',
				"light_color_button_color" => '',
				"light_color_button_hover_color" => '',
				"light_color_button_border_color" => '',
				"light_color_button_border_hover_color" => '',
				"light_color_button_background_color" => '',
				"light_color_button_hover_background_color" => '',
				"dark_color_button_color" => '',
				"dark_color_button_hover_color" => '',
				"dark_color_button_border_color" => '',
				"dark_color_button_border_hover_color" => '',
				"dark_color_button_background_color" => '',
				"dark_color_button_hover_background_color" => '',
				"scrolling_list_number_color" => '',
				"scrolling_list_number_border_color" => '',
				"scrolling_list_number_hover_color" => '',
				"scrolling_list_number_border_hover_color" => '',
				"scrolling_list_control_arrow_color" => '',
				"scrolling_list_control_border_color" => '',
				"scrolling_list_control_arrow_hover_color" => '',
				"scrolling_list_control_arrow_border_hover_color" => '',
				"footer_scrolling_list_control_arrow_color" => '',
				"footer_scrolling_list_control_border_color" => '',
				"footer_scrolling_list_control_arrow_hover_color" => '',
				"footer_scrolling_list_control_arrow_border_hover_color" => '',
				"menu_position_text_color" => '',
				"menu_position_hover_text_color" => '',
				"menu_position_childrens_hover_text_color" => '',
				"menu_position_background_color" => '',
				"menu_position_hover_background_color" => '',
				"menu_position_childrens_hover_background_color" => '',
				"submenu_position_text_color" => '',
				"submenu_position_hover_text_color" => '',
				"submenu_position_border_color" => '',
				"submenu_position_hover_border_color" => '',
				"dropdownmenu_background_color" => '',
				"dropdownmenu_hover_background_color" => '',
				"dropdownmenu_border_color" => '',
				"mobile_menu_link_color" => '',
				"mobile_menu_position_background_color" => '',
				"mobile_menu_active_link_color" => '',
				"mobile_menu_active_position_background_color" => '',
				"form_field_text_color" => '',
				"form_field_border_color" => '',
				"form_field_background_color" => '',
				"form_button_background_color" => '',
				"form_button_hover_background_color" => '',
				"form_button_text_color" => '',
				"form_button_hover_text_color" => '',
				//"top_hint_background_color" => '',
				//"top_hint_text_color" => '',
				"divider_background_color" => '',
				"date_box_color" => '',
				"date_box_text_color" => '',
				"date_box_comments_number_color" => '',
				"date_box_comments_number_text_color" => '',
				"gallery_box_color" => '',
				"gallery_box_text_first_line_color" => '',
				"gallery_box_text_second_line_color" => '',
				"gallery_box_hover_color" => '',
				"gallery_box_hover_text_first_line_color" => '',
				"gallery_box_hover_text_second_line_color" => '',
				"gallery_box_border_color" => '',
				"gallery_box_hover_border_color" => '',
				"gallery_box_control_color" => '',
				"gallery_box_control_hover_color" => '',
				"timetable_box_color" => '',
				"timetable_box_hover_color" => '',
				"timetable_box_text_color" => '',
				"timetable_box_hover_text_color" => '',
				"timetable_tip_box_color" => '',
				"accordion_tab_color" => '',
				"tabs_text_color" => '',
				"tabs_border_color" => '',
				"tabs_hover_text_color" => '',
				"tabs_border_hover_color" => '',
				"featured_icon_color" => '',
				"featured_icon_background_color" => '',
				"light_featured_icon_color" => '',
				"light_featured_icon_background_color" => '',
				"simple_featured_icon_color" => '',
				"social_icon_color" => '',
				"social_icon_background_color" => '',
				"social_icon_hover_color" => '',
				"social_icon_hover_background_color" => '',
				"header_layout_type" => '',
				"header_top_sidebar" => '',
				"header_top_right_sidebar" => '',
				"header_font" => '',
				"header_font_subset" => '',
				"content_font" => '',
				"content_font_subset" => '',
				"blockquote_font" => '',
				"blockquote_font_subset" => ''
			);
			$theme_options = mc_theme_stripslashes_deep(array_merge($theme_options, (array)get_option($themename . "_options")));
			$theme_options["primary_color"] = sanitize_hex_color_no_hash($data["settings"]["system_colors"][0]["color"]);
			$theme_options["secondary_color"] = sanitize_hex_color_no_hash($data["settings"]["system_colors"][1]["color"]);
			$theme_options["tertiary_color"] = sanitize_hex_color_no_hash($data["settings"]["custom_colors"][0]["color"]);
			update_option($themename . "_options", $theme_options);
		}
	}
}
add_filter('elementor/document/after_save', 'mc_theme_elementor_after_save_system_colors', 10, 2);
?>