<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class MediCenterWidget_Timetable extends Widget_Base 
{

	public function get_name()
	{
		return 'timetable';
	}

	public function get_title()
	{
		return esc_html__("Timetable MediCenter", 'medicenter');
	}

	public function get_icon()
	{
		return 'eicon-calendar';
	}

	public function get_categories()
	{
		return ['medicenter'];
	}

	protected function is_dynamic_content():bool 
	{
		return false;
	}

	protected function register_controls()
	{
		//get departments list
		$departments_list = get_posts(array(
			'posts_per_page' => -1,
			'orderby' => 'menu_order',
			'order' => 'ASC',
			'post_type' => 'departments'
		));
		$departments_array = array();
		$departments_array["-"] = esc_html__("All", 'medicenter');
		foreach($departments_list as $department)
		{
			$departments_array[$department->post_name] = $department->post_title . " (id:" . $department->ID . ")";
		}
		
		//get all pages
		global $medicenter_pages_array;
		
		//get all hour categories
		global $wpdb;
		global $blog_id;
		$query = "SELECT distinct(category) AS category FROM " . $wpdb->prefix . "department_hours AS t1
				LEFT JOIN {$wpdb->posts} AS t2 ON t1.department_id=t2.ID 
				WHERE 
				t2.post_type='departments'
				AND t2.post_status='publish'
				AND category<>''";
		$hour_categories = $wpdb->get_results($query);
		$hour_categories_array = array();
		$hour_categories_array["-"] = esc_html__("All", 'medicenter');
		foreach($hour_categories as $hour_category)
		{
			$hour_categories_array[$hour_category->category] = $hour_category->category;
		}
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'medicenter'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'department',
			[
				'type' => \Elementor\Controls_Manager::SELECT2,
				'label' => esc_html__("Display selected", 'medicenter'),
				'options' => $departments_array,
				'multiple' => true,
				'default' => "-"
			]
		);
		$this->add_control(
			'mode',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Mode", 'medicenter'),
				'options' => [
					'24h' => esc_html__("24h (military time)", 'medicenter'),
					'12h' => esc_html__("12h (am/pm)", 'medicenter')
				],
				'default' => '24h'
			]
		);
		$this->add_control(
			'hour_category',
			[
				'type' => \Elementor\Controls_Manager::SELECT2,
				'label' => esc_html__("Display from hour category", 'medicenter'),
				'options' => $hour_categories_array,
				'multiple' => true,
				'default' => "-"
			]
		);
		$this->add_control(
			'departments_page',
			[
				'type' => (count($medicenter_pages_array) ? Controls_Manager::SELECT : Controls_Manager::TEXT),
				'label' => esc_html__("Departments page", 'medicenter'),
				'options' => (count($medicenter_pages_array) ? array_flip($medicenter_pages_array) : ''),
				'default' => (count($medicenter_pages_array) ? "-" : ""),
				'description' => (count($medicenter_pages_array) ? '' : esc_html__("Please provide departments page id", 'medicenter')),
			]
		);
		$this->add_control(
			'filter_style',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Filter style", 'medicenter'),
				'options' => [
					'dropdown_list' => esc_html__("dropdown list", 'medicenter'),
					'tabs' => esc_html__("tabs", 'medicenter')
				],
				'default' => 'dropdown_list'
			]
		);
		$this->add_control(
			'filter_title',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Filter title", 'medicenter'),
				'label_block' => false,
				'default' => esc_html__("All Departments", 'medicenter')
			]
		);
		$this->add_control(
			'tip_block',
			[
				'label' => esc_html__("Display tip block", 'medicenter'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'medicenter'),
				'label_off' => esc_html__('No', 'medicenter'),
				'return_value' => '1',
				'default' => '1'
			]
		);
		$this->end_controls_section();

	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		if(is_array($settings["department"]))
		{
			$department = "";
			foreach($settings["department"] as $key => $value)
			{
				$department .= $value . ($value!=end($settings["department"]) ? ',' : '');
			}
			$settings["department"] = $department;
		}
		echo mc_theme_timetable($settings);
	}

	protected function content_template(){}
}
?>
