<?php
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;

class MediCenterWidget_Photostream extends Widget_Base 
{

	public function get_name()
	{
		return 'photostream';
	}

	public function get_title()
	{
		return esc_html__("Photostream", 'medicenter');
	}

	public function get_icon()
	{
		return 'eicon-photo-library';
	}

	public function get_categories()
	{
		return ['medicenter'];
	}

	protected function is_dynamic_content():bool 
	{
		return false;
	}

	protected function register_controls()
	{
		//image sizes
		$image_sizes_array = array();
		$image_sizes_array["default"] = esc_html__("Default", 'medicenter');
		$image_sizes_array["full"] = esc_html__("full (original image resolution)", 'medicenter');
		global $_wp_additional_image_sizes;
		foreach(get_intermediate_image_sizes() as $s) 
		{
			if(isset($_wp_additional_image_sizes[$s])) 
			{
				$width = intval($_wp_additional_image_sizes[$s]['width']);
				$height = intval($_wp_additional_image_sizes[$s]['height']);
			}
			else
			{
				$width = get_option($s.'_size_w');
				$height = get_option($s.'_size_h');
			}
			$image_sizes_array[$s] = $s . " (" . $width . "x" . $height . ")";
		}
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'medicenter'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'photostream_id',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Id", 'medicenter'),
				'default' => "photostream",
				'label_block' => true
			]
		);
		$this->add_control(
			'images_repeater',
			[
				'label' => esc_html__("Images", 'medicenter'),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name' => 'image_title',
						'label' => esc_html__("Image title", 'medicenter'),
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__("Sample Title", 'medicenter')
					],
					[
						'name' => 'image',
						'label' => esc_html__("Image", 'medicenter'),
						'type' => Controls_Manager::MEDIA,
						'default' => [
							'url' => Utils::get_placeholder_image_src(),
						]
					]
				],
				'default' => [
					[
						'image_title' => esc_html__("Sample Title #1", 'medicenter')
					],
					[
						'image_title' => esc_html__("Sample Title #2", 'medicenter')
					],
					[
						'image_title' => esc_html__("Sample Title #3", 'medicenter')
					]
				],
				'title_field' => '{{{ image_title }}}',
			]
		);
		$this->add_control(
			'featured_image_size',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Featured image size", 'medicenter'),
				'options' => $image_sizes_array,
				'default' => 'default'
			]
		);
		$this->add_control(
			'features_images_loop',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Lightbox images loop", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'hover_icons',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Hover icons", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		if(!empty($settings["photostream_id"]))
		{
			$settings["id"] = $settings["photostream_id"];
		}
		echo mc_theme_photostream_shortcode($settings);
	}

	protected function content_template(){}
}
?>
