<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class MediCenterWidget_Items_List extends Widget_Base 
{

	public function get_name()
	{
		return 'items_list';
	}

	public function get_title()
	{
		return esc_html__("Items List", 'medicenter');
	}

	public function get_icon()
	{
		return 'eicon-editor-list-ul';
	}

	public function get_categories()
	{
		return ['medicenter'];
	}

	protected function is_dynamic_content():bool 
	{
		return false;
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'medicenter'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'type',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Controls position", 'medicenter'),
				'options' => [
					'items' => esc_html__("Items list", 'medicenter'),
					'info' => esc_html__("Info list", 'medicenter'),
					'scrolling' => esc_html__("Scrolling list", 'medicenter'),
					'simple' => esc_html__("Simple list", 'medicenter')
				],
				'default' => 'items'
			]
		);
		$this->add_control(
			'header',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Header", 'medicenter'),
				'default' => ""
			]
		);
		$this->add_control(
			'header_border_animation',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Header border animation", 'medicenter'),
				'options' => [
					'1' => esc_html__("yes", 'medicenter'),
					'0' => esc_html__("no", 'medicenter')
				],
				'default' => '0'
			]
		);
		$this->add_control(
			'top_margin_header',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Top margin header", 'medicenter'),
				'options' => [
					'none' => esc_html__("None", 'medicenter'),
					'page-margin-top' => esc_html__("Page (small)", 'medicenter'),
					'page-margin-top-section' => esc_html__("Section (large)", 'medicenter')
				],
				'default' => 'none'
			]
		);
		$this->add_control(
			'items',
			[
				'label' => esc_html__("Items", 'medicenter'),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name' => 'content',
						'label' => esc_html__("Content", 'medicenter'),
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__("Item", 'medicenter'),
						'label_block' => true
					],
					[
						'name' => 'value',
						'label' => esc_html__("Value", 'medicenter'),
						'type' => Controls_Manager::TEXT,
						'default' => '',
						'label_block' => true
					],
					[
						'name' => 'url',
						'label' => esc_html__("Url", 'medicenter'),
						'type' => Controls_Manager::URL,
						'options' => false,
						'label_block' => true
					],
					[
						'name' => 'url_target',
						'type' => Controls_Manager::SELECT,
						'label' => esc_html__("Url target", 'medicenter'),
						'options' => [
							'new_window' => esc_html__("new window", 'medicenter'),
							'same_window' => esc_html__("same window", 'medicenter')
						],
						'default' => 'new_window',
					],
					[
						'name' => 'type',
						'label' => esc_html__("Type", 'medicenter'),
						'type' => Controls_Manager::SELECT,
						'options' => [
							'items' => esc_html__("Items list", 'medicenter'),
							'info' => esc_html__("Info list", 'medicenter'),
							'scrolling' => esc_html__("Scrolling list", 'medicenter'),
							'simple' => esc_html__("Simple list", 'medicenter')
						],
						'default' => 'items'
					],
					[
						'name' => 'icon',
						'type' => Controls_Manager::SELECT,
						'label' => esc_html__("Icon", 'medicenter'),
						'options' => [
							'' => esc_html__("-", 'medicenter'),
							'check' => esc_html__("Check", 'medicenter'),
							'arrow-circle' => esc_html__("Arrow circle", 'medicenter'),
							'chevron' => esc_html__("Chevron", 'medicenter'),
							'tick-1' => esc_html__("Tick 1", 'medicenter'),
							'tick-2' => esc_html__("Tick 2", 'medicenter'),
							'arrow-horizontal-5' => esc_html__("Horizontal arrow", 'medicenter'),
							'arrow-horizontal-3' => esc_html__("Horizontal arrow small", 'medicenter'),
							'arrow-horizontal-1' => esc_html__("Horizontal arrow long", 'medicenter')
						],
						'default' => '',
					],
					[
						'name' => 'text_color',
						'type' => Controls_Manager::COLOR,
						'label' => esc_html__("Custom text color", 'medicenter'),
						'default' => ""
					],
					[
						'name' => 'value_color',
						'type' => Controls_Manager::COLOR,
						'label' => esc_html__("Custom value color", 'medicenter'),
						'default' => ""
					],
					[
						'name' => 'value_bg_color',
						'type' => Controls_Manager::COLOR,
						'label' => esc_html__("Custom value background color", 'medicenter'),
						'default' => ""
					],
					[
						'name' => 'border_color',
						'type' => Controls_Manager::COLOR,
						'label' => esc_html__("Custom border color", 'medicenter'),
						'default' => ""
					],
				],
				'default' => [
					[
						'content' => esc_html__("Item #1", 'medicenter')
					],
					[
						'content' => esc_html__("Item #2", 'medicenter')
					],
					[
						'content' => esc_html__("Item #3", 'medicenter')
					]
				],
				'title_field' => '{{{ content }}}'
			]
		);
		$this->add_control(
			'read_more',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Read more button", 'medicenter'),
				'options' => [
					'0' => esc_html__("No", 'medicenter'),
					'1' => esc_html__("Yes", 'medicenter')
				],
				'default' => '0'
			]
		);
		$this->add_control(
			'button_label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Button label", 'medicenter'),
				'default' => '',
				'condition' => [
					'read_more' => "1"
				]
			]
		);
		$this->add_control(
			'button_url',
			[
				'type' => Controls_Manager::URL,
				'label' => esc_html__("Button url", 'medicenter'),
				'options' => false,
				'label_block' => true,
				'condition' => [
					'read_more' => "1"
				]
			]
		);
		$this->add_control(
			'class_header',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Extra class name header", 'medicenter'),
				'default' => ''
			]
		);
		$this->add_control(
			'class',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Extra class name", 'medicenter'),
				'default' => ''
			]
		);
		$this->add_control(
			'top_margin',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Top margin", 'medicenter'),
				'options' => [
					'none' => esc_html__("None", 'medicenter'),
					'page-margin-top' => esc_html__("Page (small)", 'medicenter'),
					'page-margin-top-section' => esc_html__("Section (large)", 'medicenter')
				],
				'default' => 'none'
			]
		);
		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$settings["animation"] = $settings["header_border_animation"];
		if(!empty($settings["button_url"]))
		{
			$settings["button_url"] = $settings["button_url"]["url"];
		}
		echo mc_theme_items_list($settings, null);
	}

	protected function content_template(){}
}
?>
