<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class MediCenterWidget_Info_Box extends Widget_Base 
{

	public function get_name()
	{
		return 'info_box';
	}

	public function get_title()
	{
		return esc_html__("Info Box", 'medicenter');
	}

	public function get_icon()
	{
		return 'eicon-info-box';
	}

	public function get_categories()
	{
		return ['medicenter'];
	}

	protected function is_dynamic_content():bool 
	{
		return false;
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'medicenter'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Title", 'medicenter')
			]
		);
		$this->add_control(
			'icon',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Icon", 'medicenter'),
				'options' => [
					'none' => esc_html__("none", 'medicenter'),
					'address' => esc_html__("address", 'medicenter'),
					'ambulance' => esc_html__("ambulance", 'medicenter'),
					'app' => esc_html__("app", 'medicenter'),
					'baby' => esc_html__("baby", 'medicenter'),
					'baby-bed' => esc_html__("baby-bed", 'medicenter'),
					'baby-bottle' => esc_html__("baby-bottle", 'medicenter'),
					'bacteria' => esc_html__("bacteria", 'medicenter'),
					'balance' => esc_html__("balance", 'medicenter'),
					'battery' => esc_html__("battery", 'medicenter'),
					'book' => esc_html__("book", 'medicenter'),
					'box' => esc_html__("box", 'medicenter'),
					'brain' => esc_html__("brain", 'medicenter'),
					'briefcase' => esc_html__("briefcase", 'medicenter'),
					'burns' => esc_html__("burns", 'medicenter'),
					'cart' => esc_html__("cart", 'medicenter'),
					'cat' => esc_html__("cat", 'medicenter'),
					'certificate' => esc_html__("certificate", 'medicenter'),
					'chart' => esc_html__("chart", 'medicenter'),
					'chat' => esc_html__("chat", 'medicenter'),
					'clock' => esc_html__("clock", 'medicenter'),
					'config' => esc_html__("config", 'medicenter'),
					'credit-card' => esc_html__("credit-card", 'medicenter'),
					'cross' => esc_html__("cross", 'medicenter'),
					'dental-shield' => esc_html__("dental-shield", 'medicenter'),
					'dentist' => esc_html__("dentist", 'medicenter'),
					'diary' => esc_html__("diary", 'medicenter'),
					'dna' => esc_html__("dna", 'medicenter'),
					'doctor' => esc_html__("doctor", 'medicenter'),
					'document' => esc_html__("document", 'medicenter'),
					'document-missing' => esc_html__("document-missing", 'medicenter'),
					'dog' => esc_html__("dog", 'medicenter'),
					'drip' => esc_html__("drip", 'medicenter'),
					'ear' => esc_html__("ear", 'medicenter'),
					'email' => esc_html__("email", 'medicenter'),
					'eye' => esc_html__("eye", 'medicenter'),
					'facebook' => esc_html__("facebook", 'medicenter'),
					'first-aid' => esc_html__("first-aid", 'medicenter'),
					'fitness' => esc_html__("fitness", 'medicenter'),
					'frostbite' => esc_html__("frostbite", 'medicenter'),
					'gallery' => esc_html__("gallery", 'medicenter'),
					'glasses' => esc_html__("glasses", 'medicenter'),
					'graph' => esc_html__("graph", 'medicenter'),
					'healthcare' => esc_html__("healthcare", 'medicenter'),
					'heart' => esc_html__("heart", 'medicenter'),
					'heart-beat' => esc_html__("heart-beat", 'medicenter'),
					'home' => esc_html__("home", 'medicenter'),
					'hospital' => esc_html__("hospital", 'medicenter'),
					'id' => esc_html__("id", 'medicenter'),
					'image' => esc_html__("image", 'medicenter'),
					'keyboard' => esc_html__("keyboard", 'medicenter'),
					'lab' => esc_html__("lab", 'medicenter'),
					'laptop' => esc_html__("laptop", 'medicenter'),
					'leaf' => esc_html__("leaf", 'medicenter'),
					'lifeline' => esc_html__("lifeline", 'medicenter'),
					'list' => esc_html__("list", 'medicenter'),
					'location' => esc_html__("location", 'medicenter'),
					'lock' => esc_html__("lock", 'medicenter'),
					'map' => esc_html__("map", 'medicenter'),
					'medical-bed' => esc_html__("medical-bed", 'medicenter'),
					'medical-cast' => esc_html__("medical-cast", 'medicenter'),
					'medical-cross' => esc_html__("medical-cross", 'medicenter'),
					'medical-document' => esc_html__("medical-document", 'medicenter'),
					'medical-results' => esc_html__("medical-results", 'medicenter'),
					'medical-scissors' => esc_html__("medical-scissors", 'medicenter'),
					'medical-staff' => esc_html__("medical-staff", 'medicenter'),
					'minus' => esc_html__("minus", 'medicenter'),
					'mobile' => esc_html__("mobile", 'medicenter'),
					'molecule' => esc_html__("molecule", 'medicenter'),
					'money' => esc_html__("money", 'medicenter'),
					'mortar' => esc_html__("mortar", 'medicenter'),
					'movie' => esc_html__("movie", 'medicenter'),
					'network' => esc_html__("network", 'medicenter'),
					'paypal' => esc_html__("paypal", 'medicenter'),
					'pen' => esc_html__("pen", 'medicenter'),
					'people' => esc_html__("people", 'medicenter'),
					'pet-box' => esc_html__("pet-box", 'medicenter'),
					'phone' => esc_html__("phone", 'medicenter'),
					'piano' => esc_html__("piano", 'medicenter'),
					'pill' => esc_html__("pill", 'medicenter'),
					'pin' => esc_html__("pin", 'medicenter'),
					'plaster' => esc_html__("plaster", 'medicenter'),
					'play' => esc_html__("play", 'medicenter'),
					'plus' => esc_html__("plus", 'medicenter'),
					'printer' => esc_html__("printer", 'medicenter'),
					'pulse' => esc_html__("pulse", 'medicenter'),
					'quote' => esc_html__("quote", 'medicenter'),
					'science' => esc_html__("science", 'medicenter'),
					'screen' => esc_html__("screen", 'medicenter'),
					'signpost' => esc_html__("signpost", 'medicenter'),
					'spa' => esc_html__("spa", 'medicenter'),
					'spa-bamboo' => esc_html__("spa-bamboo", 'medicenter'),
					'spa-lotion' => esc_html__("spa-lotion", 'medicenter'),
					'speaker' => esc_html__("speaker", 'medicenter'),
					'stethoscope' => esc_html__("stethoscope", 'medicenter'),
					'syringe' => esc_html__("syringe", 'medicenter'),
					'tablet' => esc_html__("tablet", 'medicenter'),
					'tags' => esc_html__("tags", 'medicenter'),
					'teddy-bear' => esc_html__("teddy-bear", 'medicenter'),
					'test-tube' => esc_html__("test-tube", 'medicenter'),
					'tick' => esc_html__("tick", 'medicenter'),
					'time' => esc_html__("time", 'medicenter'),
					'toothbrush' => esc_html__("toothbrush", 'medicenter'),
					'twitter' => esc_html__("twitter", 'medicenter'),
					'video' => esc_html__("video", 'medicenter'),
					'wallet' => esc_html__("wallet", 'medicenter'),
					'x-ray' => esc_html__("x-ray", 'medicenter')
				],
				'default' => 'none',
			]
		);
		$this->add_control(
			'content',
			[
				'type' => Controls_Manager::WYSIWYG,
				'label' => esc_html__("Text", 'medicenter')
			]
		);
		$this->add_control(
			'box_animation',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Animation", 'medicenter'),
				'options' => [
					'' => esc_html__("none", 'medicenter'),
					'fadeIn' => esc_html__("fade in", 'medicenter'),
					'scale' => esc_html__("scale", 'medicenter'),
					'slideRight' => esc_html__("slide right", 'medicenter'),
					'slideRight200' => esc_html__("slide right 200%", 'medicenter'),
					'slideLeft' => esc_html__("slide left", 'medicenter'),
					'slideLeft50' => esc_html__("slide left 50%", 'medicenter'),
					'slideDown' => esc_html__("slide down", 'medicenter'),
					'slideDown200' => esc_html__("slide down 200%", 'medicenter'),
					'slideUp' => esc_html__("slide up", 'medicenter')
				],
				'default' => ''
			]
		);
		$this->add_control(
			'box_animation_duration',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Animation duration", 'medicenter'),
				'default' => 600
			]
		);
		$this->add_control(
			'animation_delay',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Animation delay", 'medicenter'),
				'default' => 0
			]
		);
		$this->add_control(
			'arrow',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Show box arrow", 'medicenter'),
				'options' => [
					'no' => esc_html__("No", 'medicenter'),
					'light' => esc_html__("Light color", 'medicenter'),
					'dark' => esc_html__("Dark color", 'medicenter')
				],
				'default' => 'no'
			]
		);
		$this->add_control(
			'arrow_animation',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Arrow animation", 'medicenter'),
				'options' => [
					'' => esc_html__("none", 'medicenter'),
					'fadeIn' => esc_html__("fade in", 'medicenter'),
					'scale' => esc_html__("scale", 'medicenter'),
					'slideRight' => esc_html__("slide right", 'medicenter'),
					'slideRight200' => esc_html__("slide right 200%", 'medicenter'),
					'slideLeft' => esc_html__("slide left", 'medicenter'),
					'slideLeft50' => esc_html__("slide left 50%", 'medicenter'),
					'slideDown' => esc_html__("slide down", 'medicenter'),
					'slideDown200' => esc_html__("slide down 200%", 'medicenter'),
					'slideUp' => esc_html__("slide up", 'medicenter')
				],
				'default' => '',
				'condition' => [
					'arrow' => ["light", "dark"]
				]
			]
		);
		$this->add_control(
			'arrow_animation_duration',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Animation duration", 'medicenter'),
				'default' => 600,
				'condition' => [
					'arrow' => ["light", "dark"]
				]
			]
		);
		$this->add_control(
			'arrow_animation_delay',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Arrow animation delay", 'medicenter'),
				'default' => 0,
				'condition' => [
					'arrow' => ["light", "dark"]
				]
			]
		);
		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$settings["animation"] = $settings["box_animation"];
		$settings["animation_duration"] = $settings["box_animation_duration"];
		echo mc_theme_info_box($settings, $settings["content"]);
	}

	protected function content_template(){}
}
?>
