<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class MediCenterWidget_Dropcap extends Widget_Base 
{

	public function get_name()
	{
		return 'dropcap';
	}

	public function get_title()
	{
		return esc_html__("Dropcap Text", 'medicenter');
	}

	public function get_icon()
	{
		return 'eicon-t-letter';
	}

	public function get_categories()
	{
		return ['medicenter'];
	}

	protected function is_dynamic_content():bool 
	{
		return false;
	}

	protected function register_controls()
	{
		$mc_colors_arr = array("#3156a3" => esc_html__("Dark blue", "medicenter"), "#0384ce" => esc_html__("Blue", "medicenter"), "#42b3e5" => esc_html__("Light blue", "medicenter"), "#000000" => esc_html__("Black", "medicenter"), "#AAAAAA" => esc_html__("Gray", "medicenter"), "#444444" => esc_html__("Dark gray", "medicenter"), "#CCCCCC" => esc_html__("Light gray", "medicenter"), "#43a140" => esc_html__("Green", "medicenter"), "#008238" => esc_html__("Dark green", "medicenter"), "#7cba3d" => esc_html__("Light green", "medicenter"), "#f17800" => esc_html__("Orange", "medicenter"), "#cb451b" => esc_html__("Dark orange", "medicenter"), "#ffa800" => esc_html__("Light orange", "medicenter"), "#db5237" => esc_html__("Red", "medicenter"), "#c03427" => esc_html__("Dark red", "medicenter"), "#f37548" => esc_html__("Light red", "medicenter"), "#0097b5" => esc_html__("Turquoise", "medicenter"), "#006688" => esc_html__("Dark turquoise", "medicenter"), "#00b6cc" => esc_html__("Turquoise", "medicenter"), "#00b6cc" => esc_html__("Light turquoise", "medicenter"), "#6969b3" => esc_html__("Violet", "medicenter"), "#3e4c94" => esc_html__("Dark violet", "medicenter"), "#9187c4" => esc_html__("Light violet", "medicenter"), "#FFFFFF" => esc_html__("White", "medicenter"), "#fec110" => esc_html__("Yellow", "medicenter"));

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'medicenter'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'dropcap_id',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Id", 'medicenter'),
				'default' => '',
				'description' => esc_html__("Please provide unique id for each dropcap on the same page/post if you would like to have custom content color for each one", 'medicenter')
			]
		);
		$this->add_control(
			'label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Label", 'medicenter'),
				'default' => '1'
			]
		);
		$this->add_control(
			'content',
			[
				'type' => Controls_Manager::WYSIWYG,
				'label' => esc_html__("Text", 'medicenter')
			]
		);
		$this->add_control(
			'label_background_color',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Label background color", 'medicenter'),
				'options' => $mc_colors_arr,
				'default' => "#3156a3",
				'description' => esc_html__("Button color.", "medicenter")
			]
		);
		$this->add_control(
			'custom_label_background_color',
			[
				'type' => Controls_Manager::COLOR,
				'label' => esc_html__("or pick custom label background color", 'medicenter'),
				'default' => ''
			]
		);
		$this->add_control(
			'label_color',
			[
				'type' => Controls_Manager::COLOR,
				'label' => esc_html__("Label text color", 'medicenter'),
				'default' => ''
			]
		);
		$this->add_control(
			'content_text_color',
			[
				'type' => Controls_Manager::COLOR,
				'label' => esc_html__("Content text color", 'medicenter'),
				'default' => '',
				'description' => esc_html__("If you would like to use 'Content text color', you need to fill 'Id' field", "medicenter")
			]
		);
		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		if(!empty($settings["dropcap_id"]))
		{
			$settings["id"] = $settings["dropcap_id"];
		}
		echo mc_theme_dropcap($settings, $settings["content"]);
	}

	protected function content_template(){}
}
?>
