<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class MediCenterWidget_Doctor_Description_Box extends Widget_Base
{

	public function get_name()
	{
		return 'doctor_description_box';
	}

	public function get_title()
	{
		return esc_html__("Doctor Description Box", 'medicenter');
	}

	public function get_icon()
	{
		return 'eicon-text';
	}

	public function get_categories()
	{
		return ['medicenter'];
	}

	protected function is_dynamic_content():bool 
	{
		return true;
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'medicenter'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'info',
			[
				'type' => Controls_Manager::ALERT,
				'alert_type' => 'info',
				'heading' => esc_html__("Doctor Description content", 'medicenter'),
				'content' => __('This widget does not have configurable parameters. The content of the specific doctor\'s description will be displayed in its place.<br><br>You can edit the doctor\'s description in the WordPress editor under the \'Options\' box located below the content editor.', 'medicenter')
			]
		);
		$this->end_controls_section();

	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		echo mc_theme_doctor_description_box($settings);
	}

	protected function content_template(){}
}
?>
