<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class MediCenterWidget_Doctor_Box extends Widget_Base 
{

	public function get_name()
	{
		return 'doctor_box';
	}

	public function get_title()
	{
		return esc_html__("Doctor Box", 'medicenter');
	}

	public function get_icon()
	{
		return 'eicon-site-identity';
	}

	public function get_categories()
	{
		return ['medicenter'];
	}

	protected function is_dynamic_content():bool 
	{
		return true;
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'medicenter'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title_box',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Title box", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1',
			]
		);
		$this->add_control(
			'display_social_icons',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Display social icons", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1',
			]
		);
		$this->add_control(
			'hover_icons',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Hover icons", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1',
			]
		);
		$this->end_controls_section();

	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		echo mc_theme_doctor_box($settings);
	}

	protected function content_template(){}
}
?>
