<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class MediCenterWidget_Contact_Form extends Widget_Base 
{

	public function get_name()
	{
		return 'medicenter_contact_form';
	}

	public function get_title()
	{
		return esc_html__("Contact Form", 'medicenter');
	}

	public function get_icon()
	{
		return 'eicon-form-horizontal';
	}

	public function get_categories()
	{
		return ['medicenter'];
	}

	protected function is_dynamic_content():bool 
	{
		return true;
	}

	protected function register_controls()
	{
		global $theme_options;
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'medicenter'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'form_id',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Id", 'medicenter'),
				'default' => 'contact_form',
				'description' => esc_html__("Please provide unique id for each contact form on the same page/post", 'medicenter')
			]
		);
		$this->add_control(
			'header',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Header", 'medicenter'),
				'default' => esc_html__("Online Appointment Form ", 'medicenter')
			]
		);
		$this->add_control(
			'header_border_animation',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Header border animation", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '0'
			]
		);
		$this->add_control(
			'department_select_box',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Display department select box", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'department_select_box_title',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Department select box title", 'medicenter'),
				'default' => esc_html__("Select Department", 'medicenter'),
				'condition' => [
					'department_select_box' => "1",
				]
			]
		);
		$this->add_control(
			'submit_label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Submit label", 'medicenter'),
				'default' => esc_html__("SEND", 'medicenter')
			]
		);
		$this->add_control(
			'display_first_name',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Display first name field", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'first_name_label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("First name label", 'medicenter'),
				'default' => esc_html__("FIRST NAME", 'medicenter'),
				'condition' => [
					'display_first_name' => "1",
				]
			]
		);
		$this->add_control(
			'first_name_required',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("First name field required", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1',
				'condition' => [
					'display_first_name' => "1",
				]
			]
		);
		$this->add_control(
			'display_last_name',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Display last name field", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'last_name_label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Last name label", 'medicenter'),
				'default' => esc_html__("LAST NAME", 'medicenter'),
				'condition' => [
					'display_last_name' => "1",
				]
			]
		);
		$this->add_control(
			'last_name_required',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Last name field required", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1',
				'condition' => [
					'display_last_name' => "1",
				]
			]
		);
		$this->add_control(
			'display_date',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Display date field", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'date_label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Date of birth label", 'medicenter'),
				'default' => esc_html__("DATE OF BIRTH", 'medicenter'),
				'condition' => [
					'display_date' => "1",
				]
			]
		);
		$this->add_control(
			'date_required',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Date of birth field required", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1',
				'condition' => [
					'display_date' => "1",
				]
			]
		);
		$this->add_control(
			'display_security_number',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Display security number field", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'security_number_label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Security number label", 'medicenter'),
				'default' => esc_html__("SOCIAL SECURITY NUMBER", 'medicenter'),
				'condition' => [
					'display_security_number' => "1",
				]
			]
		);
		$this->add_control(
			'security_number_required',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Security number field required", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '0',
				'condition' => [
					'display_security_number' => "1",
				]
			]
		);
		$this->add_control(
			'display_phone',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Display phone field", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'phone_label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Phone label", 'medicenter'),
				'default' => esc_html__("PHONE NUMBER", 'medicenter'),
				'condition' => [
					'display_phone' => "1",
				]
			]
		);
		$this->add_control(
			'phone_required',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Phone field required", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '0',
				'condition' => [
					'display_phone' => "1",
				]
			]
		);
		$this->add_control(
			'display_email',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Display email field", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'email_label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Email label", 'medicenter'),
				'default' => esc_html__("E-MAIL", 'medicenter'),
				'condition' => [
					'display_email' => "1",
				]
			]
		);
		$this->add_control(
			'email_required',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Email field required", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1',
				'condition' => [
					'display_email' => "1",
				]
			]
		);
		$this->add_control(
			'display_message',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Display message field", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'message_label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Message label", 'medicenter'),
				'default' => esc_html__("REASON OF APPOINTMENT", 'medicenter'),
				'condition' => [
					'display_message' => "1",
				]
			]
		);
		$this->add_control(
			'message_required',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Message field required", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '1',
				'condition' => [
					'display_message' => "1",
				]
			]
		);
		$this->add_control(
			'description',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Description", 'medicenter'),
				'default' => esc_html__("We will contact you within one business day.", 'medicenter')
			]
		);
		$this->add_control(
			'terms_checkbox',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Terms and conditions checkbox", 'medicenter'),
				'options' => [
					'1' => esc_html__("Yes", 'medicenter'),
					'0' => esc_html__("No", 'medicenter')
				],
				'default' => '0'
			]
		);
		$this->add_control(
			'terms_message',
			[
				'type' => Controls_Manager::TEXTAREA,
				'label' => esc_html__("Terms and conditions message", 'medicenter'),
				'rows' => 5,
				'default' => esc_html__("Please accept terms and conditions", 'medicenter'),
				'condition' => [
					'terms_checkbox' => "1",
				]
			]
		);
		$this->add_control(
			'recaptcha',
			[
				'label' => esc_html__("reCaptcha", 'medicenter'),
				'type' => Controls_Manager::RAW_HTML,
				'raw' => '<div class="elementor-control-input-wrapper elementor-control-unit-5 elementor-control-dynamic-switcher-wrapper">
					<input type="text" class="tooltip-target elementor-control-tag-area" data-tooltip="" data-setting="recaptcha" placeholder="" original-title="" value="' . ((int)$theme_options["google_recaptcha"] ? esc_html__("Yes", 'medicenter') : esc_html__("No", 'medicenter')) . '">
				</div><div class="elementor-control-field-description">' . sprintf(__("You can change this setting under <a href='%s' title='Theme Options'>Theme Options</a>", 'medicenter'), esc_url(admin_url("themes.php?page=ThemeOptions"))) . '</div>',
				'classes' => "medicenter-elementor-readonly"
			]
		);
		$this->end_controls_section();

	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$settings["animation"] = $settings["header_border_animation"];
		if(!empty($settings["form_id"]))
		{
			$settings["id"] = $settings["form_id"];
		}
		echo mc_theme_contact_form_shortcode($settings);
	}

	protected function content_template(){}
}
?>