<?php
// phpcs:ignoreFile

$email_templates = array(
	'stm_lms_course_added'                            => array(
		'section' => 'instructors',
		'notice'  => esc_html__( 'Send an email to the admin when the instructor has added their course', 'masterstudy-lms-learning-management-system-pro' ),
		'subject' => esc_html__( 'Course added', 'masterstudy-lms-learning-management-system-pro' ),
		'message' => esc_html__( 'Course {{course_title}} {{action}} by instructor, your ({{user_login}}). Please review this information from the admin Dashboard', 'masterstudy-lms-learning-management-system-pro' ),
		'vars'    => array(
			'action'          => esc_html__( 'Added or updated action made by instructor', 'masterstudy-lms-learning-management-system-pro' ),
			'user_login'      => esc_html__( 'Instructor login', 'masterstudy-lms-learning-management-system-pro' ),
			'course_title'    => esc_html__( 'Course name', 'masterstudy-lms-learning-management-system-pro' ),
			'blog_name'       => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'        => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'            => esc_html__(
				'Date',
				'masterstudy-lms-learning-management-system-pro'
			),
			'dashboard_url'   => esc_html__(
				'Dashboard URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_edit_url' => esc_html__(
				'Course edit URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_url'      => esc_html__(
				'Course URL',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_course_published'                        => array(
		'section' => 'instructors',
		'notice'  => esc_html__(
			'Send an email to the instructor when the course is published',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'Course published',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => esc_html__(
			'Your course - {{course_title}} was approved, and is now live on the website',
			'masterstudy-lms-learning-management-system-pro'
		),
		'vars'    => array(
			'course_title'    => esc_html__(
				'Course Title',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name'       => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'        => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'            => esc_html__(
				'Date',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_edit_url' => esc_html__(
				'Course edit URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_url'      => esc_html__(
				'Course URL',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_become_instructor_email'                 => array(
		'section' => 'instructors',
		'notice'  => esc_html__(
			'Become an instructor',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'New Instructor Application',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => esc_html__( 'You have received a new instructor application from ', 'masterstudy-lms-learning-management-system-pro' ) . ' {{user_login}}, <br/>' . // phpcs:disable
		             esc_html__( 'Here are the details:', 'masterstudy-lms-learning-management-system-pro' ) . ' <br/>' .
		             '<b>' . esc_html__( 'Name: ', 'masterstudy-lms-learning-management-system-pro' ) . '</b>' . ' {{user_login}} <br>' .
		             '<b>' . esc_html__( 'ID: ', 'masterstudy-lms-learning-management-system-pro' ) . '</b>' . ' {{user_id}} <br>' .
		             '<b>' . esc_html__( 'Email: ', 'masterstudy-lms-learning-management-system-pro' ) . '</b>' . ' {{user_email}} <br>' .
		             '<b>' . esc_html__( 'Degree: ', 'masterstudy-lms-learning-management-system-pro' ) . '</b>' . ' {{degree}} <br>' .
		             '<b>' . esc_html__( 'Expertize: ', 'masterstudy-lms-learning-management-system-pro' ) . '</b>' . ' {{expertize}} <br>' .
		             '<b>' . esc_html__( 'Application Date: ', 'masterstudy-lms-learning-management-system-pro' ) . '</b>' . ' {{date}} <br><br>' .
		             esc_html__( 'Please review the application at your earliest convenience.', 'masterstudy-lms-learning-management-system-pro' ) . '</a> <br/><br/>',
		// phpcs:enable
		'vars'    => array(
			'user_login' => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'user_id'    => esc_html__(
				'User ID',
				'masterstudy-lms-learning-management-system-pro'
			),
			'user_email' => esc_html__(
				'User email',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name'  => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'   => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'       => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
			'degree'     => esc_html__(
				'Degree',
				'masterstudy-lms-learning-management-system-pro'
			),
			'expertize'  => esc_html__(
				'Expertize',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_lesson_comment'                          => array(
		'section' => 'lessons',
		'notice'  => esc_html__(
			'Q&A Message (email to instructors)',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'New lesson comment',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => '{{user_login}} commented - "{{comment_content}}" on lesson {{lesson_title}} in the course {{course_title}}',
		'vars'    => array(
			'user_login'      => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'comment_content' => esc_html__(
				'Comment content',
				'masterstudy-lms-learning-management-system-pro'
			),
			'lesson_title'    => esc_html__(
				'Lesson title',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_title'    => esc_html__(
				'Course title',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name'       => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'        => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_url'      => esc_html__(
				'Course URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'            => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_lesson_qeustion_ask_answer'              => array(
		'section' => 'lessons',
		'notice'  => esc_html__(
			'Replies to comments',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'New Reply to Your Comment in {{lesson_title}}',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => wp_kses_post(
			'Hi {{user_login}} <br>
			You have received a new reply to your comment in the lesson {{lesson_title}} of the course {{course_title}}.<br>
			{{comment_content}}<br>
			You can view the full conversation and reply here: <a href="{{lesson_url}}">Lesson URL</a>. <br>
			Keep the discussion going!'
		),
		'vars'    => array(
			'user_login'      => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'comment_content' => esc_html__(
				'Comment content',
				'masterstudy-lms-learning-management-system-pro'
			),
			'lesson_title'    => esc_html__(
				'Lesson title',
				'masterstudy-lms-learning-management-system-pro'
			),
			'lesson_url'      => esc_html__(
				'Lesson URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_title'    => esc_html__(
				'Course title',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name'       => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'        => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'            => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_url'      => esc_html__(
				'Course URL',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_account_premoderation'                   => array(
		'section' => 'account',
		'notice'  => esc_html__(
			'Account Premoderation',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'Activate your account',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => esc_html__( 'Hi', 'masterstudy-lms-learning-management-system-pro' ) . ' {{user_login}},<br/>' .
		             esc_html__( 'Welcome to', 'masterstudy-lms-learning-management-system-pro' ) . ' {{blog_name}}! ' .
		             esc_html__( 'To start using your account, please activate it by clicking the link below:', 'masterstudy-lms-learning-management-system-pro' ) . '<br/>' .
		             esc_html__( 'Activation Link:', 'masterstudy-lms-learning-management-system-pro' ) . ' <a href="{{reset_url}}">' .
		             esc_html__( 'Activate here', 'masterstudy-lms-learning-management-system-pro' ) . '</a> <br/><br/>' .
		             esc_html__( 'We look forward to seeing you on', 'masterstudy-lms-learning-management-system-pro' ) . ' {{blog_name}}!',
		'vars'    => array(
			'blog_name'  => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'reset_url'  => esc_html__(
				'Reset URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'user_login' => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'   => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'       => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_new_user_register_on_site'               => array(
		'section' => 'account',
		'notice'  => esc_html__(
			'New User Registration',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'New User Registered',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => 'A new user has just registered on the site. <br> Here are the details: <br>
			Name: {{user_login}} <br>
			Email: {{user_email}} <br>
			Registration Date: {{registration_date}} <br>
			Please welcome our new member!',
		'vars'    => array(
			'user_login'        => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'user_email'        => esc_html__(
				'User email',
				'masterstudy-lms-learning-management-system-pro'
			),
			'registration_date' => esc_html__(
				'Registration date',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name'         => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'          => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_user_registered_on_site'                 => array(
		'section' => 'account',
		'notice'  => esc_html__(
			'Register on the website',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'You have successfully registered on the website.',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => 'Hi {{user_login}},<br> Welcome to {{blog_name}}! Your registration was successful.<br> You can now log in to your account using the following link: <br>Login URL: <a href="{{login_url}}">Login url</a> <br><br>We are thrilled to have you on board!',
		'vars'    => array(
			'blog_name'  => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'user_login' => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'user_id'    => esc_html__(
				'User ID',
				'masterstudy-lms-learning-management-system-pro'
			),
			'login_url'  => esc_html__(
				'Login URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'   => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'       => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_email_user_reset_password'               => array(
		'section' => 'account',
		'notice'  => esc_html__(
			'Reset Password Request',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'Password Reset Request',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => 'Dear  {{user_login}},<br> There has been a request to reset your password for your account on {{blog_name}}.
					<br> To reset your password and set a new one, click on the link below: <br>
					<a href="{{reset_url}}" target="_blank">Reset url</a>
					<br>If you did not request this change, please ignore this email.',
		'vars'    => array(
			'user_login' => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name'  => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'reset_url'  => esc_html__(
				'Reset URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'   => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'       => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_user_added_via_manage_students'          => array(
		'section' => 'account',
		'notice'  => esc_html__(
			'Users added via Manage Students',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'You have been registered on the website.',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => 'Login: {{username}} Password {{password}} Site URL: {{site_url}}. ',
		'vars'    => array(
			'username'  => esc_html__(
				'Username',
				'masterstudy-lms-learning-management-system-pro'
			),
			'password'  => esc_html__(
				'Password',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'  => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name' => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'      => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
			'login_url' => esc_html__(
				'Login URL',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_password_change'                         => array(
		'section' => 'account',
		'notice'  => esc_html__(
			'Password changed',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'Password change',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => 'Password changed successfully.',
		'vars'    => array(
			'user_login' => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name'  => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'   => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'       => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_enterprise'                              => array(
		'section' => 'enterprise',
		'notice'  => esc_html__(
			'Enterprise Request',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'New Enterprise Inquiry',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => esc_html__( 'You have received a new enterprise inquiry from the "For Enterprise" form.', 'masterstudy-lms-learning-management-system-pro' ) . ' <br/>' . // phpcs:disable
		             esc_html__( 'Here are the details:', 'masterstudy-lms-learning-management-system-pro' ) . ' <br/>' .
		             '<b>' . esc_html__( 'Name: ', 'masterstudy-lms-learning-management-system-pro' ) . '</b>' . ' {{name}} <br>' .
		             '<b>' . esc_html__( 'Email: ', 'masterstudy-lms-learning-management-system-pro' ) . '</b>' . ' {{email}} <br>' .
		             '<b>' . esc_html__( 'Message: ', 'masterstudy-lms-learning-management-system-pro' ) . '</b>' . ' {{text}} <br>' .
		             '<b>' . esc_html__( 'Submission Date: ', 'masterstudy-lms-learning-management-system-pro' ) . '</b>' . ' {{date}} <br><br/>' .
		             esc_html__( 'Please review this inquiry and follow up as needed.', 'masterstudy-lms-learning-management-system-pro' ) . '</a> <br/>',
		// phpcs:enable
		'vars'    => array(
			'name'      => esc_html__( 'Name', 'masterstudy-lms-learning-management-system-pro' ),
			'email'     => esc_html__(
				'Email',
				'masterstudy-lms-learning-management-system-pro'
			),
			'text'      => esc_html__( 'Text', 'masterstudy-lms-learning-management-system-pro' ),
			'date'      => esc_html__( 'Submission Date', 'masterstudy-lms-learning-management-system-pro' ),
			'blog_name' => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'  => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_new_order'                               => array(
		'section'               => 'order',
		'notice'                => esc_html__(
			'Order message for Admin',
			'masterstudy-lms-learning-management-system-pro'
		),
		'title'                 => esc_html__( 'New order', 'masterstudy-lms-learning-management-system-pro' ),
		'subject'               => esc_html__(
			'New order',
			'masterstudy-lms-learning-management-system-pro'
		),
		'date_order_render'     => esc_html__( 'Date', 'masterstudy-lms-learning-management-system-pro' ),
		'order_order_render'    => esc_html__( 'Order ID', 'masterstudy-lms-learning-management-system-pro' ),
		'title_order_render'    => esc_html__( 'Title', 'masterstudy-lms-learning-management-system-pro' ),
		'items_order_render'    => esc_html__( 'Items list', 'masterstudy-lms-learning-management-system-pro' ),
		'customer_order_render' => esc_html__( 'User section', 'masterstudy-lms-learning-management-system-pro' ),
		'button_order_render'   => esc_html__( 'Button', 'masterstudy-lms-learning-management-system-pro' ),
		'message'               => 'An order has been placed on your site from the user {{user_login}}. Log in to your admin dashboard to view the sale and check your earnings.',
		'vars'                  => array(
			'user_login'    => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'student_email' => esc_html__(
				'Student Email',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name'     => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'      => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'          => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_new_order_instructor'                    => array(
		'section'               => 'order',
		'notice'                => esc_html__(
			'Order message for Instructor',
			'masterstudy-lms-learning-management-system-pro'
		),
		'title'                 => esc_html__( 'You made a Sale!', 'masterstudy-lms-learning-management-system-pro' ),
		'subject'               => esc_html__(
			'You made a Sale!',
			'masterstudy-lms-learning-management-system-pro'
		),
		'date_order_render'     => esc_html__( 'Date', 'masterstudy-lms-learning-management-system-pro' ),
		'order_order_render'    => esc_html__( 'Order ID', 'masterstudy-lms-learning-management-system-pro' ),
		'title_order_render'    => esc_html__( 'Title', 'masterstudy-lms-learning-management-system-pro' ),
		'items_order_render'    => esc_html__( 'Items list', 'masterstudy-lms-learning-management-system-pro' ),
		'customer_order_render' => esc_html__( 'User section', 'masterstudy-lms-learning-management-system-pro' ),
		'button_order_render'   => esc_html__( 'Button', 'masterstudy-lms-learning-management-system-pro' ),
		'message'               => 'Congratulations! A new purchase has been made. Open your instructor dashboard to check the new Order from the user {{user_login}}.',
		'vars'                  => array(
			'user_login'    => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name'     => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'      => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'student_email' => esc_html__(
				'Student email',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'          => esc_html__(
				'Purchase date',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_new_order_accepted'                      => array(
		'section'             => 'order',
		'notice'              => esc_html__(
			'Order message for Student',
			'masterstudy-lms-learning-management-system-pro'
		),
		'title'               => esc_html__( 'Thank you for purchase!', 'masterstudy-lms-learning-management-system-pro' ),
		'subject'             => esc_html__(
			'Thank you for purchase!',
			'masterstudy-lms-learning-management-system-pro'
		),
		'date_order_render'   => esc_html__( 'Date', 'masterstudy-lms-learning-management-system-pro' ),
		'order_order_render'  => esc_html__( 'Order ID', 'masterstudy-lms-learning-management-system-pro' ),
		'title_order_render'  => esc_html__( 'Title', 'masterstudy-lms-learning-management-system-pro' ),
		'items_order_render'  => esc_html__( 'Items list', 'masterstudy-lms-learning-management-system-pro' ),
		'button_order_render' => esc_html__( 'Button', 'masterstudy-lms-learning-management-system-pro' ),
		'message'             => 'Your access is now ready. Dive in and start your journey toward new skills and achievements today!',
		'vars'                => array(
			'user_login' => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name'  => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'   => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'       => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_course_added_to_user'                    => array(
		'section' => 'course',
		'notice'  => esc_html__(
			'Course added to User (for admin)',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'Course added to User',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => 'Course {{course_title}} was added to {{login}}.',
		'vars'    => array(
			'course_title' => esc_html__(
				'Course title',
				'masterstudy-lms-learning-management-system-pro'
			),
			'login'        => esc_html__(
				'Login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name'    => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'     => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'         => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_url'   => esc_html__(
				'Course URL',
				'masterstudy-lms-learning-management-system-pro'
			),

		),
	),
	'stm_lms_course_available_for_user'               => array(
		'section' => 'course',
		'notice'  => esc_html__(
			'Course added to User (for user)',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'Course added.',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => 'Course {{course_title}} is now available to learn.',
		'vars'    => array(
			'course_title' => esc_html__(
				'Course title',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name'    => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'user_login'   => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'     => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'         => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_url'   => esc_html__(
				'Course URL',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_email_remove_student_from_course'        => array(
		'section' => 'course',
		'notice'  => esc_html__(
			'Remove user from the course',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'Your Enrollment Has Been Cancelled',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => wp_kses_post( 'Dear {{user_login}},<br>{{instructor_name}} has removed you from the course - {{course_title}}. <br>  Now you don’t have access to the course content.' ),
		'vars'    => array(
			'instructor_name' => esc_html__(
				'Instructor name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_title'    => esc_html__(
				'Course title',
				'masterstudy-lms-learning-management-system-pro'
			),
			'user_login'      => esc_html__(
				'Student name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'        => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'            => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name'       => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_course_quiz_completed_for_user'          => array(
		'section' => 'course',
		'notice'  => esc_html__(
			'Quiz Completed (email to student)',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'You’ve Completed the Quiz in {{course_title}}',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => wp_kses_post(
			'Hi {{user_login}}, <br>
				You’ve just completed the quiz "{{quiz_name}}" in the course "{{course_title}}". Great work!<br>
				<b>Here’s a summary of your attempt:</b><br>
				<ul style="text-align: left;">
					<li> <b>Course:</b> {{course_title}}  </li>
					<li> <b>Quiz:</b> {{quiz_name}}  </li>
					<li> <b>Your Result:</b> {{quiz_result}}  </li>
					<li> <b>Passing Grade:</b> {{quiz_passing_grade}}  </li>
					<li> <b>Completion Date:</b> {{quiz_completion_date}}  </li>
				</ul>
				Keep it up - each step brings you closer to your learning goals!'
		),
		'vars'    => array(
			'user_login'           => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_title'         => esc_html__(
				'Course title',
				'masterstudy-lms-learning-management-system-pro'
			),
			'quiz_name'            => esc_html__(
				'Quiz name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'quiz_result'          => esc_html__(
				'Quiz result',
				'masterstudy-lms-learning-management-system-pro'
			),
			'quiz_passing_grade'   => esc_html__(
				'Quiz passing grade',
				'masterstudy-lms-learning-management-system-pro'
			),
			'quiz_completion_date' => esc_html__(
				'Quiz Completion Date',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name'            => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'             => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'quiz_url'             => esc_html__(
				'Quiz URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'attempt_url'          => esc_html__(
				'Attempt URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'attempt_number'       => esc_html__(
				'Attempt Number',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_course_quiz_completed_for_instructor'    => array(
		'section' => 'course',
		'notice'  => esc_html__(
			'Quiz Completed (for instructor)',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'{{user_login}} has completed the quiz {{quiz_name}} in {{course_title}}',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => wp_kses_post(
			'We\'re pleased to inform you that {{user_login}} has completed the quiz "{{quiz_name}}" in the course {{course_title}}.<br>
			Quiz Result: {{quiz_result}}<br>
			Completion Date: {{quiz_completion_date}} <br>'
		),
		'vars'    => array(
			'user_login'           => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_title'         => esc_html__(
				'Course title',
				'masterstudy-lms-learning-management-system-pro'
			),
			'quiz_name'            => esc_html__(
				'Quiz name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'quiz_result'          => esc_html__(
				'Quiz result',
				'masterstudy-lms-learning-management-system-pro'
			),
			'quiz_completion_date' => esc_html__(
				'Quiz Completion Date',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name'            => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'             => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'quiz_url'             => esc_html__(
				'Quiz URL',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_course_completed_for_user'               => array(
		'section' => 'course',
		'notice'  => esc_html__(
			'Course completion to students',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'Congratulations on completing {{course_title}}!',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => wp_kses_post(
			'We want to congratulate you on successfully completing the <b>{{course_title}}</b>!
			<br> The link to course: <a href="{{course_url}}" target="_blank">{{course_url}}</a>
			<br> We wish you all the best in your future endeavors.'
		),
		'vars'    => array(
			'user_login'   => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_title' => esc_html__(
				'Course title',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_url'   => esc_html__(
				'Course URL',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_course_completed_for_instructor'         => array(
		'section' => 'course',
		'notice'  => esc_html__(
			'Course completion to instructors',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'Congratulations! {{user_login}} Completed {{course_title}}!',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => wp_kses_post(
			'{{user_login}} has successfully completed your {{course_title}} with great dedication and achievement.
			<br> The link to course: <a href="{{course_url}}" target="_blank">{{course_url}}</a>
			<br> Your support has made all the difference. Thank you for your dedication to student’s success.'
		),
		'vars'    => array(
			'user_login'   => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_title' => esc_html__(
				'Course title',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_url'   => esc_html__(
				'Course URL',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_course_expiration_for_students'         => array(
		'section' => 'course',
		'notice'  => esc_html__(
			'Course Expiration Notification for Students',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'Your Access to {{course_title}} Has Ended',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => wp_kses_post(
			'Hi {{user_login}},<br>
			We hope you enjoyed learning with us! Unfortunately, your access to the {{course_title}} course ended on {{course_expiration_date}}.
			Happy learning,<br>
			{{blog_name}}<br>
			{{site_url}}'
		),
		'vars'    => array(
			'user_login'   => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_title' => esc_html__(
				'Course title',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_url' => esc_html__(
				'Course URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_expiration_date'   => esc_html__(
				'Course Expiration Date',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name'    => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'     => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_student_lesson_completed_for_instructor' => array(
		'section' => 'lessons',
		'notice'  => esc_html__(
			'Lesson completion notification for instructors',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__( '{{user_login}} Has Completed a Lesson in {{course_title}}', 'masterstudy-lms-learning-management-system' ),
		'message' => wp_kses_post(
			'We are pleased to inform you that {{user_login}} has completed the lesson {{lesson_title}} in the course {{course_title}}.'
		),
		'vars'    => array(
			'user_login'   => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_title' => esc_html__(
				'Course title',
				'masterstudy-lms-learning-management-system-pro'
			),
			'lesson_title' => esc_html__(
				'Lesson title',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_url'   => esc_html__(
				'Course URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name'    => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'     => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'         => esc_html__(
				'Application date',

			),
		),
	),
	'stm_lms_membership_course_available_for_admin'   => array(
		'section' => 'course',
		'notice'  => esc_html__( 'Course added with Membership Plan to User (for admin)', 'masterstudy-lms-learning-management-system-pro' ),
		'subject' => esc_html__( 'Course added with Membership Plan.', 'masterstudy-lms-learning-management-system-pro' ),
		'message' => 'Course {{course_title}} was added to {{login}} with {{membership_plan}}.',
		'vars'    => array(
			'course_title'    => esc_html__( 'Course title', 'masterstudy-lms-learning-management-system-pro' ),
			'membership_plan' => esc_html__( 'Plan name', 'masterstudy-lms-learning-management-system-pro' ),
			'blog_name'       => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'        => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'            => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_url'      => esc_html__(
				'Course URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'login'           => esc_html__(
				'Login',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_membership_course_available_for_user'    => array(
		'section' => 'course',
		'notice'  => esc_html__( 'Course added with Membership Plan to User (for user)', 'masterstudy-lms-learning-management-system-pro' ),
		'subject' => esc_html__( 'Course added to User', 'masterstudy-lms-learning-management-system-pro' ),
		'message' => 'Course {{course_title}} is now available to learn with {{membership_plan}}.',
		'vars'    => array(
			'course_title'    => esc_html__( 'Course title', 'masterstudy-lms-learning-management-system-pro' ),
			'membership_plan' => esc_html__( 'Plan name', 'masterstudy-lms-learning-management-system-pro' ),
			'blog_name'       => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'        => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'            => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_url'      => esc_html__(
				'Course URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'user_login'      => esc_html__(
				'User Login',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_announcement_from_instructor'            => array(
		'section' => 'instructors',
		'notice'  => esc_html__(
			'Announcement from the Instructor',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'New Announcement in {{course_title}}',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => wp_kses_post(
			'Hi {{user_login}}, <br>
				Exciting news! {{instructor_name}} has just published a new announcement for your course, {{course_title}}.<br>
				Announcement: {{mail}} <br>
				Stay tuned for more updates!'
		),
		'vars'    => array(
			'course_title'    => esc_html__(
				'Course title',
				'masterstudy-lms-learning-management-system-pro'
			),
			'user_login'      => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'instructor_name' => esc_html__(
				'Instructor name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'mail'            => esc_html__(
				'Instructor message',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_url'      => esc_html__(
				'Course URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name'       => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'        => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'            => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_student_enrollment_in_course_to_author'  => array(
		'section' => 'instructors',
		'notice'  => esc_html__(
			'New enrollment in course',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'New Enrollment in {{course_title}}!',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => wp_kses_post(
			'Great news! <br>
			{{user_login}} has just enrolled in your course {{course_title}} on {{date}}.<br>
			Thank you for your valuable contribution to our platform. Keep up the fantastic work!'
		),
		'vars'    => array(
			'user_login'   => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_title' => esc_html__(
				'Course title',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'         => esc_html__(
				'Purchase date',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_assignment_checked'                      => array(
		'section' => 'assignment',
		'notice'  => esc_html__(
			'Assignment status change (for student)',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'Your Assignment on {{course_title}} Has Been Reviewed',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => wp_kses_post(
			' Dear {{user_login}}, <br>
			Your assignment "{{assignment_title}}" in the course "{{course_title}}" has just been reviewed by {{instructor_name}}.<br>
			Result: {{assignment_result}} <br>
			Assignment Mark: {{assignment_mark}}<br>
			Instructor\'s Comment: <br>
			{{assignment_comment}} <br>
			Detailed Feedback and Assignment <a href="{{assignment_url}}" target="_blank">here</a> <br>
			Keep going — you\'re making great progress! If you have questions or need clarification, feel free to reach out to your instructor.'
		),
		'vars'    => array(
			'blog_name'          => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'           => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'               => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
			'assignment_result'  => esc_html__(
				'Assignment result',
				'masterstudy-lms-learning-management-system-pro'
			),
			'assignment_comment' => esc_html__(
				'Assignment comment',
				'masterstudy-lms-learning-management-system-pro'
			),
			'assignment_mark'    => esc_html__(
				'Assignment mark',
				'masterstudy-lms-learning-management-system-pro'
			),
			'assignment_url'     => esc_html__(
				'Assignment URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'assignment_title'   => esc_html__(
				'Assignment title',
				'masterstudy-lms-learning-management-system-pro'
			),
			'instructor_name'    => esc_html__(
				'Instructor name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_title'       => esc_html__(
				'Course title',
				'masterstudy-lms-learning-management-system-pro'
			),
			'user_login'         => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_new_assignment'                          => array(
		'section' => 'assignment',
		'notice'  => esc_html__(
			'New assignment (for instructor)',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'New Assignment Submitted by {{user_login}}',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => wp_kses_post(
			'We wanted to let you know that {{user_login}} has submitted their assignment, {{assignment_title}}, for the course {{course_title}}. <br>
			Submission Date: {{date}} <br>
			You can review the submitted assignment here: <br>
			 <a href="{{assignment_url}}" target="_blank">Assignment URL</a>',
		),
		'vars'    => array(
			'user_login'       => esc_html__( 'User Login', 'masterstudy-lms-learning-management-system-pro' ),
			'course_title'     => esc_html__( 'Course title', 'masterstudy-lms-learning-management-system-pro' ),
			'assignment_title' => esc_html__( 'Assignment title', 'masterstudy-lms-learning-management-system-pro' ),
			'assignment_url'   => esc_html__( 'Assignment URL', 'masterstudy-lms-learning-management-system-pro' ),
			'blog_name'        => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'         => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'             => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_new_group_invite'                        => array(
		'section' => 'enterprise',
		'notice'  => esc_html__(
			'New Group Invite (email to student)',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'{{user_login}}, You Have Been Invited to a Group!',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => wp_kses_post(
			'Dear {{user_login}},<br>
				You’ve just been added to the enterprise group {{group_name}} by {{admin_login}}.<br>
				As a member of this group, you now have full access to all courses purchased under it.<br>
				If you believe this was a mistake or have any questions, please don’t hesitate to contact us.'
		),
		'vars'    => array(
			'blog_name'    => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'     => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'         => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
			'admin_login'  => esc_html__(
				'Admin login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'group_name'   => esc_html__(
				'Group name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'user_login' => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),

		),
	),
	'stm_lms_new_user_creds'                          => array(
		'section' => 'enterprise',
		'notice'  => esc_html__(
			'New user credentials for enterprise group',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'New user credentials for enterprise group',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => esc_html__(
			'Login: {{username}} Password: {{password}} Site URL: {{site_url}}',
			'masterstudy-lms-learning-management-system-pro'
		),
		'vars'    => array(
			'username'    => esc_html__(
				'Username',
				'masterstudy-lms-learning-management-system-pro'
			),
			'password'    => esc_html__(
				'Password',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name'   => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'    => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'login_url'   => esc_html__(
				'Login URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'        => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
			'admin_login' => esc_html__(
				'Admin login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'group_name'  => esc_html__(
				'Group name',
				'masterstudy-lms-learning-management-system-pro'
			),

		),
	),
	'stm_lms_enterprise_new_group_course'             => array(
		'section' => 'enterprise',
		'notice'  => esc_html__(
			'New Course Available for Enterprise Group',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'{{user_login}}, New Course is Available for Your Group',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => wp_kses_post(
			'Congratulations {{user_login}} <br>
				You just got access to a course {{course_title}} within your group - {{group_name}}.'
		),
		'vars'    => array(
			'admin_login'  => esc_html__(
				'Admin login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'user_login'   => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'group_name'   => esc_html__(
				'Group name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name'    => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'course_title' => esc_html__(
				'Course title',
				'masterstudy-lms-learning-management-system-pro'
			),
			'user_url'     => esc_html__(
				'User url',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'     => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'         => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
	'stm_lms_email_enterprise_remove_user_from_group' => array(
		'section' => 'enterprise',
		'notice'  => esc_html__(
			' Student has been removed from the Group ',
			'masterstudy-lms-learning-management-system-pro'
		),
		'subject' => esc_html__(
			'You’ve Been Removed from the Group',
			'masterstudy-lms-learning-management-system-pro'
		),
		'message' => __(
		// phpcs:ignore WordPress.WP.I18n.NoHtmlWrappedStrings
			'Dear {{user_login}},<br>{{admin_login}} has removed you from the group - “{{group_name}}”.<br> Now you don’t have access to the courses assigned to this group.',
			'masterstudy-lms-learning-management-system-pro'
		),
		'vars'    => array(
			'user_login'  => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'admin_login' => esc_html__(
				'Admin login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'group_name'  => esc_html__(
				'Group name',
				'masterstudy-lms-learning-management-system-pro'
			),

			'site_url'  => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'      => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name' => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	),
);

// Conditionally add notifications for Pro Plus users
if ( STM_LMS_Helpers::is_pro_plus() ) {
	$email_templates['stm_lms_reports_student_checked'] = array(
		'section'   => 'reports',
		'notice'    => esc_html__( 'Progress updates for students', 'masterstudy-lms-learning-management-system-pro' ),
		'frequency' => esc_html__( 'Frequency', 'masterstudy-lms-learning-management-system-pro' ),
		'period'    => esc_html__( 'Day of the week to send', 'masterstudy-lms-learning-management-system-pro' ),
		'time'      => esc_html__( 'Time', 'masterstudy-lms-learning-management-system-pro' ),
		'title'     => esc_html__( 'Your Weekly Report', 'masterstudy-lms-learning-management-system-pro' ),
		'message'   => esc_html__( 'Great job so far! Here is just a quick heads-up on your progress:', 'masterstudy-lms-learning-management-system-pro' ),
		'vars'      => array(
			'blog_name'  => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'   => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'       => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
			'user_login' => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	);

	$email_templates['stm_lms_reports_instructor_checked'] = array(
		'section'   => 'reports',
		'notice'    => esc_html__( 'Reports for instructors', 'masterstudy-lms-learning-management-system-pro' ),
		'frequency' => esc_html__( 'Frequency', 'masterstudy-lms-learning-management-system-pro' ),
		'period'    => esc_html__( 'Day of the week to send', 'masterstudy-lms-learning-management-system-pro' ),
		'time'      => esc_html__( 'Time', 'masterstudy-lms-learning-management-system-pro' ),
		'title'     => esc_html__( 'Your Weekly Report', 'masterstudy-lms-learning-management-system-pro' ),
		'message'   => esc_html__( 'Your dedication to creating valuable learning experiences is evident in the numbers. Here\'s your latest update on your courses:', 'masterstudy-lms-learning-management-system-pro' ),
		'vars'      => array(
			'blog_name'       => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'        => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'analytics_url'   => esc_html__(
				'Analytics URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'            => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
			'instructor_name' => esc_html__(
				'Instructor name',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	);
	$email_templates['stm_lms_reports_admin_checked']      = array(
		'section'   => 'reports',
		'notice'    => esc_html__( 'Reports for admin', 'masterstudy-lms-learning-management-system-pro' ),
		'frequency' => esc_html__( 'Frequency', 'masterstudy-lms-learning-management-system-pro' ),
		'period'    => esc_html__( 'Day of the week to send', 'masterstudy-lms-learning-management-system-pro' ),
		'time'      => esc_html__( 'Time', 'masterstudy-lms-learning-management-system-pro' ),
		'title'     => esc_html__( 'Your Weekly Report', 'masterstudy-lms-learning-management-system-pro' ),
		'message'   => esc_html__( 'Here\'s your comprehensive report summarizing the activity across the entire LMS platform:', 'masterstudy-lms-learning-management-system-pro' ),
		'vars'      => array(
			'blog_name'       => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'        => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'analytics_url'   => esc_html__(
				'Analytics URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'            => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
			'instructor_name' => esc_html__(
				'Instructor name',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	);
}

$email_templates['stm_lms_certificates_preview_checked'] = array(
	'section'      => 'certificates',
	'notice'       => esc_html__( 'Certificate for students', 'masterstudy-lms-learning-management-system-pro' ),
	'subject'      => esc_html__( 'You have received a certificate!', 'masterstudy-lms-learning-management-system-pro' ),
	'message'      => wp_kses_post( '<h2>You have received a certificate!</h2>{{date}}<br>{{certificate_preview}}<br>{{button}}' ),
	'vars'         => array(
		'date'                => esc_html__( 'Date', 'masterstudy-lms-learning-management-system-pro' ),
		'certificate_preview' => esc_html__( 'Certificate preview', 'masterstudy-lms-learning-management-system-pro' ),
		'button'              => esc_html__( 'Button ', 'masterstudy-lms-learning-management-system-pro' ),
		'blog_name'           => esc_html__(
			'Blog name',
			'masterstudy-lms-learning-management-system-pro'
		),
		'site_url'            => esc_html__(
			'Site URL',
			'masterstudy-lms-learning-management-system-pro'
		),
		'course_title'        => esc_html__(
			'Course title',
			'masterstudy-lms-learning-management-system-pro'
		),
		'course_url'          => esc_html__(
			'Course URL',
			'masterstudy-lms-learning-management-system-pro'
		),
		'instructor_name'     => esc_html__(
			'Instructor name',
			'masterstudy-lms-learning-management-system-pro'
		),
	),
	'notice_setup' => esc_html__( 'To receive certificates, make sure the certificate page is set up properly.', 'masterstudy-lms-learning-management-system-pro' ),
);

$register_as_instructor = STM_LMS_Options::get_option( 'register_as_instructor', false );

if ( $register_as_instructor ) {
	$email_templates['stm_lms_email_update_user_status_approved'] = array(
		'section' => 'instructors',
		'notice'  => esc_html__( 'Instructor application approved', 'masterstudy-lms-learning-management-system-pro' ),
		'subject' => esc_html__( 'Instructor application approved', 'masterstudy-lms-learning-management-system-pro' ),
		'message' => wp_kses_post(
			'Hi {{instructor_name}},<br>
			Congratulations! Your application to become an instructor on {{blog_name}} has been approved. <br>
			You can now log in to your instructor account using the following link:<br>
			Login URL: <a href="{{login_url}}" target="_blank">Login URL</a><br>
			We are excited to have you on board and look forward to your contributions!'
		),
		'vars'    => array(
			'instructor_name' => esc_html__(
				'Instructor name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'login_url'       => esc_html__(
				'Login URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name'       => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'        => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'            => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
			'admin_comment'   => esc_html__(
				'Admin comment',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	);
	$email_templates['stm_lms_email_update_user_status_rejected'] = array(
		'section' => 'instructors',
		'notice'  => esc_html__( 'Instructor application rejected', 'masterstudy-lms-learning-management-system-pro' ),
		'subject' => esc_html__( 'Update on Your Instructor Application', 'masterstudy-lms-learning-management-system-pro' ),
		'message' => wp_kses_post(
			'Hi {{user_login}},<br>
			Thank you for your interest in becoming an instructor on {{blog_name}} <br>
			After careful review, we regret to inform you that your application has not been approved at this time.
			We appreciate the time and effort you put into your submission. 
			You\'re welcome to update your application and reapply in the future. 
			If you have any questions or would like feedback, feel free to reach out to our team.<br>
			Best regards.'
		),
		'vars'    => array(
			'user_login'    => esc_html__(
				'User login',
				'masterstudy-lms-learning-management-system-pro'
			),
			'blog_name'     => esc_html__(
				'Blog name',
				'masterstudy-lms-learning-management-system-pro'
			),
			'site_url'      => esc_html__(
				'Site URL',
				'masterstudy-lms-learning-management-system-pro'
			),
			'date'          => esc_html__(
				'Application date',
				'masterstudy-lms-learning-management-system-pro'
			),
			'admin_comment' => esc_html__(
				'Admin comment',
				'masterstudy-lms-learning-management-system-pro'
			),
		),
	);
}

return $email_templates;
