<?php
if (!defined('ABSPATH')) {exit;}

/**
 * Webp generate
 *
 * @link       https://themeforest.net/user/nouthemes/portfolio
 * @since      1.0.2
 *
 * @package    Leopard_Wordpress_Offload_Media
 * @subpackage Leopard_Wordpress_Offload_Media/includes
 */
use WebPConvert\WebPConvert;

class Leopard_Wordpress_Offload_Media_Webp {

	protected $post_id = null;
	protected $provider = null;
    protected $client = null;
    protected $region = null;
    protected $bucket = null;
    protected $bucket_url = null;
    protected $base_folder = null;
    protected $basedir_absolute = null;
    protected $objects = [];
    protected $webp_files = [];

	function __construct($post_id) {

		list( $aws_s3_client, $Bucket, $Region, $array_files, $basedir_absolute ) = leopard_offload_media_aws_array_media_actions_function( $post_id );

		$this->post_id 			= $post_id;
		$this->provider 		= $aws_s3_client;
		$this->bucket 			= $Bucket;
	    $this->region 			= $Region;
        $this->client 			= $this->provider->setClient($this->region);
        $this->bucket_url 		= leopard_offload_media_get_bucket_url();
        $this->basedir_absolute = $basedir_absolute;
        $this->base_folder 		= array_shift( $array_files );

        foreach ( $array_files as $key ) {
			
			if ( $this->base_folder != '' ) {
                $new_key = $this->base_folder . "/" . $key;
            } else {
                $new_key = $key;
			}
			
			if($this->should_convert($new_key)){
				$source = $this->basedir_absolute. '/' . $new_key;
				if(file_exists($source) && is_readable($source)){
					$this->objects[] = $new_key;
				}
			}
		}
	}

	public function get_key_from_url($old_url){
		return Leopard_Wordpress_Offload_Media_Utils::get_key_from_url($old_url);
	}

	private function should_convert($source){
		if(strpos($source, '.png') !== false || strpos($source, '.jpg') !== false || strpos($source, '.jpeg') !== false){
			return true;
		}
		return false;
	}

	private function build_key($key, $with_bucket=true){
		
		if($this->provider::identifier() == 'bunnycdn'){
			$with_bucket = false;
		}

		$key = $this->provider->getBucketMainFolder().$key;
		if(!$with_bucket){
			return $key;
		}
		return $this->bucket.'/'.$key;
	}

    private function update_permission($key){
        $array_aux = explode( '/', $key );
        $main_file = array_pop( $array_aux );
        $array_files[] = implode( "/", $array_aux );
        $array_files[] = $main_file;
        $data = $this->provider->set_object_permission($this->bucket, $this->region, $array_files);
    }

	private function remove_file_extension($key){
		// Use pathinfo to get file information
		$pathInfo = pathinfo($key);
		// Construct the new path without the extension
		$newFilePath = $pathInfo['dirname'] . '/' . $pathInfo['filename'];
		// Output the result
		return $newFilePath;
	}

	private function convert($keys, $options=[]){
		$key = $keys['key'];
		$keyWithoutExt = $this->remove_file_extension($keys['key']);
		$sanitizeKey = $this->remove_file_extension($keys['newKey']);
		$data = get_post_meta($this->post_id, '_nou_leopard_wom_webp_info', true);
		$upload_dir = wp_upload_dir();
		$basedir_absolute = $upload_dir['basedir'];
		$success = false;
        $msg = '';
		$destination = $this->basedir_absolute. '/' . $sanitizeKey . '.webp';
		$source = $this->basedir_absolute. '/' . $key;
		try {
			$content = file_get_contents($source);
			$file = $keyWithoutExt . '.webp';
			$temp = leopard_offload_media_tempnam( $file );
			
			if ( ! $temphandle = @fopen( $temp, 'w+' ) ) {
				@unlink( $temp );
			}else{
				
				Leopard_Wordpress_Offload_Media_Utils::put_contents($temp, $content);

				$buildKey = $this->build_key($sanitizeKey, false);		
				$url = $this->bucket_url . '/' . $buildKey . '.webp';

				try {
					WebPConvert::convert($temp, $destination, $options);
					
					if(file_exists( $destination )){
						error_log("Completed convert webp: {$destination}");
						
						if(!is_array($data)){
							$data = [];
						}

						$data[$key] = $url;

						$this->webp_files[] = [
							'Bucket' => $this->bucket,
							'Region' => $this->region,
							'Key' => $buildKey . '.webp',
							'SourceFile' => $destination,
							'temp' => $temp,
							'data' => $data,
							'url' => $url,
						];

						$success = true;

					}else{
						error_log("Failed convert webp: {$destination}");
					}
				} catch (Exception $e) {
					$msg = $e->getMessage();
					error_log("{$source} Failed convert webp: {$msg}");
				}
			}

		} catch (\Throwable $th) {}

		return [
            'success' 	=> $success,
            'msg' 		=> $msg,
            'file' 		=> $destination
        ];
	}

	public function do_converts(){

		error_log("Start convert webp: {$this->post_id} - {$this->base_folder}");

		update_post_meta($this->post_id, '_nou_leopard_wom_webp_info', []);
		
		try {
			// Convert webp
			foreach ($this->objects as $key) {
				$this->convert([
					'key' => $key,
					'newKey' => $key
				]);
			}

			// then, upload files to s3
			if(count($this->webp_files) >  0){
				$results = $this->provider->upload_objects_async( $this->webp_files );
				if(count($results['successful_uploads']) > 0){
					$data = [];
					foreach ($results['successful_uploads'] as $file) {
						$data[$file['file']] = $file['url'];
					}

					update_post_meta($this->post_id, '_nou_leopard_wom_webp_info', $data);

					foreach($this->webp_files as $file){
						@unlink( $file['SourceFile'] );
						@unlink( $file['temp'] );
					}
				}
			}
		} catch (Exception $e) {
			error_log($e->getMessage());
		}

		error_log("End convert webp: {$this->post_id}");
	}
}
