<?php
if (!defined('ABSPATH')) {exit;}

/**
 * Verify Offloaded Files Background Process
 *
 * @link       https://themeforest.net/user/nouthemes/portfolio
 * @since      1.0.22
 *
 * @package    Leopard_Wordpress_Offload_Media
 * @subpackage Leopard_Wordpress_Offload_Media/includes
 */

class Leopard_Wordpress_Offload_Media_Verify_Offloaded_Files_Process extends Leopard_Wordpress_Offload_Media_Background_Process{

	/**
	 * @var string
	 */
	protected $action = 'verify_offloaded_files';

	/**
	 * @var int
	 */
	private $offloaded = 0;

	/**
	 * Initiate new background process.
	 */
	public function __construct() {
		add_action( 'nou_leopard_offload_media_cronjob_verify_offloaded_files', [ $this, 'task' ] );
	}

	/**
	 * Process items chunk.
	 *
	 * @param string $source_type
	 * @param array  $source_ids
	 *
	 * @return array
	 *
	 * @throws Exception
	 */
	protected function process_items_chunk( $source_type, $source_ids ) {
		$processed = array();

		foreach ( $source_ids as $source_id ) {
			try {
				$this->handle_item( $source_type, $source_id );
			} catch (Exception $e) {}

			// Whether actually offloaded or not, we've processed the item.
			$processed[] = $source_id;
		}

		return $processed;
	}

	/**
	 * Verify Uploaded item to provider.
	 *
	 * @param string $source_type
	 * @param int    $source_id
	 *
	 * @return bool
	 * @throws Exception
	 */
	protected function handle_item( $source_type, $source_id ) {

		$class      = leopard_offload_media_get_source_type_name();
		$leopard_item = null;

		try {
			$leopard_item = $class::get_by_source_id( $source_id );
		} catch (\Throwable $th) {}

		try {
			if ( empty( $leopard_item ) || empty( $leopard_item->id() ) ) {
				$leopard_item = $class::create_from_source_id( $source_id );
				if ( is_wp_error( $leopard_item ) ) {
					return false;
				}else{
					$leopard_item->save();
				}
			}
		} catch (\Throwable $th) {}

		if($leopard_item){

			$paths = Leopard_Wordpress_Offload_Media_Utils::get_attachment_file_paths( $source_id, false );
			if ( empty( $paths ) ) {
				return false;
			}

			$fullsize_paths = Leopard_Wordpress_Offload_Media_Utils::fullsize_paths( $paths );
			if ( empty( $fullsize_paths ) ) {
				return false;
			}

			$fullsize_exists  = false;
			$fullsize_missing = false;
			$urlOffloaded = '';

			list( $aws_s3_client, $Bucket, $Region, $basedir_absolute ) = leopard_offload_media_provider_info();

			foreach ( $fullsize_paths as $path ) {
				$key = $leopard_item->key( wp_basename( $path ) );
	
				if ( $aws_s3_client->does_object_exist( $Bucket, $Region, $key ) ) {
					$fullsize_exists = true;
					$urlOffloaded = $aws_s3_client->getObjectUrl( $Bucket, $Region, $key);
				} else {
					$fullsize_missing = true;
				}
			}

			// A full sized file has not been found, remove metadata.
			if ( ! $fullsize_exists ) {
				$leopard_item->delete();
				delete_post_meta( $leopard_item->source_id(), 'nou_leopard_verify_offloaded_status');
				delete_post_meta( $leopard_item->source_id(), '_nou_leopard_wom_amazonS3_info');
				delete_post_meta( $leopard_item->source_id(), '_wp_nou_leopard_wom_s3_wordpress_path');
				delete_post_meta( $leopard_item->source_id(), '_wp_nou_leopard_wom_s3_path');
				return false;
			}

			try {
				if($urlOffloaded != ''){
					// At least one full sized file has been found, set as verified.
					$leopard_item->set_is_verified( true );
					$leopard_item->save();

					update_post_meta( $leopard_item->source_id(), 'nou_leopard_verify_offloaded_status', 1 );

					$settings = leopard_offload_media_provider_settings();
					$provider = isset($settings['provider']) ? $settings['provider'] : 'aws';
					$data = wp_get_attachment_metadata( $leopard_item->source_id() );
		
					$provider_object = array(
						'provider' => $provider,
						'region'   => $Region,
						'bucket'   => $Bucket,
						'key' 	   => $leopard_item->source_path(),
						'data'     => $data
					);
					update_post_meta( $leopard_item->source_id(), '_nou_leopard_wom_amazonS3_info', $provider_object );
					update_post_meta( $leopard_item->source_id(), '_wp_nou_leopard_wom_s3_wordpress_path', '1' );
					update_post_meta( $leopard_item->source_id(), '_wp_nou_leopard_wom_s3_path', $urlOffloaded );
				}
			} catch (\Throwable $th) {}

			if ( $fullsize_missing ) {
				return false;
			}
		}
	}

	/**
	 * Task
	 * 
	 * @return mixed
	 */
	public function task() {

		if(!nou_leopard_offload_media_is_plugin_setup()){
			return false;
		}

		$action_scan = get_option('nou_leopard_offload_media_action');
		if(!empty($action_scan)){
			return false;
		}

		try {
			$blog_id = get_current_blog_id();
			$source_type_classes = leopard_offload_media_get_source_type_classes();
			foreach($source_type_classes as $source_type => $class){
				$items = $class::verify_missing_source_ids($this->limit);
				if(count($items) == 0){
					$items = $class::get_source_ids(null, $this->limit, false, null, false);
				}

				$chunks = array_chunk( $items, $this->chunk );
				foreach ( $chunks as $chunk ) {
					try {
						$this->process_items_chunk($source_type, $chunk);
					} catch (\Throwable $th) {
						error_log("Error copy_attachments_to_cloud: ". $th->getMessage());
					}
				}
			}
		} catch (\Throwable $th) {
			error_log("Error copy_attachments_to_cloud: ". $th->getMessage());
		}

		return false;
	}
}
?>