<?php
if (!defined('ABSPATH')) {exit;}

/**
 * CLI.
 *
 * @since      2.0.33
 * @package    Leopard_Wordpress_Offload_Media
 * @subpackage Leopard_Wordpress_Offload_Media/includes
 * @author     Nouthemes <nguyenvanqui89@gmail.com>
 */
class Leopard_Wordpress_Offload_Media_CLI {
    
    /**
	 * One click
	 *
	 * @since  2.0.33
	 * @author Nouthemes
	 */
	public function one_click($args, $assoc_args) {
        $text_action_error = esc_html__('Please, choose an action: 1 - copy_files_to_bucket, 2 - remove_files_from_server, 3 - remove_files_from_bucket, 4 - download_files_from_bucket', 'leopard-wordpress-offload-media');
        if(empty($args[0])){
            WP_CLI::warning( $text_action_error );
            return;
        }else{
            $action_scan = $args[0];
		    if($action_scan < 1 || $action_scan > 4){
                WP_CLI::warning( $text_action_error );
                return;
            }

            try{
				// Clear all scheduled
				leopard_offload_media_after_action_scheduler_completed();
			} catch (\Throwable $th) {}

            $percentOffload = 0;
			$count = [];
            $text_action = '';

            switch ($action_scan) {
                case 1:
                    $text_action = leopard_offload_media_get_sync_action_title('copy_files_to_bucket');
                    try {
                        $blog_id = get_current_blog_id();
                        $source_type_classes = leopard_offload_media_get_source_type_classes();
                        foreach($source_type_classes as $source_type => $class){
                            $items = $class::verify_missing_source_ids(0);
                            $progress = \WP_CLI\Utils\make_progress_bar( "{$text_action}: {$source_type}", count($items) );
                            foreach ( $items as $source_id ) {
                                switch($source_type){
                                    case "media-library":
                                        leopard_offload_media_copy_to_s3_function( $source_id );
                                        break;
                                    case "bboss-user-avatar":
                                    case "bboss-user-cover":
                                    case "bboss-group-avatar":
                                    case "bboss-group-cover":
                                        if ( nou_leopard_offload_media_is_bb_activate() ) {
                                            $source_types 	= Leopard_Wordpress_Offload_Media_Buddyboss::get_resource_type();
                                            $class 			= $source_types[$source_type]['class'];
                                            $leopard_item 	= $class::create_from_source_id( $source_id );
                        
                                            $upload_handler = leopard_offload_media_get_item_handler('upload');
                                            $results  = $upload_handler->handle( $leopard_item );
                        
                                            if ( is_wp_error( $results ) ) {
                                                return false;
                                            }
                        
                                            $leopard_item->save();
                                        }
                                        break;
                                    default:
                                        break;
                                }
                                $progress->tick();
                            }
                            $progress->finish();
                        }
                    } catch (\Throwable $th) {}
                    break;
                case 2:
                    # code...
                    $text_action = leopard_offload_media_get_sync_action_title('remove_files_from_server');
                    try {
                        $blog_id = get_current_blog_id();
                        $source_type_classes = leopard_offload_media_get_source_type_classes();
                        foreach($source_type_classes as $source_type => $class){
                            $items = leopard_offload_media_items_local_removed($source_type, 0, false, false);
                            $progress = \WP_CLI\Utils\make_progress_bar( "{$text_action}: {$source_type}", count($items) );
                            foreach ( $items as $source_id ) {
                                leopard_offload_media_remove_from_server_function($source_id);
                                $progress->tick();
                            }
                            $progress->finish();
                        }
                    } catch (\Throwable $th) {}
                    break;
                case 3:
                    # code...
                    $text_action = leopard_offload_media_get_sync_action_title('remove_files_from_bucket');
                    try {
                        $blog_id = get_current_blog_id();
                        $source_type_classes = leopard_offload_media_get_source_type_classes();
                        foreach($source_type_classes as $source_type => $class){
                            $items = $class::get_source_ids(null, 0, false);
                            $progress = \WP_CLI\Utils\make_progress_bar( "{$text_action}: {$source_type}", count($items) );
                            foreach ( $items as $source_id ) {
                                
                                switch($source_type){
                                    case "media-library":
                                        leopard_offload_media_remove_from_s3_function( $source_id );
                                        break;
                                    case "bboss-user-avatar":
                                    case "bboss-user-cover":
                                    case "bboss-group-avatar":
                                    case "bboss-group-cover":
                                        if ( nou_leopard_offload_media_is_bb_activate() ) {
                                            $source_types 	= Leopard_Wordpress_Offload_Media_Buddyboss::get_resource_type();
                                            $class 			= $source_types[$source_type]['class'];
                                            $leopard_item 	= $class::get_by_source_id( $source_id );
                        
                                            try {
                                                if(empty( $leopard_item->id() )){
                                                    $leopard_item = $class::create_from_source_id( $source_id );
                                                }
                                            } catch( Exception $e){}
                        
                                            $remove_provider_handler = leopard_offload_media_get_item_handler( Leopard_Wordpress_Offload_Media_Remove_Provider_Handler::get_item_handler_key_name() );
                                            $remove_provider_handler->handle( $leopard_item );
                                        }
                                        break;
                                    default:
                                        break;
                                }
                                $progress->tick();
                            }
                            $progress->finish();
                        }	
                    } catch (\Throwable $th) {}
                    break;
                case 4:
                    # code...
                    $text_action = leopard_offload_media_get_sync_action_title('download_files_from_bucket');
                    try {
                        $blog_id = get_current_blog_id();
                        $source_type_classes = leopard_offload_media_get_source_type_classes();
                        foreach($source_type_classes as $source_type => $class){
            
                            $args = array( 
                                'fields'        	=> 'ids',
                                'post_type' 		=> 'attachment',
                                'post_status' 		=> 'inherit',
                                'posts_per_page' 	=> -1,
                                'meta_query' 		=> [
                                    'relation' => 'OR',
                                    [
                                        'key'     => '_wp_nou_leopard_wom_copy_to_server',
                                        'value'   => '1',
                                        'compare' => 'NOT EXISTS',
                                    ],
                                    [
                                        'key'     => '_wp_nou_leopard_wom_copy_to_server',
                                        'value'   => '1',
                                        'compare' => '!=',
                                    ],
                                ]
                            );
                            $query = new WP_Query($args);
                            $found_posts = $query->found_posts;
                            if($found_posts > 0){
                                $progress = \WP_CLI\Utils\make_progress_bar( "{$text_action}: {$source_type}", $found_posts );
                                foreach ( leopard_wordpress_offload_media_lazy_loop($query) as $post ) {
                                    $source_id = get_the_ID();
                                    leopard_offload_media_copy_to_server_from_s3_function($source_id);
                                    $progress->tick();
                                }
                                $progress->finish();
                            }
                        }
                    } catch (\Throwable $th) {}
                    break;
                default:
                    # code...
                    break;
            }

        }
	}
}