<?php
function nou_leopard_offload_media_build_cache_key($key) {
    $version = LEOPARD_WORDPRESS_OFFLOAD_MEDIA_VERSION;
    return "leopard:". $version .":" . $key;
}

/**
 * Get a cached item.
 *
 * @param string $key The cache key.
 * @return mixed|false The cached data or false if not found.
 */
function nou_leopard_offload_media_get_cache_item($key) {
    return get_transient($key);
}

/**
 * Set a cached item.
 *
 * @param string $key The cache key.
 * @param mixed $data The data to cache.
 * @param int $expiration Optional. Time until expiration in seconds. Default is one year.
 * @return mixed The cached data.
 */
function nou_leopard_offload_media_set_cache_item($key, $data, $expiration = YEAR_IN_SECONDS) {
    set_transient($key, $data, $expiration);
    return $data;
}

/**
 * Delete a cached item.
 *
 * @param string $key The cache key.
 * @return bool True if successful, false otherwise.
 */
function nou_leopard_offload_media_delete_cache_item($key) {
    return delete_transient($key);
}