(function ($) {
	"use strict";
	// Local reference to the WordPress media namespace.
	var media = wp.media;

	function addQSParm(myUrl, name, value) {
		var re = new RegExp("([?&]" + name + "=)[^&]+", "");
		
		function add(sep) {
			myUrl += sep + name + "=" + encodeURIComponent(value);
		}

		function change() {
			myUrl = myUrl.replace(re, "$1" + encodeURIComponent(value));
		}

		if (String(myUrl).indexOf("?") === -1) {
			add("?");
		} else {
			if (re.test(myUrl)) {
				change();
			} else {
				add("&");
			}
		}

		return myUrl;
	}

	var MediaLibraryCloudFilter = media.view.AttachmentFilters.extend({
		id: 'media-attachment-cloud-filter',
		createFilters: function() {
			var filters = {};
			_.each( leopard_wordpress_offload_media_params.filter_cloud_served || {}, function( value, index ) {
				filters[ index ] = {
					text: value.name,
					props: {
						leopard_served: value.slug
					}
				};
			});
			filters.all = {
				text:  leopard_wordpress_offload_media_params.filter_all,
				props: {
					leopard_served: 'all'
				},
				priority: 10
			};
			this.filters = filters;
		}
	});

	/**
	 * Extend and override media.view.AttachmentsBrowser to include our new filter
	 */
	var AttachmentsBrowser = media.view.AttachmentsBrowser;
	media.view.AttachmentsBrowser = AttachmentsBrowser.extend({
		createToolbar: function() {
			// Make sure to load the original toolbar
			AttachmentsBrowser.prototype.createToolbar.call( this );

			this.toolbar.set( 'MediaLibraryCloudFilter', new MediaLibraryCloudFilter({
				controller: this.controller,
				model:      this.collection.props,
				priority: -75
			}).render() );
			
			this.toolbar.set( 'leopardFromLabel', new wp.media.view.Label({
				value: leopard_wordpress_offload_media_params.filter_date_range.from,
				className: 'media-search-input-label',
				attributes: {
					'for': 'media-search-leopard_served_from'
				},
				priority:   61
			}).render() );
			this.toolbar.set( 'leopard_served_from', new wp.media.view.Search({
				id:        'media-search-leopard_served_from',
				attributes: {
					type: 'date',
					name: 'leopard_served_from'
				},
				events: {
					'input': 'leopard_served_from'
				},
				controller: this.controller,
				model:      this.collection.props,
				priority:   62
			}).render() );
			this.toolbar.set( 'leopardToLabel', new wp.media.view.Label({
				value: leopard_wordpress_offload_media_params.filter_date_range.to,
				className: 'media-search-input-label',
				attributes: {
					'for': 'media-search-leopard_served_to'
				},
				priority:   63
			}).render() );
			this.toolbar.set( 'leopard_served_to', new wp.media.view.Search({
				id:        'media-search-leopard_served_to',
				attributes: {
					type: 'date',
					name: 'leopard_served_to'
				},
				events: {
					'input': 'leopard_served_to'
				},
				controller: this.controller,
				model:      this.collection.props,
				priority:   64
			}).render() );

			$('body').on('change', '#media-search-leopard_served_to, #media-search-leopard_served_from', function(){
				var from = $('body #media-search-leopard_served_from').val();
				var to = $('body #media-search-leopard_served_to').val();
				var postMimeType = $('body #media-attachment-filters').val(); // post_mime_type
				var cloudFilter = $('body #media-attachment-cloud-filter').val();
				var url = window.location.href
				if(from !== '' && to !== ''){
					url = addQSParm(url, 'leopard_served_from', from)
					url = addQSParm(url, 'leopard_served_to', to)
					if(postMimeType !== ''){
						url = addQSParm(url, 'post_mime_type', postMimeType)
					}
					if(cloudFilter !== ''){
						url = addQSParm(url, 'leopard_served', cloudFilter)
					}
					window.location.href = url
				}
			})
		}
	});

})(jQuery);