export function request(path, method = 'GET', data = {}) {
  return new Promise((resolve, reject) => {
    const requestData = {
      method,
      headers: {
        'Content-Type': 'application/json',
        'X-WP-Nonce': window.kallyas_dashboard_vars.rest.nonce,
      },
    };

    if (method === 'POST') {
      requestData.body = JSON.stringify(data);
    }
    fetch(`${window.kallyas_dashboard_vars.rest.root}kallyas/v1/${path}`, requestData)
      .then(parseJSON)
      .then(response => {
        if (response.ok) {
          return resolve(response.json);
        }
        return reject(response.json.message);
      });
  });
}

/**
 * Parses the JSON returned by a network request
 *
 * @param  {object} response A response from a network request
 *
 * @return {object}          The parsed JSON, status from the response
 */
function parseJSON(response) {
  return new Promise(resolve =>
    response.json().then(json =>
      resolve({
        status: response.status,
        ok: response.ok,
        json,
      }),
    ),
  );
}

// GET using fetch and WP headers
export function get(path) {
  return request(path, 'GET');
}

// GET using fetch and WP headers
export function post(path, data = {}) {
  return request(path, 'POST', data);
}
