<?php if(! defined('ABSPATH')){ return; }
/*
 Name: PHP Code
 Description: Create and display a PHP Code element.
 Class: TH_PhpCode
 Category: content
 Level: 3
*/
/**
 * Class TH_PhpCode
 *
 * Create and display a PHP Code element.
 * Executes the provided PHP code in pages this element is included into.
 * Heads up: While this element give you a lot of freedom, please use it responsibly as it can easily break your
 * existent codebase. Also, be aware of the server's limitations: restricted functions or classes.
 *
 * @package  Kallyas
 * @category Page Builder
 * @author   Team Hogash
 * @since    4.0.0
 */
class TH_PhpCode extends ZnElements
{

	public static function getName(){
		return __( "PHP Code", 'zn_framework' );
	}

	/**
	 * This method is used to display the output of the element.
	 * @return void
	 */
	function element()
	{

		if ( ! current_user_can('administrator') && defined('DOING_AJAX') && DOING_AJAX ) {
			echo __('Only administrators can edit the PHP code.', 'zn_framework');
			return;
		}

		// Get the options for the element
		$options = $this->data['options'];
		$uid = $this->data['uid'];

		echo '<div class="elm-phpcode '.$uid.' '.zn_get_element_classes($this->data['options']).'">';

		if(isset($options['page_php_code_text']) && ! empty($options['page_php_code_text']))
		{
			$output    = '';
			$custom_php = $options['page_php_code_text'];
			$custom_php = trim($custom_php);

			// Remove "<?php" from the beginning of the code
			$custom_php = ltrim($custom_php, '<?php');
			$has_error = false;
	
			try {
				$output = eval( $custom_php );
			} catch ( \Throwable $e ) {
				$output    = $e->getMessage();
				$has_error = true;
			}
			
			// Check for errors
			if ( $has_error ) {
				echo __('PHP code generated an error: ', 'zn_framework');
				echo $output;
			}
		}
		echo '</div>';
	}

	/**
	 * This method is used to retrieve the configurable options of the element.
	 * @return array The list of options that compose the element and then passed as the argument for the render() function
	 */
	function options()
	{
		$uid = $this->data['uid'];


		$options = array(
			'has_tabs'  => true,
			'general' => array(
				'title' => 'General options',
				'options' => []
			),


			'help' => znpb_get_helptab( array(
				'video'   => sprintf( '%s', esc_url('https://my.hogash.com/video_category/kallyas-wordpress-theme/#yh8tyiw8tCc') ),
				'docs'    => sprintf( '%s', esc_url('https://my.hogash.com/documentation/php-code/') ),
				'copy'    => $uid,
				'general' => true,
			)),

		);



		// only allow the page_php_code_text option to be edited by an administrator
		if (current_user_can('administrator')) {
			$options['general']['options'][] = array (
				"name"        => __( "PHP Code", 'zn_framework' ),
				"description" => __( 'Please enter the PHP code to be executed. You need to be very careful to
												write this code properly because it will be executed as it is and it
												can potentially break your website.', 'zn_framework' ),	
				"id"          => "page_php_code_text",
				"std"         => "",
				"type"        => "textarea",
				'class' => 'zn_full'
			);
		} else {
			$options['general']['options'][] = array (
				"name"        => __( "PHP Code", 'zn_framework' ),
				"description" => __( 'PHP code is disabled for this user. Only site administrators can edit the PHP code.', 'zn_framework' ),	
				"id"          => "page_php_code_text",
				"std"         => "",
				"type"        => "zn_title",
				'class' => 'zn_full'
			);
		}

		return $options;
	}
}
