<?php
/**
 * The style "detailed" of the Events item
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.2
 */

$args = get_query_var('trx_addons_args_sc_events');

if ($args['slider']) {
	?><div class="slider-slide swiper-slide"><?php
} else if ((int)$args['columns'] > 1) {
	?><div class="<?php echo esc_attr(trx_addons_get_column_class(1, $args['columns'])); ?>"><?php
}

?><div class="sc_events_item"><?php
	// Event's date
	$date = tribe_get_start_date(null, true, 'M. d, Y');
	if (empty($date)) $date = get_the_date('M. d, Y');
	$time = tribe_get_start_time(null, 'g:i A');
	// Event's title
	?><div class="sc_events_item_title_wrap_2">
		<h5 class="sc_events_item_title_2"><?php the_title(); ?></h5>
			<a class="sc_events_item_button_2" href="<?php the_permalink(); ?>"><?php esc_html_e('Learn more', 'hanani'); ?></a>
	</div>		
	<div class="events_detailed_footer">
		<?php
		// Event's date
		?><span class="sc_events_item_date_wrap"><span class="sc_events_item_date"><?php echo esc_html($date); ?></span></span><?php
		// Event's time
		?><span class="sc_events_item_time_wrap"><span class="sc_events_item_time"><?php hanani_show_layout($time ? esc_html($time) : esc_html__('Whole day', 'hanani')); ?></span></span>
	</div>
	<?php
?></div><?php

if ($args['slider'] || (int)$args['columns'] > 1) {
	?></div><?php
}

?>