<?php
/**
 * Setup theme-specific fonts and colors
 *
 * @package WordPress
 * @subpackage HANANI
 * @since HANANI 1.0.22
 */

// If this theme is a free version of premium theme
if (!defined("HANANI_THEME_FREE"))		define("HANANI_THEME_FREE", false);
if (!defined("HANANI_THEME_FREE_WP"))	define("HANANI_THEME_FREE_WP", false);

// If this theme uses multiple skins
if (!defined("HANANI_ALLOW_SKINS"))	define("HANANI_ALLOW_SKINS", false);
if (!defined("HANANI_DEFAULT_SKIN"))	define("HANANI_DEFAULT_SKIN", 'default');

// Theme storage
// Attention! Must be in the global namespace to compatibility with WP CLI
$GLOBALS['HANANI_STORAGE'] = array(

	// Key validator: market[env|loc]-vendor[axiom|ancora|themerex]
	'theme_pro_key'		=> HANANI_THEME_FREE 
								? 'env-ancora'
								: '',

	// Theme-specific URLs (will be escaped in place of the output)
	'theme_demo_url'	=> (is_rtl() ? '//rtl.hanani.ancorathemes.com' : '//hanani.ancorathemes.com'),

	'theme_doc_url'		=> '//hanani.ancorathemes.com/doc',
	'theme_download_url'=> 'https://1.envato.market/c/1262870/275988/4415?subId1=ancora&u=themeforest.net/item/hanani-jewish-community-synagogue-wordpress-theme/22745719',

	'theme_support_url'	=> 'https://themerex.net/support/',
	'theme_video_url'	=> 'https://www.youtube.com/channel/UCdIjRh7-lPVHqTTKpaf8PLA',


	// Comma separated slugs of theme-specific categories (for get relevant news in the dashboard widget)
	// (i.e. 'children,kindergarten')
	'theme_categories'  => 'church,people',

	// Responsive resolutions
	// Parameters to create css media query: min, max
	'responsive'		=> array(
						// By device
						'desktop'	=> array('min' => 1680),
						'notebook'	=> array('min' => 1280, 'max' => 1679),
						'tablet'	=> array('min' =>  768, 'max' => 1279),
						'mobile'	=> array('max' =>  767),
						// By size
						'xxl'		=> array('max' => 1679),
						'xl'		=> array('max' => 1439),
						'lg'		=> array('max' => 1279),
						'md'		=> array('max' => 1023),
						'sm'		=> array('max' =>  767),
						'sm_wp'		=> array('max' =>  600),
						'xs'		=> array('max' =>  479)
						)
);

if ( ! function_exists( 'hanani_theme_required_plugins' ) ) {

	add_action( 'after_setup_theme', 'hanani_theme_required_plugins', -1 );
	function hanani_theme_required_plugins() {
		$hanani_required_plugins     = array(

		// List of plugins for both - FREE and PREMIUM versions
		//-----------------------------------------------------
			// Required plugins
			// DON'T COMMENT OR REMOVE NEXT LINES!
			'trx_addons'					=> esc_html__('ThemeREX Addons', 'hanani'),
			
			// Recommended (supported) plugins for both (lite and full) versions
			// If plugin not need - comment (or remove) it
			'elementor'						=> esc_html__('Elementor', 'hanani'),
			'contact-form-7'				=> esc_html__('Contact Form 7', 'hanani'),
			'give'				         => esc_html__('Give Donation', 'hanani'),
			'mailchimp-for-wp'			=> esc_html__('MailChimp for WP', 'hanani'),

		);
		// List of plugins for the FREE version only
		//-----------------------------------------------------
		if ( !HANANI_THEME_FREE ) {
			$hanani_required_plugins     = array_merge( $hanani_required_plugins, array(
					// Recommended (supported) plugins for the PRO (full) version
					// If plugin not need - comment (or remove) it
					'essential-grid'			=> esc_html__('Essential Grid', 'hanani'),
					'revslider'					=> esc_html__('Revolution Slider', 'hanani'),
					'the-events-calendar'	=> esc_html__('The Events Calendar', 'hanani'),
					'learnpress'		      => esc_html__('Learnpress', 'hanani'),
               'trx_updater'           => esc_html__( 'ThemeREX Updater', 'hanani' ),
					'wp-gdpr-compliance'    => esc_html__( 'Cookie Information', 'hanani' ),
					'gdpr-framework'       	=> esc_html__( 'The GDPR Framework', 'hanani' )
			));
		}
	
		// Add plugins list to the global storage
		hanani_storage_set( 'required_plugins', $hanani_required_plugins );
	}
}

// Theme-specific blog layouts
if ( ! function_exists( 'hanani_setup_blog_styles' ) ) {
	add_action( 'after_setup_theme', 'hanani_setup_blog_styles', 1 );
	function hanani_setup_blog_styles() {

		
		$blog_styles = array_merge( 
			// Layouts for both - FREE and PREMIUM versions
			//-----------------------------------------------------
			array(
				'excerpt'	=> array(
								'title'		=> esc_html__('Standard', 'hanani'),
								'archive'	=> 'index-excerpt',
								'item'		=> 'content-excerpt',
								'styles'	=> 'excerpt'
								),
				'classic'	=> array(
								'title'		=> esc_html__('Classic', 'hanani'),
								'archive'	=> 'index-classic',
								'item'		=> 'content-classic',
								'columns'	=> array(2,3),
								'styles'	=> 'classic'
								)
			),

			// Layouts for the FREE version only
			//-----------------------------------------------------
			HANANI_THEME_FREE 
			? array() 

			// Layouts for the PREMIUM version only
			//-----------------------------------------------------
			: array(
				'masonry'	=> array(
								'title'		=> esc_html__('Masonry', 'hanani'),
								'archive'	=> 'index-classic',
								'item'		=> 'content-classic',
								'columns'	=> array(2,3),
								'styles'	=> 'masonry'
								),
				'portfolio'	=> array(
								'title'		=> esc_html__('Portfolio', 'hanani'),
								'archive'	=> 'index-portfolio',
								'item'		=> 'content-portfolio',
								'columns'	=> array(2,3,4),
								'styles'	=> 'portfolio'
								),
				'gallery'	=> array(
								'title'		=> esc_html__('Gallery', 'hanani'),
								'archive'	=> 'index-portfolio',
								'item'		=> 'content-portfolio-gallery',
								'columns'	=> array(2,3,4),
								'styles'	=> array('portfolio', 'gallery')
								),
				'chess'	=> array(
								'title'		=> esc_html__('Chess', 'hanani'),
								'archive'	=> 'index-chess',
								'item'		=> 'content-chess',
								'columns'	=> array(1,2,3),
								'styles'	=> 'chess'
								)
				)
			);

			hanani_storage_set( 'blog_styles', apply_filters( 'hanani_filter_add_blog_styles', $blog_styles ) );
	}
}

// Theme init priorities:
// Action 'after_setup_theme'
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options. Attention! After this step you can use only basic options (not overriden)
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
// Action 'wp_loaded'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)

if ( !function_exists('hanani_customizer_theme_setup1') ) {
	add_action( 'after_setup_theme', 'hanani_customizer_theme_setup1', 1 );
	function hanani_customizer_theme_setup1() {

		// -----------------------------------------------------------------
		// -- ONLY FOR PROGRAMMERS, NOT FOR CUSTOMER
		// -- Internal theme settings
		// -----------------------------------------------------------------
		hanani_storage_set('settings', array(

			'duplicate_options'		=> 'child',		// none  - use separate options for the main and the child-theme
													// child - duplicate theme options from the main theme to the child-theme only
													// both  - sinchronize changes in the theme options between main and child themes

			'customize_refresh'		=> 'auto',		// Refresh method for preview area in the Appearance - Customize:
													// auto - refresh preview area on change each field with Theme Options
													// manual - refresh only obn press button 'Refresh' at the top of Customize frame

			'max_load_fonts'		=> 5,			// Max fonts number to load from Google fonts or from uploaded fonts

			'comment_after_name'	=> true,		// Place 'comment' field after the 'name' and 'email'

			'icons_selector'		=> 'internal',	// Icons selector in the shortcodes:
													// vc (default) - standard VC (very slow) or Elementor's icons selector (not support images and svg)
													// internal - internal popup with plugin's or theme's icons list (fast and support images and svg)

			'icons_type'			=> 'icons',		// Type of icons (if 'icons_selector' is 'internal'):
													// icons  - use font icons to present icons
													// images - use images from theme's folder trx_addons/css/icons.png
													// svg    - use svg from theme's folder trx_addons/css/icons.svg

			'socials_type'			=> 'icons',		// Type of socials icons (if 'icons_selector' is 'internal'):
													// icons  - use font icons to present social networks
													// images - use images from theme's folder trx_addons/css/icons.png
													// svg    - use svg from theme's folder trx_addons/css/icons.svg

			'instagram_app'			=> 'internal',	// Use internal Instagram App or user must create own application
													// to display photos from his account
													// internal - use our application
													// client   - user must create own application
			
			'check_min_version'		=> true,		// Check if exists a .min version of .css and .js and return path to it
													// instead the path to the original file
													// (if debug_mode is off and modification time of the original file < time of the .min file)

			'autoselect_menu'		=> false,		// Show any menu if no menu selected in the location 'main_menu'
													// (for example, the theme is just activated)

			'disable_jquery_ui'		=> false,		// Prevent loading custom jQuery UI libraries in the third-party plugins
		
			'use_mediaelements'		=> true,		// Load script "Media Elements" to play video and audio
			
			'tgmpa_upload'			=> false,		// Allow upload not pre-packaged plugins via TGMPA
			
			'allow_no_image'		=> false,		// Allow use image placeholder if no image present in the blog, related posts, post navigation, etc.

			'separate_schemes'		=> true, 		// Save color schemes to the separate files __color_xxx.css (true) or append its to the __custom.css (false)

			'allow_fullscreen'		=> false, 		// Allow cases 'fullscreen' and 'fullwide' for the body style in the Theme Options
													// In the Page Options this styles are present always (can be removed if filter 'hanani_filter_allow_fullscreen' return false)

			'attachments_navigation'=> false, 		// Add arrows on the single attachment page to navigate to the prev/next attachment

			'add_hide_on_xxx' => 'replace'        // Add our breakpoints to the Responsive section of each element
													// 'add' - add our breakpoints after Elementor's
													// 'replace' - add our breakpoints instead Elementor's
													// 'none' - don't add our breakpoints (using only Elementor's)
		));


		// -----------------------------------------------------------------
		// -- Theme fonts (Google and/or custom fonts)
		// -----------------------------------------------------------------
		
		// Fonts to load when theme start
		// It can be Google fonts or uploaded fonts, placed in the folder /css/font-face/font-name inside the theme folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		
		hanani_storage_set('load_fonts', array(
			// Google font
			array(
				'name'	 => 'Roboto',
				'family' => 'sans-serif',
				'styles' => '300,300italic,400,400italic,700,700italic'		// Parameter 'style' used only for the Google fonts
				),
			array(
				'name'	 => 'Arizonia',
				'family' => 'cursive',
				'styles' => '400'		// Parameter 'style' used only for the Google fonts
			),
			array(
				'name'	 => 'Noto Serif',
				'family' => 'serif',
				'styles' => '400,400i,700,700i'		// Parameter 'style' used only for the Google fonts
			),
			array(
				'name'	 => 'Philosopher',
				'family' => 'sans-serif',
				'styles' => '400,400i,700,700i'		// Parameter 'style' used only for the Google fonts
			),

			// Font-face packed with theme
			array(
				'name'   => 'Montserrat',
				'family' => 'sans-serif'
				)
		));
		
		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		hanani_storage_set('load_fonts_subset', 'latin,latin-ext');
		
		// Settings of the main tags
		// Attention! Font name in the parameter 'font-family' will be enclosed in the quotes and no spaces after comma!

		hanani_storage_set('theme_fonts', array(
			'p' => array(
				'title'				=> esc_html__('Main text', 'hanani'),
				'description'		=> esc_html__('Font settings of the main text of the site. Attention! For correct display of the site on mobile devices, use only units "rem", "em" or "ex"', 'hanani'),
				'font-family'		=> '"Noto Serif", serif',
				'font-size' 		=> '1rem',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.529em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '',
				'margin-top'		=> '0em',
				'margin-bottom'		=> '1.529em'
				),
			'h1' => array(
				'title'				=> esc_html__('Heading 1', 'hanani'),
				'font-family'		=> '"Philosopher",sans-serif',
				'font-size' 		=> '5.588em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '',
				'margin-top'		=> '1.3685em',
				'margin-bottom'		=> '0.5052em'
				),
			'h2' => array(
				'title'				=> esc_html__('Heading 2', 'hanani'),
				'font-family'		=> '"Philosopher",sans-serif',
				'font-size' 		=> '4.412em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '',
				'margin-top'		=> '1.8133em',
				'margin-bottom'		=> '0.6em'
				),
			'h3' => array(
				'title'				=> esc_html__('Heading 3', 'hanani'),
				'font-family'		=> '"Philosopher",sans-serif',
				'font-size' 		=> '3.824em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '',
				'margin-top'		=> '1.6em',
				'margin-bottom'		=> '0.6462em'
				),
			'h4' => array(
				'title'				=> esc_html__('Heading 4', 'hanani'),
				'font-family'		=> '"Philosopher",sans-serif',
				'font-size' 		=> '2.941em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.1em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '',
				'margin-top'		=> '1.7em',
				'margin-bottom'		=> '0.64em'
				),
			'h5' => array(
				'title'				=> esc_html__('Heading 5', 'hanani'),
				'font-family'		=> '"Philosopher",sans-serif',
				'font-size' 		=> '2.059em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.286em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '',
				'margin-top'		=> '1.943em',
				'margin-bottom'		=> '0.6855em'
				),
			'h6' => array(
				'title'				=> esc_html__('Heading 6', 'hanani'),
				'font-family'		=> '"Philosopher",sans-serif',
				'font-size' 		=> '1.471em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.2em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '',
				'margin-top'		=> '1.8em',
				'margin-bottom'		=> '0.72em'
				),
			'logo' => array(
				'title'				=> esc_html__('Logo text', 'hanani'),
				'description'		=> esc_html__('Font settings of the text case of the logo', 'hanani'),
				'font-family'		=> '"Arizonia",sans-serif',
				'font-size' 		=> '1.8em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.25em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '0'
				),
			'button' => array(
				'title'				=> esc_html__('Buttons', 'hanani'),
				'font-family'		=> '"Philosopher",sans-serif',
				'font-size' 		=> '18px',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '24px',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0'
				),
			'input' => array(
				'title'				=> esc_html__('Input fields', 'hanani'),
				'description'		=> esc_html__('Font settings of the input fields, dropdowns and textareas', 'hanani'),
				'font-family'		=> 'inherit',
				'font-size' 		=> '15px',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',	// Attention! Firefox don't allow line-height less then 1.5em in the select
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px'
				),
			'info' => array(
				'title'				=> esc_html__('Post meta', 'hanani'),
				'description'		=> esc_html__('Font settings of the post meta: date, counters, share, etc.', 'hanani'),
				'font-family'		=> '"Noto Serif",sans-serif',
				'font-size' 		=> '15px',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '0.4em',
				'margin-bottom'		=> ''
				),
			'menu' => array(
				'title'				=> esc_html__('Main menu', 'hanani'),
				'description'		=> esc_html__('Font settings of the main menu items', 'hanani'),
				'font-family'		=> '"Philosopher",sans-serif',
				'font-size' 		=> '1.176rem',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px'
				),
			'submenu' => array(
				'title'				=> esc_html__('Dropdown menu', 'hanani'),
				'description'		=> esc_html__('Font settings of the dropdown menu items', 'hanani'),
				'font-family'		=> '"Philosopher",sans-serif',
				'font-size' 		=> '1.176rem',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px'
				)
		));
		
		
		// -----------------------------------------------------------------
		// -- Theme colors for customizer
		// -- Attention! Inner scheme must be last in the array below
		// -----------------------------------------------------------------
		hanani_storage_set('scheme_color_groups', array(
			'main'	=> array(
							'title'			=> esc_html__('Main', 'hanani'),
							'description'	=> esc_html__('Colors of the main content area', 'hanani')
							),
			'alter'	=> array(
							'title'			=> esc_html__('Alter', 'hanani'),
							'description'	=> esc_html__('Colors of the alternative blocks (sidebars, etc.)', 'hanani')
							),
			'extra'	=> array(
							'title'			=> esc_html__('Extra', 'hanani'),
							'description'	=> esc_html__('Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'hanani')
							),
			'inverse' => array(
							'title'			=> esc_html__('Inverse', 'hanani'),
							'description'	=> esc_html__('Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'hanani')
							),
			'input'	=> array(
							'title'			=> esc_html__('Input', 'hanani'),
							'description'	=> esc_html__('Colors of the form fields (text field, textarea, select, etc.)', 'hanani')
							),
			)
		);
		hanani_storage_set('scheme_color_names', array(
			'bg_color'	=> array(
							'title'			=> esc_html__('Background color', 'hanani'),
							'description'	=> esc_html__('Background color of this block in the normal state', 'hanani')
							),
			'bg_hover'	=> array(
							'title'			=> esc_html__('Background hover', 'hanani'),
							'description'	=> esc_html__('Background color of this block in the hovered state', 'hanani')
							),
			'bd_color'	=> array(
							'title'			=> esc_html__('Border color', 'hanani'),
							'description'	=> esc_html__('Border color of this block in the normal state', 'hanani')
							),
			'bd_hover'	=>  array(
							'title'			=> esc_html__('Border hover', 'hanani'),
							'description'	=> esc_html__('Border color of this block in the hovered state', 'hanani')
							),
			'text'		=> array(
							'title'			=> esc_html__('Text', 'hanani'),
							'description'	=> esc_html__('Color of the plain text inside this block', 'hanani')
							),
			'text_dark'	=> array(
							'title'			=> esc_html__('Text dark', 'hanani'),
							'description'	=> esc_html__('Color of the dark text (bold, header, etc.) inside this block', 'hanani')
							),
			'text_light'=> array(
							'title'			=> esc_html__('Text light', 'hanani'),
							'description'	=> esc_html__('Color of the light text (post meta, etc.) inside this block', 'hanani')
							),
			'text_link'	=> array(
							'title'			=> esc_html__('Link', 'hanani'),
							'description'	=> esc_html__('Color of the links inside this block', 'hanani')
							),
			'text_hover'=> array(
							'title'			=> esc_html__('Link hover', 'hanani'),
							'description'	=> esc_html__('Color of the hovered state of links inside this block', 'hanani')
							),
			'text_link2'=> array(
							'title'			=> esc_html__('Link 2', 'hanani'),
							'description'	=> esc_html__('Color of the accented texts (areas) inside this block', 'hanani')
							),
			'text_hover2'=> array(
							'title'			=> esc_html__('Link 2 hover', 'hanani'),
							'description'	=> esc_html__('Color of the hovered state of accented texts (areas) inside this block', 'hanani')
							),
			'text_link3'=> array(
							'title'			=> esc_html__('Link 3', 'hanani'),
							'description'	=> esc_html__('Color of the other accented texts (buttons) inside this block', 'hanani')
							),
			'text_hover3'=> array(
							'title'			=> esc_html__('Link 3 hover', 'hanani'),
							'description'	=> esc_html__('Color of the hovered state of other accented texts (buttons) inside this block', 'hanani')
							)
			)
		);
		hanani_storage_set('schemes', array(
		
			// Color scheme: 'default'
			'default' => array(
				'title'	 => esc_html__('Default', 'hanani'),
				'internal' => true,
				'colors' => array(
					
					// Whole block border and background
					'bg_color'			=> '#ffffff',
					'bd_color'			=> '#e8e8e9',
		
					// Text and links colors
					'text'				=> '#5c5c5c',
					'text_light'		=> '#5c5c5c',
					'text_dark'			=> '#002d70',
					'text_link'			=> '#d5a339',
					'text_hover'		=> '#3bb8ff',
					'text_link2'		=> '#80d572',
					'text_hover2'		=> '#8be77c',
					'text_link3'		=> '#ddb837',
					'text_hover3'		=> '#eec432',
		
					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'	=> '#eff0f2',
					'alter_bg_hover'	=> '#e4e5e6',
					'alter_bd_color'	=> '#d4d6d9',
					'alter_bd_hover'	=> '#dadada',
					'alter_text'		=> '#5c5c5c',
					'alter_light'		=> '#5c5c5c',
					'alter_dark'		=> '#002d70',
					'alter_link'		=> '#d5a339',
					'alter_hover'		=> '#3bb8ff',
					'alter_link2'		=> '#8be77c',
					'alter_hover2'		=> '#80d572',
					'alter_link3'		=> '#eec432',
					'alter_hover3'		=> '#ddb837',
		
					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'	=> '#002d70',
					'extra_bg_hover'	=> '#28272e',
					'extra_bd_color'	=> '#18417e',
					'extra_bd_hover'	=> '#3d3d3d',
					'extra_text'		=> '#ffffff',
					'extra_light'		=> '#7c8ba1',
					'extra_dark'		=> '#ffffff',
					'extra_link'		=> '#3bb8ff',
					'extra_hover'		=> '#fe7259',
					'extra_link2'		=> '#002d70',
					'extra_hover2'		=> '#8be77c',
					'extra_link3'		=> '#ddb837',
					'extra_hover3'		=> '#eec432',
		
					// Input fields (form's fields and textarea)
					'input_bg_color'	=> '#ffffff',
					'input_bg_hover'	=> '#ffffff',
					'input_bd_color'	=> '#d4d6d9',
					'input_bd_hover'	=> '#d5a339',
					'input_text'		=> '#5c5c5c',
					'input_light'		=> '#5c5c5c',
					'input_dark'		=> '#d5a339',
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color'	=> '#67bcc1',
					'inverse_bd_hover'	=> '#5aa4a9',
					'inverse_text'		=> '#ffffff',
					'inverse_light'		=> '#333333',
					'inverse_dark'		=> '#002d70',
					'inverse_link'		=> '#ffffff',
					'inverse_hover'		=> '#ffffff'
				)
			),
		
			// Color scheme: 'dark'
			'dark' => array(
				'title'  => esc_html__('Dark', 'hanani'),
				'internal' => true,
				'colors' => array(
					
					// Whole block border and background
					'bg_color'			=> '#002d70',
					'bd_color'			=> '#18417e',
		
					// Text and links colors
					'text'				=> '#7c8ba1',
					'text_light'		=> '#7c8ba1',
					'text_dark'			=> '#ffffff',
					'text_link'			=> '#d5a339',
					'text_hover'		=> '#3bb8ff',
					'text_link2'		=> '#80d572',
					'text_hover2'		=> '#8be77c',
					'text_link3'		=> '#ddb837',
					'text_hover3'		=> '#eec432',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'	=> '#002864',
					'alter_bg_hover'	=> '#00327b',
					'alter_bd_color'	=> '#18417e',
					'alter_bd_hover'	=> '#4a4a4a',
					'alter_text'		=> '#7c8ba1',
					'alter_light'		=> '#7c8ba1',
					'alter_dark'		=> '#ffffff',
					'alter_link'		=> '#d5a339',
					'alter_hover'		=> '#3bb8ff',
					'alter_link2'		=> '#8be77c',
					'alter_hover2'		=> '#80d572',
					'alter_link3'		=> '#eec432',
					'alter_hover3'		=> '#ddb837',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'	=> '#ffffff',
					'extra_bg_hover'	=> '#28272e',
					'extra_bd_color'	=> '#e8e8e9',
					'extra_bd_hover'	=> '#4a4a4a',
					'extra_text'		=> '#5c5c5c',
					'extra_light'		=> '#7c8ba1',
					'extra_dark'		=> '#5c5c5c',
					'extra_link'		=> '#3bb8ff',
					'extra_hover'		=> '#fe7259',
					'extra_link2'		=> '#002d70',
					'extra_hover2'		=> '#8be77c',
					'extra_link3'		=> '#ddb837',
					'extra_hover3'		=> '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'	=> '#002864',
					'input_bg_hover'	=> '#002864',
					'input_bd_color'	=> '#ffffff',
					'input_bd_hover'	=> '#d5a339',
					'input_text'		=> '#7c8ba1',
					'input_light'		=> '#ffffff',
					'input_dark'		=> '#ffffff',
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color'	=> '#e36650',
					'inverse_bd_hover'	=> '#cb5b47',
					'inverse_text'		=> '#1d1d1d',
					'inverse_light'		=> '#5f5f5f',
					'inverse_dark'		=> '#1d1d1d',
					'inverse_link'		=> '#ffffff',
					'inverse_hover'		=> '#1d1d1d'
				)
			)
		
		));
		
		// Simple schemes substitution
		hanani_storage_set('schemes_simple', array(
			// Main color	// Slave elements and it's darkness koef.
			'text_link'		=> array('alter_hover' => 1,	'extra_link' => 1, 'inverse_bd_color' => 0.85, 'inverse_bd_hover' => 0.7),
			'text_hover'	=> array('alter_link' => 1,		'extra_hover' => 1),
			'text_link2'	=> array('alter_hover2' => 1,	'extra_link2' => 1),
			'text_hover2'	=> array('alter_link2' => 1,	'extra_hover2' => 1),
			'text_link3'	=> array('alter_hover3' => 1,	'extra_link3' => 1),
			'text_hover3'	=> array('alter_link3' => 1,	'extra_hover3' => 1)
		));

		// Additional colors for each scheme
		hanani_storage_set('scheme_colors_add', array(
			'bg_color_0'		=> array('color' => 'bg_color',			'alpha' => 0),
			'bg_color_02'		=> array('color' => 'bg_color',			'alpha' => 0.2),
			'bg_color_07'		=> array('color' => 'bg_color',			'alpha' => 0.7),
			'bg_color_08'		=> array('color' => 'bg_color',			'alpha' => 0.8),
			'bg_color_09'		=> array('color' => 'bg_color',			'alpha' => 0.9),
			'alter_bg_color_07'	=> array('color' => 'alter_bg_color',	'alpha' => 0.7),
			'alter_bg_color_04'	=> array('color' => 'alter_bg_color',	'alpha' => 0.4),
			'alter_bg_color_02'	=> array('color' => 'alter_bg_color',	'alpha' => 0.2),
			'alter_bd_color_02'	=> array('color' => 'alter_bd_color',	'alpha' => 0.2),
			'alter_link_02'		=> array('color' => 'alter_link',		'alpha' => 0.2),
			'alter_link_07'		=> array('color' => 'alter_link',		'alpha' => 0.7),
			'extra_bg_color_07'	=> array('color' => 'extra_bg_color',	'alpha' => 0.7),
			'extra_link_02'		=> array('color' => 'extra_link',		'alpha' => 0.2),
			'extra_link_07'		=> array('color' => 'extra_link',		'alpha' => 0.7),
			'extra_bg_color_005'	=> array('color' => 'extra_bg_color',	'alpha' => 0.05),
			'text_dark_01'		=> array('color' => 'text_dark',		'alpha' => 0.1),
			'text_dark_07'		=> array('color' => 'text_dark',		'alpha' => 0.7),
			'text_link_02'		=> array('color' => 'text_link',		'alpha' => 0.2),
			'text_link_07'		=> array('color' => 'text_link',		'alpha' => 0.7),
			'text_link_blend'	=> array('color' => 'text_link',		'hue' => 2, 'saturation' => -5, 'brightness' => 5),
			'alter_link_blend'	=> array('color' => 'alter_link',		'hue' => 2, 'saturation' => -5, 'brightness' => 5)
		));
		
		// Parameters to set order of schemes in the css
		hanani_storage_set('schemes_sorted', array(
													'color_scheme', 'header_scheme', 'menu_scheme', 'sidebar_scheme', 'footer_scheme'
													));
		
		
		// -----------------------------------------------------------------
		// -- Theme specific thumb sizes
		// -----------------------------------------------------------------
		hanani_storage_set('theme_thumbs', apply_filters('hanani_filter_add_thumb_sizes', array(
			// Width of the image is equal to the content area width (without sidebar)
			// Height is fixed
			'hanani-thumb-huge'		=> array(
												'size'	=> array(1170, 658, true),
												'title' => esc_html__( 'Huge image', 'hanani' ),
												'subst'	=> 'trx_addons-thumb-huge'
												),
			// Width of the image is equal to the content area width (with sidebar)
			// Height is fixed
			'hanani-thumb-big' 		=> array(
												'size'	=> array( 840, 474, true),
												'title' => esc_html__( 'Large image', 'hanani' ),
												'subst'	=> 'trx_addons-thumb-big'
												),

			// Width of the image is equal to the 1/3 of the content area width (without sidebar)
			// Height is fixed
			'hanani-thumb-med' 		=> array(
												'size'	=> array( 370, 208, true),
												'title' => esc_html__( 'Medium image', 'hanani' ),
												'subst'	=> 'trx_addons-thumb-medium'
												),


			// Sidebar post thumb
			'hanani-thumb-extra' 		=> array(
												'size'	=> array(  840,  590, true),
												'title' => esc_html__( 'Sidebar post thumb', 'hanani' ),
												'subst'	=> 'trx_addons-thumb-extra'
												),

			// Small square image (for avatars in comments, etc.)
			'hanani-thumb-tiny' 		=> array(
												'size'	=> array(  90,  90, true),
												'title' => esc_html__( 'Small square avatar', 'hanani' ),
												'subst'	=> 'trx_addons-thumb-tiny'
												),

			// Width of the image is equal to the content area width (with sidebar)
			// Height is proportional (only downscale, not crop)
			'hanani-thumb-masonry-big' => array(
												'size'	=> array( 760,   0, false),		// Only downscale, not crop
												'title' => esc_html__( 'Masonry Large (scaled)', 'hanani' ),
												'subst'	=> 'trx_addons-thumb-masonry-big'
												),

			// Width of the image is equal to the 1/3 of the full content area width (without sidebar)
			// Height is proportional (only downscale, not crop)
			'hanani-thumb-masonry'		=> array(
												'size'	=> array( 370,   0, false),		// Only downscale, not crop
												'title' => esc_html__( 'Masonry (scaled)', 'hanani' ),
												'subst'	=> 'trx_addons-thumb-masonry'
												)
			))
		);
	}
}




//------------------------------------------------------------------------
// One-click import support
//------------------------------------------------------------------------

// Set theme specific importer options
if ( !function_exists( 'hanani_importer_set_options' ) ) {
	add_filter( 'trx_addons_filter_importer_options', 'hanani_importer_set_options', 9 );
	function hanani_importer_set_options($options=array()) {
		if (is_array($options)) {
			// Save or not installer's messages to the log-file
			$options['debug'] = false;
			// Allow import/export functionality
            $rtl_prefix = is_rtl() ? 'rtl.' : '';
            $rtl_demo_sufix = is_rtl() ? '_rtl' : '';
			$options['allow_import'] = true;
			$options['allow_export'] = true;
			// Prepare demo data
			$options['demo_url'] = esc_url(hanani_get_protocol() . '://demofiles.ancorathemes.com/hanani' . $rtl_demo_sufix . '/');
			// Required plugins
			$options['required_plugins'] = array_keys(hanani_storage_get('required_plugins'));
			// Set number of thumbnails to regenerate when its imported (if demo data was zipped without cropped images)
			// Set 0 to prevent regenerate thumbnails (if demo data archive is already contain cropped images)
			$options['regenerate_thumbnails'] = 3;
			// Default demo
			$options['files']['default']['title'] = esc_html__('Hanani Demo', 'hanani');
			$options['files']['default']['domain_dev'] = '';		// Developers domain
			$options['files']['default']['domain_demo']= esc_url(hanani_get_protocol().'://' . $rtl_prefix . 'hanani.ancorathemes.com');		// Demo-site domain
			// If theme need more demo - just copy 'default' and change required parameter
			// Banners
			$options['banners'] = array(
				array(
					'image' => hanani_get_file_url('theme-specific/theme-about/images/frontpage.png'),
					'title' => esc_html__('Front Page Builder', 'hanani'),
					'content' => wp_kses(__("Create your front page right in the WordPress Customizer. There's no need for any page builder. Simply enable/disable sections, fill them out with content, and customize to your liking.", 'hanani'), 'hanani_kses_content'),
					'link_url' => esc_url('//www.youtube.com/watch?v=VT0AUbMl_KA'),
					'link_caption' => esc_html__('Watch Video Introduction', 'hanani'),
					'duration' => 20
					),
				array(
					'image' => hanani_get_file_url('theme-specific/theme-about/images/layouts.png'),
					'title' => esc_html__('Layouts Builder', 'hanani'),
					'content' => wp_kses(__('Use Layouts Builder to create and customize header and footer styles for your website. With a flexible page builder interface and custom shortcodes, you can create as many header and footer layouts as you want with ease.', 'hanani'), 'hanani_kses_content'),
					'link_url' => esc_url('//www.youtube.com/watch?v=pYhdFVLd7y4'),
					'link_caption' => esc_html__('Learn More', 'hanani'),
					'duration' => 20
					),
				array(
					'image' => hanani_get_file_url('theme-specific/theme-about/images/documentation.png'),
					'title' => esc_html__('Read Full Documentation', 'hanani'),
					'content' => wp_kses(__('Need more details? Please check our full online documentation for detailed information on how to use Hanani.', 'hanani'), 'hanani_kses_content'),
					'link_url' => esc_url(hanani_storage_get('theme_doc_url')),
					'link_caption' => esc_html__('Online Documentation', 'hanani'),
					'duration' => 15
					),
				array(
					'image' => hanani_get_file_url('theme-specific/theme-about/images/video-tutorials.png'),
					'title' => esc_html__('Video Tutorials', 'hanani'),
					'content' => wp_kses(__('No time for reading documentation? Check out our video tutorials and learn how to customize Hanani in detail.', 'hanani'), 'hanani_kses_content'),
					'link_url' => esc_url(hanani_storage_get('theme_video_url')),
					'link_caption' => esc_html__('Video Tutorials', 'hanani'),
					'duration' => 15
					),
				array(
					'image' => hanani_get_file_url('theme-specific/theme-about/images/studio.png'),
					'title' => esc_html__('Website Customization', 'hanani'),
					'content' => wp_kses(__("Need a website fast? Order our custom service, and we'll build a website based on this theme for a very fair price. We can also implement additional functionality such as website translation, setting up WPML, and much more.", 'hanani'), 'hanani_kses_content'),
					'link_url' => esc_url('//themerex.net/offers/?utm_source=offers&utm_medium=click&utm_campaign=themedash'),
					'link_caption' => esc_html__('Contact Us', 'hanani'),
					'duration' => 25
					)
				);
		}
		return $options;
	}
}


//------------------------------------------------------------------------
// OCDI support
//------------------------------------------------------------------------

// Set theme specific OCDI options
if ( !function_exists( 'hanani_ocdi_set_options' ) ) {
	add_filter( 'trx_addons_filter_ocdi_options', 'hanani_ocdi_set_options', 9 );
	function hanani_ocdi_set_options($options=array()) {
		if (is_array($options)) {
			// Prepare demo data
            $rtl_prefix = is_rtl() ? 'rtl.' : '';

            $rtl_demo_sufix = is_rtl() ? '_rtl' : '';

			$options['demo_url'] = esc_url(hanani_get_protocol().'://demofiles.ancorathemes.comt/hanani' . $rtl_demo_sufix . '/' );
			// Required plugins
			$options['required_plugins'] = array_keys(hanani_storage_get('required_plugins'));
			// Demo-site domain			
			$options['files']['ocdi']['title'] = esc_html__('Hanani OCDI Demo', 'hanani');
			$options['files']['ocdi']['domain_demo'] = esc_url(hanani_get_protocol().'://' . $rtl_prefix . 'hanani.ancorathemes.com');
			// If theme need more demo - just copy 'default' and change required parameter
		}
		return $options;
	}
}


// -----------------------------------------------------------------
// -- Theme options for customizer
// -----------------------------------------------------------------
if (!function_exists('hanani_create_theme_options')) {

	function hanani_create_theme_options() {

		// Message about options override. 
		// Attention! Not need esc_html() here, because this message put in wp_kses_data() below
		$msg_override = esc_html__('Attention! Some of these options can be overridden in the following sections (Blog, Plugins settings, etc.) or in the settings of individual pages', 'hanani');
		
		// Color schemes number: if < 2 - hide fields with selectors
		$hide_schemes = count(hanani_storage_get('schemes')) < 2;
		
		hanani_storage_set('options', array(
		
			// 'Logo & Site Identity'
			'title_tagline' => array(
				"title" => esc_html__('Logo & Site Identity', 'hanani'),
				"desc" => '',
				"priority" => 10,
				"type" => "section"
				),
			'logo_info' => array(
				"title" => esc_html__('Logo in the header', 'hanani'),
				"desc" => '',
				"priority" => 20,
				"type" => "info",
				),
			'logo_text' => array(
				"title" => esc_html__('Use Site Name as Logo', 'hanani'),
				"desc" => wp_kses_data( __('Use the site title and tagline as a text logo if no image is selected', 'hanani') ),
				"class" => "hanani_column-1_2 hanani_new_row",
				"priority" => 30,
				"std" => 1,
				"type" => HANANI_THEME_FREE ? "hidden" : "checkbox"
				),
			'logo_retina_enabled' => array(
				"title" => esc_html__('Allow retina display logo', 'hanani'),
				"desc" => wp_kses_data( __('Show fields to select logo images for Retina display', 'hanani') ),
				"class" => "hanani_column-1_2",
				"priority" => 40,
				"refresh" => false,
				"std" => 0,
				"type" => HANANI_THEME_FREE ? "hidden" : "checkbox"
				),
			'logo_zoom' => array(
				"title" => esc_html__('Logo zoom', 'hanani'),
				"desc" => wp_kses_data( __("Zoom the logo. 1 - original size. Maximum size of logo depends on the actual size of the picture", 'hanani') ),
				"std" => 1,
				"min" => 0.2,
				"max" => 2,
				"step" => 0.1,
				"refresh" => false,
				"type" => HANANI_THEME_FREE ? "hidden" : "slider"
				),
			// Parameter 'logo' was replaced with standard WordPress 'custom_logo'
			'logo_retina' => array(
				"title" => esc_html__('Logo for Retina', 'hanani'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'hanani') ),
				"class" => "hanani_column-1_2",
				"priority" => 70,
				"dependency" => array(
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => HANANI_THEME_FREE ? "hidden" : "image"
				),
			'logo_mobile_header' => array(
				"title" => esc_html__('Logo for the mobile header', 'hanani'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the mobile header (if enabled in the section "Header - Header mobile"', 'hanani') ),
				"class" => "hanani_column-1_2 hanani_new_row",
				"std" => '',
				"type" => "image"
				),
			'logo_mobile_header_retina' => array(
				"title" => esc_html__('Logo for the mobile header for Retina', 'hanani'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'hanani') ),
				"class" => "hanani_column-1_2",
				"dependency" => array(
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => HANANI_THEME_FREE ? "hidden" : "image"
				),
			'logo_mobile' => array(
				"title" => esc_html__('Logo mobile', 'hanani'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the mobile menu', 'hanani') ),
				"class" => "hanani_column-1_2 hanani_new_row",
				"std" => '',
				"type" => "image"
				),
			'logo_mobile_retina' => array(
				"title" => esc_html__('Logo mobile for Retina', 'hanani'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'hanani') ),
				"class" => "hanani_column-1_2",
				"dependency" => array(
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => HANANI_THEME_FREE ? "hidden" : "image"
				),
			'logo_side' => array(
				"title" => esc_html__('Logo side', 'hanani'),
				"desc" => wp_kses_data( __('Select or upload site logo (with vertical orientation) to display it in the side menu', 'hanani') ),
				"class" => "hanani_column-1_2 hanani_new_row",
				"std" => '',
				"type" => "hidden"
				),
			'logo_side_retina' => array(
				"title" => esc_html__('Logo side for Retina', 'hanani'),
				"desc" => wp_kses_data( __('Select or upload site logo (with vertical orientation) to display it in the side menu on Retina displays (if empty - use default logo from the field above)', 'hanani') ),
				"class" => "hanani_column-1_2",
				"dependency" => array(
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => "hidden"
				),
			
		
		
			// 'General settings'
			'general' => array(
				"title" => esc_html__('General Settings', 'hanani'),
				"desc" => wp_kses_data( $msg_override ),
				"priority" => 20,
				"type" => "section",
				),

			'general_layout_info' => array(
				"title" => esc_html__('Layout', 'hanani'),
				"desc" => '',
				"type" => "info",
				),
			'body_style' => array(
				"title" => esc_html__('Body style', 'hanani'),
				"desc" => wp_kses_data( __('Select width of the body content', 'hanani') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'hanani')
				),
				"refresh" => false,
				"std" => 'wide',
				"options" => hanani_get_list_body_styles(false),
				"type" => "select"
				),
			'page_width' => array(
				"title" => esc_html__('Page width', 'hanani'),
				"desc" => wp_kses_data( __("Total width of the site content and sidebar (in pixels). If empty - use default width", 'hanani') ),
				"dependency" => array(
					'body_style' => array('boxed', 'wide')
				),
				"std" => 1320,
				"min" => 1000,
				"max" => 1400,
				"step" => 10,
				"refresh" => false,
				"customizer" => 'page',			// SASS variable's name to preview changes 'on fly'
				"type" => HANANI_THEME_FREE ? "hidden" : "slider"
				),
			'boxed_bg_image' => array(
				"title" => esc_html__('Boxed bg image', 'hanani'),
				"desc" => wp_kses_data( __('Select or upload image, used as background in the boxed body', 'hanani') ),
				"dependency" => array(
					'body_style' => array('boxed')
				),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'hanani')
				),
				"std" => '',
				"hidden" => true,
				"type" => "image"
				),
			'remove_margins' => array(
				"title" => esc_html__('Remove margins', 'hanani'),
				"desc" => wp_kses_data( __('Remove margins above and below the content area', 'hanani') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'hanani')
				),
				"refresh" => false,
				"std" => 0,
				"type" => "checkbox"
				),

			'general_sidebar_info' => array(
				"title" => esc_html__('Sidebar', 'hanani'),
				"desc" => '',
				"type" => "info",
				),
			'sidebar_position' => array(
				"title" => esc_html__('Sidebar position', 'hanani'),
				"desc" => wp_kses_data( __('Select position to show sidebar', 'hanani') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'hanani')
				),
				"std" => 'right',
				"options" => array(),
				"type" => "switch"
				),
			'sidebar_widgets' => array(
				"title" => esc_html__('Sidebar widgets', 'hanani'),
				"desc" => wp_kses_data( __('Select default widgets to show in the sidebar', 'hanani') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'hanani')
				),
				"dependency" => array(
					'sidebar_position' => array('left', 'right')
				),
				"std" => 'sidebar_widgets',
				"options" => array(),
				"type" => "select"
				),
			'sidebar_width' => array(
				"title" => esc_html__('Sidebar width', 'hanani'),
				"desc" => wp_kses_data( __("Width of the sidebar (in pixels). If empty - use default width", 'hanani') ),
				"std" => 370,
				"min" => 150,
				"max" => 500,
				"step" => 10,
				"refresh" => false,
				"customizer" => 'sidebar',		// SASS variable's name to preview changes 'on fly'
				"type" => HANANI_THEME_FREE ? "hidden" : "slider"
				),
			'sidebar_gap' => array(
				"title" => esc_html__('Sidebar gap', 'hanani'),
				"desc" => wp_kses_data( __("Gap between content and sidebar (in pixels). If empty - use default gap", 'hanani') ),
				"std" => 40,
				"min" => 0,
				"max" => 100,
				"step" => 1,
				"refresh" => false,
				"customizer" => 'gap',			// SASS variable's name to preview changes 'on fly'
				"type" => HANANI_THEME_FREE ? "hidden" : "slider"
				),
			'expand_content' => array(
				"title" => esc_html__('Expand content', 'hanani'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'hanani') ),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),


			'general_widgets_info' => array(
				"title" => esc_html__('Additional widgets', 'hanani'),
				"desc" => '',
				"type" => HANANI_THEME_FREE ? "hidden" : "info",
				),
			'widgets_above_page' => array(
				"title" => esc_html__('Widgets at the top of the page', 'hanani'),
				"desc" => wp_kses_data( __('Select widgets to show at the top of the page (above content and sidebar)', 'hanani') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'hanani')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => HANANI_THEME_FREE ? "hidden" : "select"
				),
			'widgets_above_content' => array(
				"title" => esc_html__('Widgets above the content', 'hanani'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'hanani') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'hanani')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => HANANI_THEME_FREE ? "hidden" : "select"
				),
			'widgets_below_content' => array(
				"title" => esc_html__('Widgets below the content', 'hanani'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'hanani') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'hanani')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => HANANI_THEME_FREE ? "hidden" : "select"
				),
			'widgets_below_page' => array(
				"title" => esc_html__('Widgets at the bottom of the page', 'hanani'),
				"desc" => wp_kses_data( __('Select widgets to show at the bottom of the page (below content and sidebar)', 'hanani') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'hanani')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => HANANI_THEME_FREE ? "hidden" : "select"
				),

			'general_effects_info' => array(
				"title" => esc_html__('Design & Effects', 'hanani'),
				"desc" => '',
				"type" => "info",
				),
			'border_radius' => array(
				"title" => esc_html__('Border radius', 'hanani'),
				"desc" => wp_kses_data( __("Specify the border radius of the form fields and buttons in pixels", 'hanani') ),
				"std" => 0,
				"min" => 0,
				"max" => 20,
				"step" => 1,
				"refresh" => false,
				"customizer" => 'rad',		// SASS name to preview changes 'on fly'
				"type" => "hidden"
				),

			'general_misc_info' => array(
				"title" => esc_html__('Miscellaneous', 'hanani'),
				"desc" => '',
				"type" => HANANI_THEME_FREE ? "hidden" : "info",
				),
			'seo_snippets' => array(
				"title" => esc_html__('SEO snippets', 'hanani'),
				"desc" => wp_kses_data( __('Add structured data markup to the single posts and pages', 'hanani') ),
				"std" => 0,
				"type" => HANANI_THEME_FREE ? "hidden" : "checkbox"
				),

			'privacy_text' => array(
				"title" => esc_html__("Text with Privacy Policy link", 'hanani'),
				"desc"  => wp_kses_data( __("Specify text with Privacy Policy link for the checkbox 'I agree ...'", 'hanani') ),
				"std"   => wp_kses( __( 'I agree that my submitted data is being collected and stored.', 'hanani'), 'hanani_kses_content' ),
				"type"  => "text"
				),
		
			// 'Header'
			'header' => array(
				"title" => esc_html__('Header', 'hanani'),
				"desc" => wp_kses_data( $msg_override ),
				"priority" => 30,
				"type" => "section"
				),

			'header_style_info' => array(
				"title" => esc_html__('Header style', 'hanani'),
				"desc" => '',
				"type" => "info"
				),
			'header_type' => array(
				"title" => esc_html__('Header style', 'hanani'),
				"desc" => wp_kses_data( __('Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'hanani') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'hanani')
				),
				"std" => 'default',
				"options" => hanani_get_list_header_footer_types(),
				"type" => HANANI_THEME_FREE || !hanani_exists_trx_addons() ? "hidden" : "switch"
				),
			'header_style' => array(
				"title" => esc_html__('Select custom layout', 'hanani'),
				"desc" => wp_kses( __("Select custom header from Layouts Builder", 'hanani'), 'hanani_kses_content' ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'hanani')
				),
				"dependency" => array(
					'header_type' => array('custom')
				),
				"std" => HANANI_THEME_FREE ? 'header-custom-elementor-header-default' : 'header-custom-header-default',
				"options" => array(),
				"type" => "select"
				),
			'header_position' => array(
				"title" => esc_html__('Header position', 'hanani'),
				"desc" => wp_kses_data( __('Select position to display the site header', 'hanani') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'hanani')
				),
				"std" => 'default',
				"options" => array(),
				"type" => HANANI_THEME_FREE ? "hidden" : "switch"
				),
			'header_fullheight' => array(
				"title" => esc_html__('Header fullheight', 'hanani'),
				"desc" => wp_kses_data( __("Enlarge header area to fill whole screen. Used only if header have a background image", 'hanani') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'hanani')
				),
				"std" => 0,
				"type" => HANANI_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_zoom' => array(
				"title" => esc_html__('Header zoom', 'hanani'),
				"desc" => wp_kses_data( __("Zoom the header title. 1 - original size", 'hanani') ),
				"std" => 1,
				"min" => 0.3,
				"max" => 2,
				"step" => 0.1,
				"refresh" => false,
				"type" => HANANI_THEME_FREE ? "hidden" : "slider"
				),
			'header_wide' => array(
				"title" => esc_html__('Header fullwidth', 'hanani'),
				"desc" => wp_kses_data( __('Do you want to stretch the header widgets area to the entire window width?', 'hanani') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'hanani')
				),
				"dependency" => array(
					'header_type' => array('default')
				),
				"std" => 1,
				"type" => HANANI_THEME_FREE ? "hidden" : "checkbox"
				),

			'header_widgets_info' => array(
				"title" => esc_html__('Header widgets', 'hanani'),
				"desc" => wp_kses_data( __('Here you can place a widget slider, advertising banners, etc.', 'hanani') ),
				"type" => "info"
				),
			'header_widgets' => array(
				"title" => esc_html__('Header widgets', 'hanani'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on each page', 'hanani') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'hanani'),
					"desc" => wp_kses_data( __('Select set of widgets to show in the header on this page', 'hanani') ),
				),
				"std" => 'hide',
				"options" => array(),
				"type" => "select"
				),
			'header_columns' => array(
				"title" => esc_html__('Header columns', 'hanani'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the Header. If 0 - autodetect by the widgets count', 'hanani') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'hanani')
				),
				"dependency" => array(
					'header_type' => array('default'),
					'header_widgets' => array('^hide')
				),
				"std" => 0,
				"options" => hanani_get_list_range(0,6),
				"type" => "select"
				),

			'menu_info' => array(
				"title" => esc_html__('Main menu', 'hanani'),
				"desc" => wp_kses_data( __('Select main menu style, position and other parameters', 'hanani') ),
				"type" => HANANI_THEME_FREE ? "hidden" : "info"
				),
			'menu_style' => array(
				"title" => esc_html__('Menu position', 'hanani'),
				"desc" => wp_kses_data( __('Select position of the main menu', 'hanani') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'hanani')
				),
				"std" => 'top',
				"options" => array(
					'top'	=> esc_html__('Top',	'hanani')
				),
				"type" => HANANI_THEME_FREE || !hanani_exists_trx_addons() ? "hidden" : "switch"
				),
			'menu_side_stretch' => array(
				"title" => esc_html__('Stretch sidemenu', 'hanani'),
				"desc" => wp_kses_data( __('Stretch sidemenu to window height (if menu items number >= 5)', 'hanani') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'hanani')
				),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 0,
				"type" => HANANI_THEME_FREE ? "hidden" : "checkbox"
				),
			'menu_side_icons' => array(
				"title" => esc_html__('Iconed sidemenu', 'hanani'),
				"desc" => wp_kses_data( __('Get icons from anchors and display it in the sidemenu or mark sidemenu items with simple dots', 'hanani') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'hanani')
				),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 1,
				"type" => HANANI_THEME_FREE ? "hidden" : "checkbox"
				),
			'menu_mobile_fullscreen' => array(
				"title" => esc_html__('Mobile menu fullscreen', 'hanani'),
				"desc" => wp_kses_data( __('Display mobile and side menus on full screen (if checked) or slide narrow menu from the left or from the right side (if not checked)', 'hanani') ),
				"std" => 1,
				"type" => HANANI_THEME_FREE ? "hidden" : "checkbox"
				),

			'header_image_info' => array(
				"title" => esc_html__('Header image', 'hanani'),
				"desc" => '',
				"type" => HANANI_THEME_FREE ? "hidden" : "info"
				),
			'header_image_override' => array(
				"title" => esc_html__('Header image override', 'hanani'),
				"desc" => wp_kses_data( __("Allow override the header image with the page's/post's/product's/etc. featured image", 'hanani') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'hanani')
				),
				"std" => 0,
				"type" => HANANI_THEME_FREE ? "hidden" : "checkbox"
				),

			'header_mobile_info' => array(
				"title" => esc_html__('Mobile header', 'hanani'),
				"desc" => wp_kses_data( __("Configure the mobile version of the header", 'hanani') ),
				"priority" => 500,
				"dependency" => array(
					'header_type' => array('default')
				),
				"type" => HANANI_THEME_FREE ? "hidden" : "info"
				),
			'header_mobile_enabled' => array(
				"title" => esc_html__('Enable the mobile header', 'hanani'),
				"desc" => wp_kses_data( __("Use the mobile version of the header (if checked) or relayout the current header on mobile devices", 'hanani') ),
				"dependency" => array(
					'header_type' => array('default')
				),
				"std" => 0,
				"type" => HANANI_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_additional_info' => array(
				"title" => esc_html__('Additional info', 'hanani'),
				"desc" => wp_kses_data( __('Additional info to show at the top of the mobile header', 'hanani') ),
				"std" => '',
				"dependency" => array(
					'header_type' => array('default'),
					'header_mobile_enabled' => array(1)
				),
				"refresh" => false,
				"teeny" => false,
				"rows" => 20,
				"type" => HANANI_THEME_FREE ? "hidden" : "text_editor"
				),
			'header_mobile_hide_info' => array(
				"title" => esc_html__('Hide additional info', 'hanani'),
				"std" => 0,
				"dependency" => array(
					'header_type' => array('default'),
					'header_mobile_enabled' => array(1)
				),
				"type" => HANANI_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_hide_logo' => array(
				"title" => esc_html__('Hide logo', 'hanani'),
				"std" => 0,
				"dependency" => array(
					'header_type' => array('default'),
					'header_mobile_enabled' => array(1)
				),
				"type" => HANANI_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_hide_login' => array(
				"title" => esc_html__('Hide login/logout', 'hanani'),
				"std" => 0,
				"dependency" => array(
					'header_type' => array('default'),
					'header_mobile_enabled' => array(1)
				),
				"type" => HANANI_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_hide_search' => array(
				"title" => esc_html__('Hide search', 'hanani'),
				"std" => 0,
				"dependency" => array(
					'header_type' => array('default'),
					'header_mobile_enabled' => array(1)
				),
				"type" => HANANI_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_hide_cart' => array(
				"title" => esc_html__('Hide cart', 'hanani'),
				"std" => 0,
				"dependency" => array(
					'header_type' => array('default'),
					'header_mobile_enabled' => array(1)
				),
				"type" => HANANI_THEME_FREE ? "hidden" : "checkbox"
				),


		
			// 'Footer'
			'footer' => array(
				"title" => esc_html__('Footer', 'hanani'),
				"desc" => wp_kses_data( $msg_override ),
				"priority" => 50,
				"type" => "section"
				),
			'footer_type' => array(
				"title" => esc_html__('Footer style', 'hanani'),
				"desc" => wp_kses_data( __('Choose whether to use the default footer or footer Layouts (available only if the ThemeREX Addons is activated)', 'hanani') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'hanani')
				),
				"std" => 'default',
				"options" => hanani_get_list_header_footer_types(),
				"type" => HANANI_THEME_FREE || !hanani_exists_trx_addons() ? "hidden" : "switch"
				),
			'footer_style' => array(
				"title" => esc_html__('Select custom layout', 'hanani'),
				"desc" => wp_kses( __("Select custom footer from Layouts Builder", 'hanani'), 'hanani_kses_content' ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'hanani')
				),
				"dependency" => array(
					'footer_type' => array('custom')
				),
				"std" => HANANI_THEME_FREE ? 'footer-custom-elementor-footer-default' : 'footer-custom-footer-default',
				"options" => array(),
				"type" => "select"
				),
			'footer_widgets' => array(
				"title" => esc_html__('Footer widgets', 'hanani'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the footer', 'hanani') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'hanani')
				),
				"dependency" => array(
					'footer_type' => array('default')
				),
				"std" => 'footer_widgets',
				"options" => array(),
				"type" => "select"
				),
			'footer_columns' => array(
				"title" => esc_html__('Footer columns', 'hanani'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'hanani') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'hanani')
				),
				"dependency" => array(
					'footer_type' => array('default'),
					'footer_widgets' => array('^hide')
				),
				"std" => 0,
				"options" => hanani_get_list_range(0,6),
				"type" => "select"
				),
			'footer_wide' => array(
				"title" => esc_html__('Footer fullwidth', 'hanani'),
				"desc" => wp_kses_data( __('Do you want to stretch the footer to the entire window width?', 'hanani') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'hanani')
				),
				"dependency" => array(
					'footer_type' => array('default')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_in_footer' => array(
				"title" => esc_html__('Show logo', 'hanani'),
				"desc" => wp_kses_data( __('Show logo in the footer', 'hanani') ),
				'refresh' => false,
				"dependency" => array(
					'footer_type' => array('default')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_footer' => array(
				"title" => esc_html__('Logo for footer', 'hanani'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the footer', 'hanani') ),
				"dependency" => array(
					'footer_type' => array('default'),
					'logo_in_footer' => array(1)
				),
				"std" => '',
				"type" => "image"
				),
			'logo_footer_retina' => array(
				"title" => esc_html__('Logo for footer (Retina)', 'hanani'),
				"desc" => wp_kses_data( __('Select or upload logo for the footer area used on Retina displays (if empty - use default logo from the field above)', 'hanani') ),
				"dependency" => array(
					'footer_type' => array('default'),
					'logo_in_footer' => array(1),
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => HANANI_THEME_FREE ? "hidden" : "image"
				),
			'socials_in_footer' => array(
				"title" => esc_html__('Show social icons', 'hanani'),
				"desc" => wp_kses_data( __('Show social icons in the footer (under logo or footer widgets)', 'hanani') ),
				"dependency" => array(
					'footer_type' => array('default')
				),
				"std" => 0,
				"type" => !hanani_exists_trx_addons() ? "hidden" : "checkbox"
				),
			'copyright' => array(
				"title" => esc_html__('Copyright', 'hanani'),
				"desc" => wp_kses_data( __('Copyright text in the footer. Use {Y} to insert current year and press "Enter" to create a new line', 'hanani') ),
				"translate" => true,
				"std" => esc_html__('Copyright &copy; {Y} by AncoraThemes. All rights reserved.', 'hanani'),
				"dependency" => array(
					'footer_type' => array('default')
				),
				"refresh" => false,
				"type" => "textarea"
				),
			
		
		
			// 'Blog'
			'blog' => array(
				"title" => esc_html__('Blog', 'hanani'),
				"desc" => wp_kses_data( __('Options of the the blog archive', 'hanani') ),
				"priority" => 70,
				"type" => "panel",
				),
		
				// Blog - Posts page
				'blog_general' => array(
					"title" => esc_html__('Posts page', 'hanani'),
					"desc" => wp_kses_data( __('Style and components of the blog archive', 'hanani') ),
					"type" => "section",
					),
				'blog_general_info' => array(
					"title" => esc_html__('General settings', 'hanani'),
					"desc" => '',
					"type" => "info",
					),
				'blog_style' => array(
					"title" => esc_html__('Blog style', 'hanani'),
					"desc" => '',
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'hanani')
					),
					"dependency" => array(
						'#page_template' => array('blog.php'),
						'.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
					),
					"std" => 'excerpt',
					"options" => array(),
					"type" => "select"
					),
				'first_post_large' => array(
					"title" => esc_html__('First post large', 'hanani'),
					"desc" => wp_kses_data( __('Make your first post stand out by making it bigger', 'hanani') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'hanani')
					),
					"dependency" => array(
						'#page_template' => array('blog.php'),
						'.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
						'blog_style' => array('classic', 'masonry')
					),
					"std" => 0,
					"type" => "checkbox"
					),
				"blog_content" => array( 
					"title" => esc_html__('Posts content', 'hanani'),
					"desc" => wp_kses_data( __("Display either post excerpts or the full post content", 'hanani') ),
					"std" => "excerpt",
					"dependency" => array(
						'blog_style' => array('excerpt')
					),
					"options" => array(
						'excerpt'	=> esc_html__('Excerpt',	'hanani'),
						'fullpost'	=> esc_html__('Full post',	'hanani')
					),
					"type" => "switch"
					),
				'excerpt_length' => array(
					"title" => esc_html__('Excerpt length', 'hanani'),
					"desc" => wp_kses_data( __("Length (in words) to generate excerpt from the post content. Attention! If the post excerpt is explicitly specified - it appears unchanged", 'hanani') ),
					"dependency" => array(
						'blog_style' => array('excerpt'),
						'blog_content' => array('excerpt')
					),
					"std" => 60,
					"type" => "text"
					),
				'blog_columns' => array(
					"title" => esc_html__('Blog columns', 'hanani'),
					"desc" => wp_kses_data( __('How many columns should be used in the blog archive (from 2 to 4)?', 'hanani') ),
					"std" => 2,
					"options" => hanani_get_list_range(2,4),
					"type" => "hidden"
					),
				'post_type' => array(
					"title" => esc_html__('Post type', 'hanani'),
					"desc" => wp_kses_data( __('Select post type to show in the blog archive', 'hanani') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'hanani')
					),
					"dependency" => array(
						'#page_template' => array('blog.php'),
						'.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
					),
					"linked" => 'parent_cat',
					"refresh" => false,
					"hidden" => true,
					"std" => 'post',
					"options" => array(),
					"type" => "select"
					),
				'parent_cat' => array(
					"title" => esc_html__('Category to show', 'hanani'),
					"desc" => wp_kses_data( __('Select category to show in the blog archive', 'hanani') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'hanani')
					),
					"dependency" => array(
						'#page_template' => array('blog.php'),
						'.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
					),
					"refresh" => false,
					"hidden" => true,
					"std" => '0',
					"options" => array(),
					"type" => "select"
					),
				'posts_per_page' => array(
					"title" => esc_html__('Posts per page', 'hanani'),
					"desc" => wp_kses_data( __('How many posts will be displayed on this page', 'hanani') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'hanani')
					),
					"dependency" => array(
						'#page_template' => array('blog.php'),
						'.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
					),
					"hidden" => true,
					"std" => '',
					"type" => "text"
					),
				"blog_pagination" => array( 
					"title" => esc_html__('Pagination style', 'hanani'),
					"desc" => wp_kses_data( __('Show Older/Newest posts or Page numbers below the posts list', 'hanani') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'hanani')
					),
					"std" => "pages",
					"dependency" => array(
						'#page_template' => array('blog.php'),
						'.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
					),
					"options" => array(
						'pages'	=> esc_html__("Page numbers", 'hanani'),
						'links'	=> esc_html__("Older/Newest", 'hanani'),
						'more'	=> esc_html__("Load more", 'hanani'),
						'infinite' => esc_html__("Infinite scroll", 'hanani')
					),
					"type" => "select"
					),
				'show_filters' => array(
					"title" => esc_html__('Show filters', 'hanani'),
					"desc" => wp_kses_data( __('Show categories as tabs to filter posts', 'hanani') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'hanani')
					),
					"dependency" => array(
						'#page_template' => array('blog.php'),
						'.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
						'blog_style' => array('portfolio', 'gallery')
					),
					"hidden" => true,
					"std" => 0,
					"type" => HANANI_THEME_FREE ? "hidden" : "checkbox"
					),
	
				'blog_sidebar_info' => array(
					"title" => esc_html__('Sidebar', 'hanani'),
					"desc" => '',
					"type" => "info",
					),
				'sidebar_position_blog' => array(
					"title" => esc_html__('Sidebar position', 'hanani'),
					"desc" => wp_kses_data( __('Select position to show sidebar', 'hanani') ),
					"std" => 'right',
					"options" => array(),
					"type" => "switch"
					),
				'sidebar_widgets_blog' => array(
					"title" => esc_html__('Sidebar widgets', 'hanani'),
					"desc" => wp_kses_data( __('Select default widgets to show in the sidebar', 'hanani') ),
					"dependency" => array(
						'sidebar_position_blog' => array('left', 'right')
					),
					"std" => 'sidebar_widgets',
					"options" => array(),
					"type" => "select"
					),
				'expand_content_blog' => array(
					"title" => esc_html__('Expand content', 'hanani'),
					"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'hanani') ),
					"refresh" => false,
					"std" => 1,
					"type" => "checkbox"
					),
	
	
				'blog_widgets_info' => array(
					"title" => esc_html__('Additional widgets', 'hanani'),
					"desc" => '',
					"type" => HANANI_THEME_FREE ? "hidden" : "info",
					),
				'widgets_above_page_blog' => array(
					"title" => esc_html__('Widgets at the top of the page', 'hanani'),
					"desc" => wp_kses_data( __('Select widgets to show at the top of the page (above content and sidebar)', 'hanani') ),
					"std" => 'hide',
					"options" => array(),
					"type" => HANANI_THEME_FREE ? "hidden" : "select"
					),
				'widgets_above_content_blog' => array(
					"title" => esc_html__('Widgets above the content', 'hanani'),
					"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'hanani') ),
					"std" => 'hide',
					"options" => array(),
					"type" => HANANI_THEME_FREE ? "hidden" : "select"
					),
				'widgets_below_content_blog' => array(
					"title" => esc_html__('Widgets below the content', 'hanani'),
					"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'hanani') ),
					"std" => 'hide',
					"options" => array(),
					"type" => HANANI_THEME_FREE ? "hidden" : "select"
					),
				'widgets_below_page_blog' => array(
					"title" => esc_html__('Widgets at the bottom of the page', 'hanani'),
					"desc" => wp_kses_data( __('Select widgets to show at the bottom of the page (below content and sidebar)', 'hanani') ),
					"std" => 'hide',
					"options" => array(),
					"type" => HANANI_THEME_FREE ? "hidden" : "select"
					),

				'blog_advanced_info' => array(
					"title" => esc_html__('Advanced settings', 'hanani'),
					"desc" => '',
					"type" => "info",
					),
				'no_image' => array(
					"title" => esc_html__('Image placeholder', 'hanani'),
					"desc" => wp_kses_data( __('Select or upload an image used as placeholder for posts without a featured image', 'hanani') ),
					"std" => '',
					"type" => "image"
					),
				'time_diff_before' => array(
					"title" => esc_html__('Easy Readable Date Format', 'hanani'),
					"desc" => wp_kses_data( __("For how many days to show the easy-readable date format (e.g. '3 days ago') instead of the standard publication date", 'hanani') ),
					"std" => 5,
					"type" => "text"
					),
				'sticky_style' => array(
					"title" => esc_html__('Sticky posts style', 'hanani'),
					"desc" => wp_kses_data( __('Select style of the sticky posts output', 'hanani') ),
					"std" => 'inherit',
					"options" => array(
						'inherit' => esc_html__('Decorated posts', 'hanani'),
						'columns' => esc_html__('Mini-cards',	'hanani')
					),
					"type" => HANANI_THEME_FREE ? "hidden" : "select"
					),
				"blog_animation" => array( 
					"title" => esc_html__('Animation for the posts', 'hanani'),
					"desc" => wp_kses_data( __('Select animation to show posts in the blog. Attention! Do not use any animation on pages with the "wheel to the anchor" behaviour (like a "Chess 2 columns")!', 'hanani') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'hanani')
					),
					"dependency" => array(
						'#page_template' => array('blog.php'),
						'.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
					),
					"std" => "none",
					"options" => array(),
					"type" => HANANI_THEME_FREE ? "hidden" : "select"
					),
				'meta_parts' => array(
					"title" => esc_html__('Post meta', 'hanani'),
					"desc" => wp_kses_data( __("If your blog page is created using the 'Blog archive' page template, set up the 'Post Meta' settings in the 'Theme Options' section of that page. Post counters and Share Links are available only if plugin ThemeREX Addons is active", 'hanani') )
								. '<br>'
								. wp_kses_data( __("<b>Tip:</b> Drag items to change their order.", 'hanani') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'hanani')
					),
					"dependency" => array(
						'#page_template' => array('blog.php'),
						'.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
					),
					"dir" => 'vertical',
					"sortable" => true,
					"std" => 'categories=1|date=1|counters=1|author=1|share=1|edit=0',
					"options" => array(
						'categories' => esc_html__('Categories', 'hanani'),
						'date'		 => esc_html__('Post date', 'hanani'),
						'author'	 => esc_html__('Post author', 'hanani'),
						'counters'	 => esc_html__('Post counters', 'hanani'),
						'share'		 => esc_html__('Share links', 'hanani'),
						'edit'		 => esc_html__('Edit link', 'hanani')
					),
					"type" => HANANI_THEME_FREE ? "hidden" : "checklist"
				),
				'counters' => array(
					"title" => esc_html__('Post counters', 'hanani'),
					"desc" => wp_kses_data( __("Show only selected counters. Attention! Likes and Views are available only if ThemeREX Addons is active", 'hanani') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'hanani')
					),
					"dependency" => array(
						'#page_template' => array('blog.php'),
						'.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
					),
					"dir" => 'vertical',
					"sortable" => true,
					"std" => 'views=0|likes=0|comments=1',
					"options" => array(
						'views' => esc_html__('Views', 'hanani'),
						'likes' => esc_html__('Likes', 'hanani'),
						'comments' => esc_html__('Comments', 'hanani')
					),
					"type" => HANANI_THEME_FREE || !hanani_exists_trx_addons() ? "hidden" : "checklist"
				),

				
				// Blog - Single posts
				'blog_single' => array(
					"title" => esc_html__('Single posts', 'hanani'),
					"desc" => wp_kses_data( __('Settings of the single post', 'hanani') ),
					"type" => "section",
					),
				'hide_featured_on_single' => array(
					"title" => esc_html__('Hide featured image on the single post', 'hanani'),
					"desc" => wp_kses_data( __("Hide featured image on the single post's pages", 'hanani') ),
					"override" => array(
						'mode' => 'page,post',
						'section' => esc_html__('Content', 'hanani')
					),
					"std" => 0,
					"type" => "checkbox"
					),
				'hide_sidebar_on_single' => array(
					"title" => esc_html__('Hide sidebar on the single post', 'hanani'),
					"desc" => wp_kses_data( __("Hide sidebar on the single post's pages", 'hanani') ),
					"std" => 0,
					"type" => "checkbox"
					),
				'show_post_meta' => array(
					"title" => esc_html__('Show post meta', 'hanani'),
					"desc" => wp_kses_data( __("Display block with post's meta: date, categories, counters, etc.", 'hanani') ),
					"std" => 1,
					"type" => "checkbox"
					),
				'meta_parts_post' => array(
					"title" => esc_html__('Post meta', 'hanani'),
					"desc" => wp_kses_data( __("Meta parts for single posts. Post counters and Share Links are available only if plugin ThemeREX Addons is active", 'hanani') )
								. '<br>'
								. wp_kses_data( __("<b>Tip:</b> Drag items to change their order.", 'hanani') ),
					"dependency" => array(
						'show_post_meta' => array(1)
					),
					"dir" => 'vertical',
					"sortable" => true,
					"std" => 'categories=1|date=1|counters=1|author=0|share=0|edit=1',
					"options" => array(
						'categories' => esc_html__('Categories', 'hanani'),
						'date'		 => esc_html__('Post date', 'hanani'),
						'author'	 => esc_html__('Post author', 'hanani'),
						'counters'	 => esc_html__('Post counters', 'hanani'),
						'share'		 => esc_html__('Share links', 'hanani'),
						'edit'		 => esc_html__('Edit link', 'hanani')
					),
					"type" => HANANI_THEME_FREE ? "hidden" : "checklist"
				),
				'counters_post' => array(
					"title" => esc_html__('Post counters', 'hanani'),
					"desc" => wp_kses_data( __("Show only selected counters. Attention! Likes and Views are available only if plugin ThemeREX Addons is active", 'hanani') ),
					"dependency" => array(
						'show_post_meta' => array(1)
					),
					"dir" => 'vertical',
					"sortable" => true,
					"std" => 'views=1|likes=1|comments=1',
					"options" => array(
						'views' => esc_html__('Views', 'hanani'),
						'likes' => esc_html__('Likes', 'hanani'),
						'comments' => esc_html__('Comments', 'hanani')
					),
					"type" => HANANI_THEME_FREE || !hanani_exists_trx_addons() ? "hidden" : "checklist"
				),
				'show_share_links' => array(
					"title" => esc_html__('Show share links', 'hanani'),
					"desc" => wp_kses_data( __("Display share links on the single post", 'hanani') ),
					"std" => 1,
					"type" => !hanani_exists_trx_addons() ? "hidden" : "checkbox"
					),
				'show_author_info' => array(
					"title" => esc_html__('Show author info', 'hanani'),
					"desc" => wp_kses_data( __("Display block with information about post's author", 'hanani') ),
					"std" => 1,
					"type" => "checkbox"
					),
				'blog_single_related_info' => array(
					"title" => esc_html__('Related posts', 'hanani'),
					"desc" => '',
					"type" => "info",
					),
				'show_related_posts' => array(
					"title" => esc_html__('Show related posts', 'hanani'),
					"desc" => wp_kses_data( __("Show section 'Related posts' on the single post's pages", 'hanani') ),
					"override" => array(
						'mode' => 'post',
						'section' => esc_html__('Content', 'hanani')
					),
					"std" => 1,
					"type" => "checkbox"
					),
				'related_posts' => array(
					"title" => esc_html__('Related posts', 'hanani'),
					"desc" => wp_kses_data( __('How many related posts should be displayed in the single post? If 0 - no related posts are shown.', 'hanani') ),
					"dependency" => array(
						'show_related_posts' => array(1)
					),
					"std" => 2,
					"options" => hanani_get_list_range(1,9),
					"type" => HANANI_THEME_FREE ? "hidden" : "select"
					),
				'related_columns' => array(
					"title" => esc_html__('Related columns', 'hanani'),
					"desc" => wp_kses_data( __('How many columns should be used to output related posts in the single page (from 2 to 4)?', 'hanani') ),
					"dependency" => array(
						'show_related_posts' => array(1)
					),
					"std" => 2,
					"options" => hanani_get_list_range(1,4),
					"type" => HANANI_THEME_FREE ? "hidden" : "switch"
					),
				'related_style' => array(
					"title" => esc_html__('Related posts style', 'hanani'),
					"desc" => wp_kses_data( __('Select style of the related posts output', 'hanani') ),
					"dependency" => array(
						'show_related_posts' => array(1)
					),
					"std" => 2,
					"options" => hanani_get_list_styles(1,2),
					"type" => HANANI_THEME_FREE ? "hidden" : "switch"
					),
			'blog_end' => array(
				"type" => "panel_end",
				),
			
		
		
			// 'Colors'
			'panel_colors' => array(
				"title" => esc_html__('Colors', 'hanani'),
				"desc" => '',
				"priority" => 300,
				"type" => "section"
				),

			'color_schemes_info' => array(
				"title" => esc_html__('Color schemes', 'hanani'),
				"desc" => wp_kses_data( __('Color schemes for various parts of the site. "Inherit" means that this block is used the Site color scheme (the first parameter)', 'hanani') ),
				"hidden" => $hide_schemes,
				"type" => "info",
				),
			'color_scheme' => array(
				"title" => esc_html__('Site Color Scheme', 'hanani'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'hanani')
				),
				"std" => 'default',
				"options" => array(),
				"refresh" => false,
				"type" => $hide_schemes ? 'hidden' : "switch"
				),
			'header_scheme' => array(
				"title" => esc_html__('Header Color Scheme', 'hanani'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'hanani')
				),
				"std" => 'inherit',
				"options" => array(),
				"refresh" => false,
				"type" => $hide_schemes ? 'hidden' : "switch"
				),
			'menu_scheme' => array(
				"title" => esc_html__('Sidemenu Color Scheme', 'hanani'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'hanani')
				),
				"std" => 'inherit',
				"options" => array(),
				"refresh" => false,
				"type" =>  "hidden"
				),
			'sidebar_scheme' => array(
				"title" => esc_html__('Sidebar Color Scheme', 'hanani'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'hanani')
				),
				"std" => 'inherit',
				"options" => array(),
				"refresh" => false,
				"type" => $hide_schemes ? 'hidden' : "switch"
				),
			'footer_scheme' => array(
				"title" => esc_html__('Footer Color Scheme', 'hanani'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'hanani')
				),
				"std" => 'dark',
				"options" => array(),
				"refresh" => false,
				"type" => $hide_schemes ? 'hidden' : "switch"
				),

			'color_scheme_editor_info' => array(
				"title" => esc_html__('Color scheme editor', 'hanani'),
				"desc" => wp_kses_data(__('Select color scheme to modify. Attention! Only those sections in the site will be changed which this scheme was assigned to', 'hanani') ),
				"type" => "info",
				),
			'scheme_storage' => array(
				"title" => esc_html__('Color scheme editor', 'hanani'),
				"desc" => '',
				"std" => '$hanani_get_scheme_storage',
				"refresh" => false,
				"colorpicker" => "tiny",
				"type" => "scheme_editor"
				),


			// 'Hidden'
			'media_title' => array(
				"title" => esc_html__('Media title', 'hanani'),
				"desc" => wp_kses_data( __('Used as title for the audio and video item in this post', 'hanani') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Content', 'hanani')
				),
				"hidden" => true,
				"std" => '',
				"type" => HANANI_THEME_FREE ? "hidden" : "text"
				),
			'media_author' => array(
				"title" => esc_html__('Media author', 'hanani'),
				"desc" => wp_kses_data( __('Used as author name for the audio and video item in this post', 'hanani') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Content', 'hanani')
				),
				"hidden" => true,
				"std" => '',
				"type" => HANANI_THEME_FREE ? "hidden" : "text"
				),


			// Internal options.
			// Attention! Don't change any options in the section below!
			// Use huge priority to call render this elements after all options!
			'reset_options' => array(
				"title" => '',
				"desc" => '',
				"std" => '0',
				"priority" => 10000,
				"type" => "hidden",
				),

			'last_option' => array(		// Need to manually call action to include Tiny MCE scripts
				"title" => '',
				"desc" => '',
				"std" => 1,
				"type" => "hidden",
				),

		));


		// Prepare panel 'Fonts'
		// -------------------------------------------------------------
		$fonts = array(
		
			// 'Fonts'
			'fonts' => array(
				"title" => esc_html__('Typography', 'hanani'),
				"desc" => '',
				"priority" => 200,
				"type" => "panel"
				),

			// Fonts - Load_fonts
			'load_fonts' => array(
				"title" => esc_html__('Load fonts', 'hanani'),
				"desc" => wp_kses_data( __('Specify fonts to load when theme start. You can use them in the base theme elements: headers, text, menu, links, input fields, etc.', 'hanani') )
						. '<br>'
						. wp_kses_data( __('Attention! Press "Refresh" button to reload preview area after the all fonts are changed', 'hanani') ),
				"type" => "section"
				),
			'load_fonts_subset' => array(
				"title" => esc_html__('Google fonts subsets', 'hanani'),
				"desc" => wp_kses_data( __('Specify comma separated list of the subsets which will be load from Google fonts', 'hanani') )
						. '<br>'
						. wp_kses_data( __('Available subsets are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese', 'hanani') ),
				"class" => "hanani_column-1_3 hanani_new_row",
				"refresh" => false,
				"std" => '$hanani_get_load_fonts_subset',
				"type" => "text"
				)
		);

		for ($i=1; $i<=hanani_get_theme_setting('max_load_fonts'); $i++) {
			if (hanani_get_value_gp('page') != 'theme_options') {
				$fonts["load_fonts-{$i}-info"] = array(
					// Translators: Add font's number - 'Font 1', 'Font 2', etc
					"title" => esc_html(sprintf(__('Font %s', 'hanani'), $i)),
					"desc" => '',
					"type" => "info",
					);
			}
			$fonts["load_fonts-{$i}-name"] = array(
				"title" => esc_html__('Font name', 'hanani'),
				"desc" => '',
				"class" => "hanani_column-1_3 hanani_new_row",
				"refresh" => false,
				"std" => '$hanani_get_load_fonts_option',
				"type" => "text"
				);
			$fonts["load_fonts-{$i}-family"] = array(
				"title" => esc_html__('Font family', 'hanani'),
				"desc" => $i==1 
							? wp_kses_data( __('Select font family to use it if font above is not available', 'hanani') )
							: '',
				"class" => "hanani_column-1_3",
				"refresh" => false,
				"std" => '$hanani_get_load_fonts_option',
				"options" => array(
					'inherit' => esc_html__("Inherit", 'hanani'),
					'serif' => esc_html__('serif', 'hanani'),
					'sans-serif' => esc_html__('sans-serif', 'hanani'),
					'monospace' => esc_html__('monospace', 'hanani'),
					'cursive' => esc_html__('cursive', 'hanani'),
					'fantasy' => esc_html__('fantasy', 'hanani')
				),
				"type" => "select"
				);
			$fonts["load_fonts-{$i}-styles"] = array(
				"title" => esc_html__('Font styles', 'hanani'),
				"desc" => $i==1 
							? wp_kses_data( __('Font styles used only for the Google fonts. This is a comma separated list of the font weight and styles. For example: 400,400italic,700', 'hanani') )
								. '<br>'
								. wp_kses_data( __('Attention! Each weight and style increase download size! Specify only used weights and styles.', 'hanani') )
							: '',
				"class" => "hanani_column-1_3",
				"refresh" => false,
				"std" => '$hanani_get_load_fonts_option',
				"type" => "text"
				);
		}
		$fonts['load_fonts_end'] = array(
			"type" => "section_end"
			);

		// Fonts - H1..6, P, Info, Menu, etc.
		$theme_fonts = hanani_get_theme_fonts();
		foreach ($theme_fonts as $tag=>$v) {
			$fonts["{$tag}_section"] = array(
				"title" => !empty($v['title']) 
								? $v['title'] 
								// Translators: Add tag's name to make title 'H1 settings', 'P settings', etc.
								: esc_html(sprintf(__('%s settings', 'hanani'), $tag)),
				"desc" => !empty($v['description']) 
								? $v['description'] 
								// Translators: Add tag's name to make description
								: wp_kses( sprintf(__('Font settings of the "%s" tag.', 'hanani'), $tag), 'hanani_kses_content' ),
				"type" => "section",
				);
	
			foreach ($v as $css_prop=>$css_value) {
				if (in_array($css_prop, array('title', 'description'))) continue;
				$options = '';
				$type = 'text';
				$load_order = 1;
				$title = ucfirst(str_replace('-', ' ', $css_prop));
				if ($css_prop == 'font-family') {
					$type = 'select';
					$options = array();
					$load_order = 2;		// Load this option's value after all options are loaded (use option 'load_fonts' to build fonts list)
				} else if ($css_prop == 'font-weight') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'hanani'),
						'100' => esc_html__('100 (Light)', 'hanani'), 
						'200' => esc_html__('200 (Light)', 'hanani'), 
						'300' => esc_html__('300 (Thin)',  'hanani'),
						'400' => esc_html__('400 (Normal)', 'hanani'),
						'500' => esc_html__('500 (Semibold)', 'hanani'),
						'600' => esc_html__('600 (Semibold)', 'hanani'),
						'700' => esc_html__('700 (Bold)', 'hanani'),
						'800' => esc_html__('800 (Black)', 'hanani'),
						'900' => esc_html__('900 (Black)', 'hanani')
					);
				} else if ($css_prop == 'font-style') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'hanani'),
						'normal' => esc_html__('Normal', 'hanani'), 
						'italic' => esc_html__('Italic', 'hanani')
					);
				} else if ($css_prop == 'text-decoration') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'hanani'),
						'none' => esc_html__('None', 'hanani'), 
						'underline' => esc_html__('Underline', 'hanani'),
						'overline' => esc_html__('Overline', 'hanani'),
						'line-through' => esc_html__('Line-through', 'hanani')
					);
				} else if ($css_prop == 'text-transform') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'hanani'),
						'none' => esc_html__('None', 'hanani'), 
						'uppercase' => esc_html__('Uppercase', 'hanani'),
						'lowercase' => esc_html__('Lowercase', 'hanani'),
						'capitalize' => esc_html__('Capitalize', 'hanani')
					);
				}
				$fonts["{$tag}_{$css_prop}"] = array(
					"title" => $title,
					"desc" => '',
					"class" => "hanani_column-1_5",
					"refresh" => false,
					"load_order" => $load_order,
					"std" => '$hanani_get_theme_fonts_option',
					"options" => $options,
					"type" => $type
				);
			}
			
			$fonts["{$tag}_section_end"] = array(
				"type" => "section_end"
				);
		}

		$fonts['fonts_end'] = array(
			"type" => "panel_end"
			);

		// Add fonts parameters to Theme Options
		hanani_storage_set_array_before('options', 'panel_colors', $fonts);


		// Add Header Video if WP version < 4.7
		// -----------------------------------------------------
		if (!function_exists('get_header_video_url')) {
			hanani_storage_set_array_after('options', 'header_image_override', 'header_video', array(
				"title" => esc_html__('Header video', 'hanani'),
				"desc" => wp_kses_data( __("Select video to use it as background for the header", 'hanani') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'hanani')
				),
				"std" => '',
				"type" => "video"
				)
			);
		}


		// Add option 'logo' if WP version < 4.5
		// or 'custom_logo' if current page is 'Theme Options'
		// ------------------------------------------------------
		if (!function_exists('the_custom_logo') || (isset($_REQUEST['page']) && $_REQUEST['page']=='theme_options')) {
			hanani_storage_set_array_before('options', 'logo_retina', function_exists('the_custom_logo') ? 'custom_logo' : 'logo', array(
				"title" => esc_html__('Logo', 'hanani'),
				"desc" => wp_kses_data( __('Select or upload the site logo', 'hanani') ),
				"class" => "hanani_column-1_2 hanani_new_row",
				"priority" => 60,
				"std" => '',
				"type" => "image"
				)
			);
		}

	}
}


// Returns a list of options that can be overridden for CPT
if (!function_exists('hanani_options_get_list_cpt_options')) {
	function hanani_options_get_list_cpt_options($cpt, $title='') {
		if (empty($title)) $title = ucfirst($cpt);
		return array(
					"header_info_{$cpt}" => array(
						"title" => esc_html__('Header', 'hanani'),
						"desc" => '',
						"type" => "info",
						),
					"header_type_{$cpt}" => array(
						"title" => esc_html__('Header style', 'hanani'),
						"desc" => wp_kses_data( __('Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'hanani') ),
						"std" => 'inherit',
						"options" => hanani_get_list_header_footer_types(true),
						"type" => HANANI_THEME_FREE ? "hidden" : "switch"
						),
					"header_style_{$cpt}" => array(
						"title" => esc_html__('Select custom layout', 'hanani'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select custom layout to display the site header on the %s pages', 'hanani'), $title) ),
						"dependency" => array(
							"header_type_{$cpt}" => array('custom')
						),
						"std" => 'inherit',
						"options" => array(),
						"type" => HANANI_THEME_FREE ? "hidden" : "select"
						),
					"header_position_{$cpt}" => array(
						"title" => esc_html__('Header position', 'hanani'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select position to display the site header on the %s pages', 'hanani'), $title) ),
						"std" => 'inherit',
						"options" => array(),
						"type" => HANANI_THEME_FREE ? "hidden" : "switch"
						),
					"header_image_override_{$cpt}" => array(
						"title" => esc_html__('Header image override', 'hanani'),
						"desc" => wp_kses_data( __("Allow override the header image with the post's featured image", 'hanani') ),
						"std" => 'inherit',
						"options" => array(
							'inherit' => esc_html__('Inherit', 'hanani'),
							1 => esc_html__('Yes', 'hanani'),
							0 => esc_html__('No', 'hanani'),
						),
						"type" => HANANI_THEME_FREE ? "hidden" : "switch"
						),
					"header_widgets_{$cpt}" => array(
						"title" => esc_html__('Header widgets', 'hanani'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select set of widgets to show in the header on the %s pages', 'hanani'), $title) ),
						"std" => 'hide',
						"options" => array(),
						"type" => "select"
						),
						
					"sidebar_info_{$cpt}" => array(
						"title" => esc_html__('Sidebar', 'hanani'),
						"desc" => '',
						"type" => "info",
						),
					"sidebar_position_{$cpt}" => array(
						"title" => esc_html__('Sidebar position', 'hanani'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select position to show sidebar on the %s pages', 'hanani'), $title) ),
						"std" => 'left',
						"options" => array(),
						"type" => "switch"
						),
					"sidebar_widgets_{$cpt}" => array(
						"title" => esc_html__('Sidebar widgets', 'hanani'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select sidebar to show on the %s pages', 'hanani'), $title) ),
						"dependency" => array(
							"sidebar_position_{$cpt}" => array('left', 'right')
						),
						"std" => 'hide',
						"options" => array(),
						"type" => "select"
						),
					"hide_sidebar_on_single_{$cpt}" => array(
						"title" => esc_html__('Hide sidebar on the single pages', 'hanani'),
						"desc" => wp_kses_data( __("Hide sidebar on the single page", 'hanani') ),
						"std" => 'inherit',
						"options" => array(
							'inherit' => esc_html__('Inherit', 'hanani'),
							1 => esc_html__('Hide', 'hanani'),
							0 => esc_html__('Show', 'hanani'),
						),
						"type" => "switch"
						),
						
					"footer_info_{$cpt}" => array(
						"title" => esc_html__('Footer', 'hanani'),
						"desc" => '',
						"type" => "info",
						),
					"footer_type_{$cpt}" => array(
						"title" => esc_html__('Footer style', 'hanani'),
						"desc" => wp_kses_data( __('Choose whether to use the default footer or footer Layouts (available only if the ThemeREX Addons is activated)', 'hanani') ),
						"std" => 'inherit',
						"options" => hanani_get_list_header_footer_types(true),
						"type" => HANANI_THEME_FREE ? "hidden" : "switch"
						),
					"footer_style_{$cpt}" => array(
						"title" => esc_html__('Select custom layout', 'hanani'),
						"desc" => wp_kses_data( __('Select custom layout to display the site footer', 'hanani') ),
						"std" => 'inherit',
						"dependency" => array(
							"footer_type_{$cpt}" => array('custom')
						),
						"options" => array(),
						"type" => HANANI_THEME_FREE ? "hidden" : "select"
						),
					"footer_widgets_{$cpt}" => array(
						"title" => esc_html__('Footer widgets', 'hanani'),
						"desc" => wp_kses_data( __('Select set of widgets to show in the footer', 'hanani') ),
						"dependency" => array(
							"footer_type_{$cpt}" => array('default')
						),
						"std" => 'footer_widgets',
						"options" => array(),
						"type" => "select"
						),
					"footer_columns_{$cpt}" => array(
						"title" => esc_html__('Footer columns', 'hanani'),
						"desc" => wp_kses_data( __('Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'hanani') ),
						"dependency" => array(
							"footer_type_{$cpt}" => array('default'),
							"footer_widgets_{$cpt}" => array('^hide')
						),
						"std" => 0,
						"options" => hanani_get_list_range(0,6),
						"type" => "select"
						),
					"footer_wide_{$cpt}" => array(
						"title" => esc_html__('Footer fullwidth', 'hanani'),
						"desc" => wp_kses_data( __('Do you want to stretch the footer to the entire window width?', 'hanani') ),
						"dependency" => array(
							"footer_type_{$cpt}" => array('default')
						),
						"std" => 0,
						"type" => "checkbox"
						),
						
					"widgets_info_{$cpt}" => array(
						"title" => esc_html__('Additional panels', 'hanani'),
						"desc" => '',
						"type" => HANANI_THEME_FREE ? "hidden" : "info",
						),
					"widgets_above_page_{$cpt}" => array(
						"title" => esc_html__('Widgets at the top of the page', 'hanani'),
						"desc" => wp_kses_data( __('Select widgets to show at the top of the page (above content and sidebar)', 'hanani') ),
						"std" => 'hide',
						"options" => array(),
						"type" => HANANI_THEME_FREE ? "hidden" : "select"
						),
					"widgets_above_content_{$cpt}" => array(
						"title" => esc_html__('Widgets above the content', 'hanani'),
						"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'hanani') ),
						"std" => 'hide',
						"options" => array(),
						"type" => HANANI_THEME_FREE ? "hidden" : "select"
						),
					"widgets_below_content_{$cpt}" => array(
						"title" => esc_html__('Widgets below the content', 'hanani'),
						"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'hanani') ),
						"std" => 'hide',
						"options" => array(),
						"type" => HANANI_THEME_FREE ? "hidden" : "select"
						),
					"widgets_below_page_{$cpt}" => array(
						"title" => esc_html__('Widgets at the bottom of the page', 'hanani'),
						"desc" => wp_kses_data( __('Select widgets to show at the bottom of the page (below content and sidebar)', 'hanani') ),
						"std" => 'hide',
						"options" => array(),
						"type" => HANANI_THEME_FREE ? "hidden" : "select"
						)
					);
	}
}


// Return lists with choises when its need in the admin mode
if (!function_exists('hanani_options_get_list_choises')) {
	add_filter('hanani_filter_options_get_list_choises', 'hanani_options_get_list_choises', 10, 2);
	function hanani_options_get_list_choises($list, $id) {
		if (is_array($list) && count($list)==0) {
			if (strpos($id, 'header_style')===0)
				$list = hanani_get_list_header_styles(strpos($id, 'header_style_')===0);
			else if (strpos($id, 'header_position')===0)
				$list = hanani_get_list_header_positions(strpos($id, 'header_position_')===0);
			else if (strpos($id, 'header_widgets')===0)
				$list = hanani_get_list_sidebars(strpos($id, 'header_widgets_')===0, true);
			else if (strpos($id, '_scheme') > 0)
				$list = hanani_get_list_schemes($id!='color_scheme');
			else if (strpos($id, 'sidebar_widgets')===0)
				$list = hanani_get_list_sidebars(strpos($id, 'sidebar_widgets_')===0, true);
			else if (strpos($id, 'sidebar_position')===0)
				$list = hanani_get_list_sidebars_positions(strpos($id, 'sidebar_position_')===0);
			else if (strpos($id, 'widgets_above_page')===0)
				$list = hanani_get_list_sidebars(strpos($id, 'widgets_above_page_')===0, true);
			else if (strpos($id, 'widgets_above_content')===0)
				$list = hanani_get_list_sidebars(strpos($id, 'widgets_above_content_')===0, true);
			else if (strpos($id, 'widgets_below_page')===0)
				$list = hanani_get_list_sidebars(strpos($id, 'widgets_below_page_')===0, true);
			else if (strpos($id, 'widgets_below_content')===0)
				$list = hanani_get_list_sidebars(strpos($id, 'widgets_below_content_')===0, true);
			else if (strpos($id, 'footer_style')===0)
				$list = hanani_get_list_footer_styles(strpos($id, 'footer_style_')===0);
			else if (strpos($id, 'footer_widgets')===0)
				$list = hanani_get_list_sidebars(strpos($id, 'footer_widgets_')===0, true);
			else if (strpos($id, 'blog_style')===0)
				$list = hanani_get_list_blog_styles(strpos($id, 'blog_style_')===0);
			else if (strpos($id, 'post_type')===0)
				$list = hanani_get_list_posts_types();
			else if (strpos($id, 'parent_cat')===0)
				$list = hanani_array_merge(array(0 => esc_html__('- Select category -', 'hanani')), hanani_get_list_categories());
			else if (strpos($id, 'blog_animation')===0)
				$list = hanani_get_list_animations_in();
			else if ($id == 'color_scheme_editor')
				$list = hanani_get_list_schemes();
			else if (strpos($id, '_font-family') > 0)
				$list = hanani_get_list_load_fonts(true);
		}
		return $list;
	}
}
?>