<?php
/**
 * The template to display the widgets area in the header
 *
 * @package WordPress
 * @subpackage HANANI
 * @since HANANI 1.0
 */

// Header sidebar
$hanani_header_name = hanani_get_theme_option('header_widgets');
$hanani_header_present = !hanani_is_off($hanani_header_name) && is_active_sidebar($hanani_header_name);
if ($hanani_header_present) { 
	hanani_storage_set('current_sidebar', 'header');
	$hanani_header_wide = hanani_get_theme_option('header_wide');
	ob_start();
	if ( is_active_sidebar($hanani_header_name) ) {
		dynamic_sidebar($hanani_header_name);
	}
	$hanani_widgets_output = ob_get_contents();
	ob_end_clean();
	if (!empty($hanani_widgets_output)) {
		$hanani_widgets_output = preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $hanani_widgets_output);
		$hanani_need_columns = strpos($hanani_widgets_output, 'columns_wrap')===false;
		if ($hanani_need_columns) {
			$hanani_columns = max(0, (int) hanani_get_theme_option('header_columns'));
			if ($hanani_columns == 0) $hanani_columns = min(6, max(1, substr_count($hanani_widgets_output, '<aside ')));
			if ($hanani_columns > 1)
				$hanani_widgets_output = preg_replace("/<aside([^>]*)class=\"widget/", "<aside$1class=\"column-1_".esc_attr($hanani_columns).' widget', $hanani_widgets_output);
			else
				$hanani_need_columns = false;
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo !empty($hanani_header_wide) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<div class="header_widgets_inner widget_area_inner">
				<?php 
				if (!$hanani_header_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($hanani_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'hanani_action_before_sidebar' );
				hanani_show_layout($hanani_widgets_output);
				do_action( 'hanani_action_after_sidebar' );
				if ($hanani_need_columns) {
					?></div>	<!-- /.columns_wrap --><?php
				}
				if (!$hanani_header_wide) {
					?></div>	<!-- /.content_wrap --><?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
?>