<?php
/**
 * The template to display the background video in the header
 *
 * @package WordPress
 * @subpackage HANANI
 * @since HANANI 1.0.14
 */
$hanani_header_video = hanani_get_header_video();
$hanani_embed_video = '';
if (!empty($hanani_header_video) && !hanani_is_from_uploads($hanani_header_video)) {
	if (hanani_is_youtube_url($hanani_header_video) && preg_match('/[=\/]([^=\/]*)$/', $hanani_header_video, $matches) && !empty($matches[1])) {
		?><div id="background_video" data-youtube-code="<?php echo esc_attr($matches[1]); ?>"></div><?php
	} else {
		global $wp_embed;
		if (false && is_object($wp_embed)) {
			$hanani_embed_video = do_shortcode($wp_embed->run_shortcode( '[embed]' . trim($hanani_header_video) . '[/embed]' ));
			$hanani_embed_video = hanani_make_video_autoplay($hanani_embed_video);
		} else {
			$hanani_header_video = str_replace('/watch?v=', '/embed/', $hanani_header_video);
			$hanani_header_video = hanani_add_to_url($hanani_header_video, array(
				'feature' => 'oembed',
				'controls' => 0,
				'autoplay' => 1,
				'showinfo' => 0,
				'modestbranding' => 1,
				'wmode' => 'transparent',
				'enablejsapi' => 1,
				'origin' => home_url(),
				'widgetid' => 1
			));
			$hanani_embed_video = '<iframe src="' . esc_url($hanani_header_video) . '" width="1170" height="658" allowfullscreen="0" frameborder="0"></iframe>';
		}
		?><div id="background_video"><?php hanani_show_layout($hanani_embed_video); ?></div><?php
	}
}
?>