<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package WordPress
 * @subpackage HANANI
 * @since HANANI 1.0
 */

// Page (category, tag, archive, author) title

if ( hanani_need_page_title() ) {
	hanani_sc_layouts_showed('title', true);
	hanani_sc_layouts_showed('postmeta', false);
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal scheme_dark">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_left">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_left">
						<?php
						// Post meta on the single post
						if ( is_single() )  {
							?><div class="sc_layouts_title_meta"><?php
								hanani_show_post_meta(apply_filters('hanani_filter_post_meta_args', array(
									'components' => hanani_array_get_keys_by_value(hanani_get_theme_option('meta_parts')),
									'counters' => hanani_array_get_keys_by_value(hanani_get_theme_option('counters')),
									'seo' => hanani_is_on(hanani_get_theme_option('seo_snippets'))
									), 'header', 1)
								);
							?></div><?php
						}
						
						// Blog/Post title
						?><div class="sc_layouts_title_title"><?php
							$hanani_blog_title = hanani_get_blog_title();
							$hanani_blog_title_text = $hanani_blog_title_class = $hanani_blog_title_link = $hanani_blog_title_link_text = '';
							if (is_array($hanani_blog_title)) {
								$hanani_blog_title_text = $hanani_blog_title['text'];
								$hanani_blog_title_class = !empty($hanani_blog_title['class']) ? ' '.$hanani_blog_title['class'] : '';
								$hanani_blog_title_link = !empty($hanani_blog_title['link']) ? $hanani_blog_title['link'] : '';
								$hanani_blog_title_link_text = !empty($hanani_blog_title['link_text']) ? $hanani_blog_title['link_text'] : '';
							} else
								$hanani_blog_title_text = $hanani_blog_title;
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr($hanani_blog_title_class); ?>"><?php
								$hanani_top_icon = hanani_get_category_icon();
								if (!empty($hanani_top_icon)) {
									$hanani_attr = hanani_getimagesize($hanani_top_icon);
									?><img src="<?php echo esc_url($hanani_top_icon); ?>" alt="<?php esc_attr_e('Site icon', 'hanani'); ?>" <?php if (!empty($hanani_attr[3])) hanani_show_layout($hanani_attr[3]);?>><?php
								}
								echo wp_kses_post($hanani_blog_title_text, 'hanani_kses_content');
							?></h1>
							<?php
							if (!empty($hanani_blog_title_link) && !empty($hanani_blog_title_link_text)) {
								?><a href="<?php echo esc_url($hanani_blog_title_link); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html($hanani_blog_title_link_text); ?></a><?php
							}
							
							// Category/Tag description
							if ( is_category() || is_tag() || is_tax() ) 
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
		
						?></div><?php
	
						// Breadcrumbs
						?><div class="sc_layouts_title_breadcrumbs"><?php
							do_action( 'hanani_action_breadcrumbs');
						?></div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>