<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package WordPress
 * @subpackage HANANI
 * @since HANANI 1.0
 */

$hanani_args = get_query_var('hanani_logo_args');

// Site logo
$hanani_logo_type   = isset($hanani_args['type']) ? $hanani_args['type'] : '';
$hanani_logo_image  = hanani_get_logo_image($hanani_logo_type);
$hanani_logo_text   = hanani_is_on(hanani_get_theme_option('logo_text')) ? get_bloginfo( 'name' ) : '';
$hanani_logo_slogan = get_bloginfo( 'description', 'display' );
if (!empty($hanani_logo_image) || !empty($hanani_logo_text)) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url(home_url('/')); ?>"><?php
		if (!empty($hanani_logo_image)) {
			if (empty($hanani_logo_type) && function_exists('the_custom_logo') && is_numeric( $hanani_logo_image ) && (int) $hanani_logo_image > 0 ) {
				the_custom_logo();
			} else {
				$hanani_attr = hanani_getimagesize($hanani_logo_image);
				echo '<img src="'.esc_url($hanani_logo_image).'" alt="'.esc_attr($hanani_logo_text).'"'.(!empty($hanani_attr[3]) ? ' '.wp_kses_data($hanani_attr[3]) : '').'>';
			}
		} else {
			hanani_show_layout(hanani_prepare_macros($hanani_logo_text), '<span class="logo_text">', '</span>');
			hanani_show_layout(hanani_prepare_macros($hanani_logo_slogan), '<span class="logo_slogan">', '</span>');
		}
	?></a><?php
}
?>