<?php
/**
 * The template to display default site header
 *
 * @package WordPress
 * @subpackage HANANI
 * @since HANANI 1.0
 */

$hanani_header_css = '';
$hanani_header_image = get_header_image();
$hanani_header_video = hanani_get_header_video();
if (!empty($hanani_header_image) && hanani_trx_addons_featured_image_override(is_singular() || hanani_storage_isset('blog_archive') || is_category())) {
	$hanani_header_image = hanani_get_current_mode_image($hanani_header_image);
}

?><header class="top_panel top_panel_default<?php
					echo !empty($hanani_header_image) || !empty($hanani_header_video) ? ' with_bg_image' : ' without_bg_image';
					if ($hanani_header_video!='') echo ' with_bg_video';
					if ($hanani_header_image!='') echo ' '.esc_attr(hanani_add_inline_css_class('background-image: url('.esc_url($hanani_header_image).');'));
					if (is_single() && has_post_thumbnail()) echo ' with_featured_image';
					if (hanani_is_on(hanani_get_theme_option('header_fullheight'))) echo ' header_fullheight hanani-full-height';
					if (!hanani_is_inherit(hanani_get_theme_option('header_scheme')))
						echo ' scheme_' . esc_attr(hanani_get_theme_option('header_scheme'));
					?>"><?php

	// Background video
	if (!empty($hanani_header_video)) {
		get_template_part( apply_filters('hanani_filter_get_template_part', 'templates/header-video') );
	}
	
	// Main menu
	if (hanani_get_theme_option("menu_style") == 'top') {
		get_template_part( apply_filters('hanani_filter_get_template_part', 'templates/header-navi') );
	}

	// Mobile header
	if (hanani_is_on(hanani_get_theme_option("header_mobile_enabled"))) {
		get_template_part( apply_filters('hanani_filter_get_template_part', 'templates/header-mobile') );
	}
	
	// Page title and breadcrumbs area
	get_template_part( apply_filters('hanani_filter_get_template_part', 'templates/header-title') );

	// Header widgets area
	get_template_part( apply_filters('hanani_filter_get_template_part', 'templates/header-widgets') );



?></header>