<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package WordPress
 * @subpackage HANANI
 * @since HANANI 1.0.06
 */

$hanani_header_css = '';
$hanani_header_image = get_header_image();
$hanani_header_video = hanani_get_header_video();
if (!empty($hanani_header_image) && hanani_trx_addons_featured_image_override(is_singular() || hanani_storage_isset('blog_archive') || is_category())) {
	$hanani_header_image = hanani_get_current_mode_image($hanani_header_image);
}

$hanani_header_id = str_replace('header-custom-', '', hanani_get_theme_option("header_style"));
if ((int) $hanani_header_id == 0) {
	$hanani_header_id = hanani_get_post_id(array(
												'name' => $hanani_header_id,
												'post_type' => defined('TRX_ADDONS_CPT_LAYOUTS_PT') ? TRX_ADDONS_CPT_LAYOUTS_PT : 'cpt_layouts'
												)
											);
} else {
	$hanani_header_id = apply_filters('hanani_filter_get_translated_layout', $hanani_header_id);
}
$hanani_header_meta = get_post_meta($hanani_header_id, 'trx_addons_options', true);
if (!empty($hanani_header_meta['margin']) != '') 
	hanani_add_inline_css(sprintf('.page_content_wrap{padding-top:%s}', esc_attr(hanani_prepare_css_value($hanani_header_meta['margin']))));

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr($hanani_header_id); 
				?> top_panel_custom_<?php echo esc_attr(sanitize_title(get_the_title($hanani_header_id)));
				echo !empty($hanani_header_image) || !empty($hanani_header_video) 
					? ' with_bg_image' 
					: ' without_bg_image';
				if ($hanani_header_video!='') 
					echo ' with_bg_video';
				if ($hanani_header_image!='') 
					echo ' '.esc_attr(hanani_add_inline_css_class('background-image: url('.esc_url($hanani_header_image).');'));
				if (is_single() && has_post_thumbnail()) 
					echo ' with_featured_image';
				if (hanani_is_on(hanani_get_theme_option('header_fullheight'))) 
					echo ' header_fullheight hanani-full-height';
				if (!hanani_is_inherit(hanani_get_theme_option('header_scheme')))
					echo ' scheme_' . esc_attr(hanani_get_theme_option('header_scheme'));
				?>"><?php

	// Background video
	if (!empty($hanani_header_video)) {
		get_template_part( apply_filters('hanani_filter_get_template_part', 'templates/header-video') );
	}
		
	// Custom header's layout
	do_action('hanani_action_show_layout', $hanani_header_id);

	// Header widgets area
	get_template_part( apply_filters('hanani_filter_get_template_part', 'templates/header-widgets') );
		
?></header>