<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package WordPress
 * @subpackage HANANI
 * @since HANANI 1.0.10
 */

// Footer sidebar
$hanani_footer_name = hanani_get_theme_option('footer_widgets');
$hanani_footer_present = !hanani_is_off($hanani_footer_name) && is_active_sidebar($hanani_footer_name);
if ($hanani_footer_present) { 
	hanani_storage_set('current_sidebar', 'footer');
	$hanani_footer_wide = hanani_get_theme_option('footer_wide');
	ob_start();
	if ( is_active_sidebar($hanani_footer_name) ) {
		dynamic_sidebar($hanani_footer_name);
	}
	$hanani_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($hanani_out)) {
		$hanani_out = preg_replace("/<\\/aside>[\r\n\s]*<aside/", "</aside><aside", $hanani_out);
		$hanani_need_columns = true;	//or check: strpos($hanani_out, 'columns_wrap')===false;
		if ($hanani_need_columns) {
			$hanani_columns = max(0, (int) hanani_get_theme_option('footer_columns'));
			if ($hanani_columns == 0) $hanani_columns = min(4, max(1, substr_count($hanani_out, '<aside ')));
			if ($hanani_columns > 1)
				$hanani_out = preg_replace("/<aside([^>]*)class=\"widget/", "<aside$1class=\"column-1_".esc_attr($hanani_columns).' widget', $hanani_out);
			else
				$hanani_need_columns = false;
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo !empty($hanani_footer_wide) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<div class="footer_widgets_inner widget_area_inner">
				<?php 
				if (!$hanani_footer_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($hanani_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'hanani_action_before_sidebar' );
				hanani_show_layout($hanani_out);
				do_action( 'hanani_action_after_sidebar' );
				if ($hanani_need_columns) {
					?></div><!-- /.columns_wrap --><?php
				}
				if (!$hanani_footer_wide) {
					?></div><!-- /.content_wrap --><?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
?>