<?php
/**
 * The template to display the site logo in the footer
 *
 * @package WordPress
 * @subpackage HANANI
 * @since HANANI 1.0.10
 */

// Logo
if (hanani_is_on(hanani_get_theme_option('logo_in_footer'))) {
	$hanani_logo_image = hanani_get_logo_image('footer');
	$hanani_logo_text  = get_bloginfo( 'name' );
	if (!empty($hanani_logo_image) || !empty($hanani_logo_text)) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if (!empty($hanani_logo_image)) {
					$hanani_attr = hanani_getimagesize($hanani_logo_image);
					echo '<a href="'.esc_url(home_url('/')).'">'
							. '<img src="'.esc_url($hanani_logo_image).'"'
								. ' class="logo_footer_image"'
								. ' alt="'.esc_attr__('Site logo', 'hanani').'"'
								. (!empty($hanani_attr[3]) ? ' ' . wp_kses_data($hanani_attr[3]) : '')
							.'>'
						. '</a>' ;
				} else if (!empty($hanani_logo_text)) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="'.esc_url(home_url('/')).'">'
								. esc_html($hanani_logo_text)
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
?>