<?php
/**
 * The template to display default site footer
 *
 * @package WordPress
 * @subpackage HANANI
 * @since HANANI 1.0.10
 */

$hanani_footer_id = str_replace('footer-custom-', '', hanani_get_theme_option("footer_style"));
if ((int) $hanani_footer_id == 0) {
	$hanani_footer_id = hanani_get_post_id(array(
												'name' => $hanani_footer_id,
												'post_type' => defined('TRX_ADDONS_CPT_LAYOUTS_PT') ? TRX_ADDONS_CPT_LAYOUTS_PT : 'cpt_layouts'
												)
											);
} else {
	$hanani_footer_id = apply_filters('hanani_filter_get_translated_layout', $hanani_footer_id);
}
$hanani_footer_meta = get_post_meta($hanani_footer_id, 'trx_addons_options', true);
if (!empty($hanani_footer_meta['margin']) != '') 
	hanani_add_inline_css(sprintf('.page_content_wrap{padding-bottom:%s}', esc_attr(hanani_prepare_css_value($hanani_footer_meta['margin']))));
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr($hanani_footer_id); 
						?> footer_custom_<?php echo esc_attr(sanitize_title(get_the_title($hanani_footer_id))); 
						if (!hanani_is_inherit(hanani_get_theme_option('footer_scheme')))
							echo ' scheme_' . esc_attr(hanani_get_theme_option('footer_scheme'));
						?>">
	<?php
    // Custom footer's layout
    do_action('hanani_action_show_layout', $hanani_footer_id);
	?>
</footer><!-- /.footer_wrap -->
