<?php
/**
 * The template to display the Author bio
 *
 * @package WordPress
 * @subpackage HANANI
 * @since HANANI 1.0
 */
?>

<div class="author_info scheme_default author vcard" itemprop="author" itemscope itemtype="//schema.org/Person">

	<div class="author_avatar" itemprop="image">
		<?php 
		$hanani_mult = hanani_get_retina_multiplier();
		echo get_avatar( get_the_author_meta( 'user_email' ), 120*$hanani_mult ); 
		?>
	</div><!-- .author_avatar -->

	<div class="author_description">
		<h6 class="author_title" itemprop="name">
			<span class="about_author"><?php esc_html_e('About Author', 'hanani');?></span>
			<a class="author_link" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author">
				<?php echo '<span class="fn">'.get_the_author().'</span>';?>
			</a>
		</h6>

		<div class="author_bio" itemprop="description">
			<?php echo wp_kses(wpautop(get_the_author_meta( 'description' )), 'hanani_kses_content'); ?>
			<?php do_action('hanani_action_user_meta'); ?>
		</div><!-- .author_bio -->

	</div><!-- .author_description -->

</div><!-- .author_info -->
