<?php
/**
 * The template to display Admin notices
 *
 * @package WordPress
 * @subpackage HANANI
 * @since HANANI 1.0.1
 */
 
$hanani_theme_obj = wp_get_theme();

?>
<div class="hanani_admin_notice hanani_rate_notice update-nag"><?php
	// Theme image
	if ( ($hanani_theme_img = hanani_get_file_url('screenshot.jpg')) != '') {
		?><div class="hanani_notice_image"><img src="<?php echo esc_url($hanani_theme_img); ?>" alt="<?php esc_attr_e('Theme screenshot', 'hanani'); ?>"></div><?php
	}

	// Title
	?><h3 class="hanani_notice_title"><a href="<?php echo esc_url(hanani_storage_get('theme_download_url')); ?>" target="_blank"><?php
		// Translators: Add theme name and version to the 'Welcome' message
		echo esc_html(sprintf(__('Rate our theme "%s", please', 'hanani'),
				$hanani_theme_obj->name . (HANANI_THEME_FREE ? ' ' . __('Free', 'hanani') : '')
				));
	?></a></h3><?php
	
	// Description
	?><div class="hanani_notice_text">
		<p><?php echo wp_kses_data(__('We are glad you chose our WP theme for your website. You’ve done well customizing your website and we hope that you’ve enjoyed working with our theme.', 'hanani')); ?></p>
		<p><?php echo wp_kses_data(__('It would be just awesome if you spend just a minute of your time to rate our theme or the customer service you’ve received from us.', 'hanani')); ?></p>
		<p class="hanani_notice_text_info"><?php echo wp_kses_data(__('* We love receiving 5-star ratings, because our CEO Henry Rise gives $5 to homeless dog shelter for every 5-star rating we get! Save the planet with us!', 'hanani')); ?></p>
	</div><?php

	// Buttons
	?><div class="hanani_notice_buttons"><?php
		// Link to the theme download page
		?><a href="<?php echo esc_url(hanani_storage_get('theme_download_url')); ?>" class="button button-primary" target="_blank"><i class="dashicons dashicons-star-filled"></i> <?php
			// Translators: Add theme name
			echo esc_html(sprintf(__('Rate theme %s', 'hanani'), $hanani_theme_obj->name));
		?></a><?php
		// Link to the theme support
		?><a href="<?php echo esc_url(hanani_storage_get('theme_support_url')); ?>" class="button" target="_blank"><i class="dashicons dashicons-sos"></i> <?php
			esc_html_e('Support', 'hanani');
		?></a><?php
		// Link to the theme documentation
		?><a href="<?php echo esc_url(hanani_storage_get('theme_doc_url')); ?>" class="button" target="_blank"><i class="dashicons dashicons-book"></i> <?php
			esc_html_e('Documentation', 'hanani');
		?></a><?php
		// Dismiss
		?><a href="#" class="hanani_hide_notice"><i class="dashicons dashicons-dismiss"></i> <span class="hanani_hide_notice_text"><?php esc_html_e('Dismiss', 'hanani'); ?></span></a>
	</div>
</div>