<?php
/**
 * The template to display Admin notices
 *
 * @package WordPress
 * @subpackage HANANI
 * @since HANANI 1.0.1
 */
 
$hanani_theme_obj = wp_get_theme();
?>
<div class="hanani_admin_notice hanani_welcome_notice update-nag"><?php
	// Theme image
	if ( ($hanani_theme_img = hanani_get_file_url('screenshot.jpg')) != '') {
		?><div class="hanani_notice_image"><img src="<?php echo esc_url($hanani_theme_img); ?>" alt="<?php esc_attr_e('Theme screenshot', 'hanani'); ?>"></div><?php
	}

	// Title
	?><h3 class="hanani_notice_title"><?php
		// Translators: Add theme name and version to the 'Welcome' message
		echo esc_html(sprintf(__('Welcome to %1$s v.%2$s', 'hanani'),
				$hanani_theme_obj->name . (HANANI_THEME_FREE ? ' ' . __('Free', 'hanani') : ''),
				$hanani_theme_obj->version
				));
	?></h3><?php

	// Description
	?><div class="hanani_notice_text"><?php
		echo str_replace('. ', '.<br>', wp_kses_data($hanani_theme_obj->description));
		if (!hanani_exists_trx_addons()) {
			echo (!empty($hanani_theme_obj->description) ? '<br><br>' : '')
					. wp_kses_data(__('Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'hanani'));
		}
	?></div><?php

	// Buttons
	?><div class="hanani_notice_buttons"><?php
		// Link to the page 'About Theme'
		?><a href="<?php echo esc_url(admin_url().'themes.php?page=hanani_about'); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> <?php
			// Translators: Add theme name
			echo esc_html(sprintf(__('About %s', 'hanani'), $hanani_theme_obj->name));
		?></a><?php
		// Link to the page 'Install plugins'
		if (hanani_get_value_gp('page')!='tgmpa-install-plugins') {
			?>
			<a href="<?php echo esc_url(admin_url().'themes.php?page=tgmpa-install-plugins'); ?>" class="button button-primary"><i class="dashicons dashicons-admin-plugins"></i> <?php esc_html_e('Install plugins', 'hanani'); ?></a>
			<?php
		}
		// Link to the 'One-click demo import'
		if (function_exists('hanani_exists_ocdi') && hanani_exists_ocdi()) {
			?>
			<a href="<?php echo esc_url(admin_url().'themes.php?page=pt-one-click-demo-import'); ?>" class="button button-primary"><i class="dashicons dashicons-download"></i> <?php esc_html_e('One Click Demo Import', 'hanani'); ?></a>
			<?php
		} else if (!hanani_storage_isset('required_plugins', 'one-click-demo-import') && function_exists('hanani_exists_trx_addons') && hanani_exists_trx_addons() && class_exists('trx_addons_demo_data_importer')) {
			?>
			<a href="<?php echo esc_url(admin_url().'themes.php?page=trx_importer'); ?>" class="button button-primary"><i class="dashicons dashicons-download"></i> <?php esc_html_e('One Click Demo Import', 'hanani'); ?></a>
			<?php
		}
		// Link to the Customizer
		?><a href="<?php echo esc_url(admin_url().'customize.php'); ?>" class="button"><i class="dashicons dashicons-admin-appearance"></i> <?php esc_html_e('Theme Customizer', 'hanani'); ?></a><?php
		// Link to the Theme Options
		if (!HANANI_THEME_FREE) {
			?><span> <?php esc_html_e('or', 'hanani'); ?> </span>
        	<a href="<?php echo esc_url(admin_url().'themes.php?page=theme_options'); ?>" class="button"><i class="dashicons dashicons-admin-appearance"></i> <?php esc_html_e('Theme Options', 'hanani'); ?></a><?php
        }
        // Dismiss this notice
        ?><a href="#" class="hanani_hide_notice"><i class="dashicons dashicons-dismiss"></i> <span class="hanani_hide_notice_text"><?php esc_html_e('Dismiss', 'hanani'); ?></span></a>
	</div>
</div>