<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage HANANI
 * @since HANANI 1.0
 */

if (hanani_sidebar_present()) {
	ob_start();
	$hanani_sidebar_name = hanani_get_theme_option('sidebar_widgets');
	hanani_storage_set('current_sidebar', 'sidebar');
	if ( is_active_sidebar($hanani_sidebar_name) ) {
		dynamic_sidebar($hanani_sidebar_name);
	}
	$hanani_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($hanani_out)) {
		$hanani_sidebar_position = hanani_get_theme_option('sidebar_position');
		?>
		<div class="sidebar <?php echo esc_attr($hanani_sidebar_position); ?> widget_area<?php if (!hanani_is_inherit(hanani_get_theme_option('sidebar_scheme'))) echo ' scheme_'.esc_attr(hanani_get_theme_option('sidebar_scheme')); ?>" role="complementary">
			<div class="sidebar_inner">
				<?php
				do_action( 'hanani_action_before_sidebar' );
				hanani_show_layout(preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $hanani_out));
				do_action( 'hanani_action_after_sidebar' );
				?>
			</div><!-- /.sidebar_inner -->
		</div><!-- /.sidebar -->
		<?php
	}
}
?>