<?php
/* Revolution Slider support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('hanani_trx_updater_theme_setup9')) {
	add_action( 'after_setup_theme', 'hanani_trx_updater_theme_setup9', 9 );
	function hanani_trx_updater_theme_setup9() {
		if (is_admin()) {
			add_filter( 'hanani_filter_tgmpa_required_plugins','hanani_trx_updater_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'hanani_trx_updater_tgmpa_required_plugins' ) ) {
	
	function hanani_trx_updater_tgmpa_required_plugins($list=array()) {
		if (hanani_storage_isset('required_plugins', 'trx_updater')) {
			$path = hanani_get_file_dir('plugins/trx_updater/trx_updater.zip');
			if (!empty($path)) {
				$list[] = array(
					'name' 		=> hanani_storage_get_array('required_plugins', 'trx_updater'),
					'slug' 		=> 'trx_updater',
					'source'	=> $path,
					'required' 	=> false,
					'version' 	=> '2.1.8'
				);
			}
		}
		return $list;
	}
}
?>