<?php
// Add plugin-specific colors and fonts to the custom CSS
if ( !function_exists( 'hanani_tribe_events_get_css' ) ) {
	add_filter( 'hanani_filter_get_css', 'hanani_tribe_events_get_css', 10, 2 );
	function hanani_tribe_events_get_css($css, $args) {
		if (isset($css['fonts']) && isset($args['fonts'])) {
			$fonts = $args['fonts'];
			$css['fonts'] .= <<<CSS
			
.tribe-events-list .tribe-events-list-event-title {
	{$fonts['h3_font-family']}
}

#tribe-events .tribe-events-button,
.tribe-events-button,
.tribe-events-cal-links a,
.tribe-events-sub-nav li a {
	{$fonts['button_font-family']}
	{$fonts['button_font-size']}
	{$fonts['button_font-weight']}
	{$fonts['button_font-style']}
	{$fonts['button_line-height']}
	{$fonts['button_text-decoration']}
	{$fonts['button_text-transform']}
	{$fonts['button_letter-spacing']}
}
#tribe-bar-form button, #tribe-bar-form a,
.tribe-events-read-more {
	{$fonts['button_font-family']}
	{$fonts['button_letter-spacing']}
}
.tribe-events-list .tribe-events-list-separator-month,
.tribe-events-calendar thead th,
.tribe-events-schedule, .tribe-events-schedule h2,
.tribe-events-calendar td div[id*="tribe-events-daynum-"],
#tribe-bar-views .tribe-bar-views-list .tribe-bar-views-option {
	{$fonts['h5_font-family']}
}
.single-tribe_events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list-item,
.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list-item,
.tribe-common--breakpoint-medium.tribe-common .tribe-common-form-control-text__input, .tribe-common .tribe-common-form-control-text__input,
.tribe-events .datepicker .month, .tribe-events .datepicker .year,
#tribe-bar-form input, #tribe-events-content.tribe-events-month,
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title,
#tribe-mobile-container .type-tribe_events,
.tribe-events .tribe-events-calendar-day__time-separator-text,
.tribe-events-list-widget ol li .tribe-event-title {
	{$fonts['p_font-family']}
}
.tribe-common .tribe-common-c-btn-border-small, .tribe-common a.tribe-common-c-btn-border-small,
.tribe-common .tribe-events-c-top-bar__datepicker-button,
.tribe-common .tribe-common-b2, .tribe-common .tribe-common-b3,
.tribe-common .tribe-common-b5,
.tribe-common.tribe-events .datepicker .datepicker-switch,
.tribe-common .tribe-events-calendar-month__calendar-event-tooltip-datetime,
.tribe-common.tribe-events .datepicker .day, .tribe-common.tribe-events .datepicker .dow,
.tribe-common.tribe-events .tribe-events-calendar-list__event-date-tag-weekday,
.tribe-common.tribe-events .tribe-common-h8,
.tribe-common.tribe-events .tribe-events-c-view-selector__list-item-text,
.tribe-common.tribe-events .tribe-events-calendar-month__day-date{
	{$fonts['p_font-family']}
}

.tribe-common .tribe-events-calendar-list__month-separator-text,
.tribe-common .tribe-events-calendar-day__type-separator-text{
	{$fonts['h6_font-family']}
}

.tribe-common .tribe-events-calendar-list__event-title-link,
.tribe-common .tribe-events-calendar-day__event-title-link,
.tribe-common .tribe-events-calendar-month-mobile-events__mobile-event-title-link,
.tribe-common .tribe-events-calendar-month__calendar-event-tooltip-title,
.tribe-common.tribe-events .tribe-events-c-day-marker__date,
.tribe-common.tribe-events .tribe-events-calendar-month-mobile-events__mobile-event-datetime{
	{$fonts['h3_font-family']}
}

.tribe-common .tribe-common-c-btn, .tribe-common a.tribe-common-c-btn,
.tribe-common.tribe-events .tribe-common-h5,
.tribe-common.tribe-events .tribe-events-c-ical__link,
.tribe-common.tribe-events .tribe-events-c-nav__prev,
.tribe-common.tribe-events .tribe-events-c-nav__next{
	{$fonts['h5_font-family']}
}

.tribe-common.tribe-events .tribe-events-c-search__button,
.tribe-common.tribe-events .tribe-events-c-nav__prev,
.tribe-common.tribe-events .tribe-events-c-nav__next,
.tribe-common.tribe-events .tribe-events-c-ical__link{
	{$fonts['h6_font-family']}
}

CSS;
		}
			
		if (isset($css['vars']) && isset($args['vars'])) {
			$vars = $args['vars'];
			$css['vars'] .= <<<CSS

CSS;
		}


		if (isset($css['colors']) && isset($args['colors'])) {
			$colors = $args['colors'];
			$css['colors'] .= <<<CSS


/* Events Page */
		
.tribe-common a,
.tribe-common a:visited{
	color: {$colors['text_link']};
}

.tribe-common a:active,
.tribe-common a:focus,
.tribe-common a:hover{
	color: {$colors['text_hover']};
}
			
/* Filters bar */
#tribe-bar-form {
	color: {$colors['text_dark']};
}
#tribe-bar-form input[type="text"] {
	color: {$colors['text_dark']};
	border-color: {$colors['text_dark']};
}
.tribe-bar-views-list {
	background-color: {$colors['text_link']};
}

.datepicker thead tr:first-child th:hover, .datepicker tfoot tr th:hover {
	color: {$colors['text_link']};
	background: {$colors['text_dark']};
}

.datepicker tfoot tr th:hover {
	background: {$colors['text_link']};
}

.datepicker table tr td span.active.active {
	color: {$colors['inverse_text']};
	background: {$colors['text_dark']};
	text-shadow: none;
}

.tribe-events .datepicker .day.focused, .tribe-events .datepicker .day:focus, .tribe-events .datepicker .day:hover, .tribe-events .datepicker .month.focused, .tribe-events .datepicker .month:focus, .tribe-events .datepicker .month:hover, .tribe-events .datepicker .year.focused, .tribe-events .datepicker .year:focus, .tribe-events .datepicker .year:hover,
.datepicker table tr td span.focused, 
.datepicker table tr td span:hover {
	color: {$colors['inverse_text']};
	background: {$colors['text_hover']};
}

#tribe-bar-views #tribe-bar-views-toggle {
	color: {$colors['inverse_text']};
	background: {$colors['text_link']};
}
#tribe-bar-views #tribe-bar-views-toggle:hover {
	background: {$colors['text_hover']};
}

#tribe-bar-views .tribe-bar-views-list{
	background: {$colors['text_hover']};
}
#tribe-bar-views .tribe-bar-views-list .tribe-bar-views-option {
	color: {$colors['inverse_text']};
}
#tribe-bar-views .tribe-bar-views-option:hover,
#tribe-bar-views .tribe-bar-views-option.tribe-bar-active {
	background: {$colors['text_link']};
}

#tribe-events-bar #tribe-bar-collapse-toggle {
	color: {$colors['inverse_text']};
	background: {$colors['text_hover']};
}

#tribe-events-bar #tribe-bar-collapse-toggle:hover {
	background: {$colors['text_link']};
} 

/* Content */
.tribe-events-calendar thead th {
	color: {$colors['text_hover']};
	background: {$colors['bd_color']} !important;
	border-color: {$colors['bd_color']} !important;
}
#tribe-events-content .tribe-events-calendar td {
	border-color: {$colors['bd_color']} !important;
}
.tribe-events-calendar td div[id*="tribe-events-daynum-"],
.tribe-events-calendar td div[id*="tribe-events-daynum-"] > a {
	color: {$colors['text_dark']};
}
.tribe-events-calendar td.tribe-events-othermonth {
	color: {$colors['alter_light']};
	background: {$colors['alter_bg_color']} !important;
}
.tribe-events-calendar td.tribe-events-othermonth div[id*="tribe-events-daynum-"],
.tribe-events-calendar td.tribe-events-othermonth div[id*="tribe-events-daynum-"] > a {
	color: {$colors['alter_light']};
}
.tribe-events-calendar td.tribe-events-past div[id*="tribe-events-daynum-"], .tribe-events-calendar td.tribe-events-past div[id*="tribe-events-daynum-"] > a {
	color: {$colors['text_light']};
}
.tribe-events-calendar td.tribe-events-present{
	background-color: transparent;
}
.tribe-events-calendar td.tribe-events-present div[id*="tribe-events-daynum-"],
.tribe-events-calendar td.tribe-events-present div[id*="tribe-events-daynum-"] > a{
	color: {$colors['text_link']};
}
.tribe-events-calendar td.tribe-events-present:before {
	border-color: transparent;
}
.tribe-events-calendar td.tribe-events-present:hover {
	background-color: transparent;
}
.tribe-events-calendar td.tribe-events-present:hover div[id*="tribe-events-daynum-"],
.tribe-events-calendar td.tribe-events-present:hover div[id*="tribe-events-daynum-"] > a {
		color: {$colors['text_hover']};
}
#tribe-events-content .tribe-events-calendar .tribe-events-present div[id*="tribe-events-event-"] h3.tribe-events-month-event-title a {
	color: {$colors['inverse_link']};
}
#tribe-events-content .tribe-events-calendar .tribe-events-present div[id*="tribe-events-event-"]:hover h3.tribe-events-month-event-title a {
	color: {$colors['text_link']};
}
#tribe-events-content .tribe-events-calendar .tribe-events-present div[id*="tribe-events-event-"]:hover h3.tribe-events-month-event-title a:hover {
	color: {$colors['text_hover']};
}
.tribe-events-calendar .tribe-events-has-events div[id*="tribe-events-daynum-"] {
	color: {$colors['text_hover']};
}
.tribe-events-calendar .tribe-events-has-events:after {
	background-color: {$colors['text_link']};
}
.tribe-events-calendar .mobile-active.tribe-events-has-events:after {
	background-color: {$colors['text_hover']};
}
#tribe-events-content .tribe-events-calendar td,
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title a {
	color: {$colors['text_dark']};
}
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title a:hover {
	color: {$colors['text_link']};
}
#tribe-events-content .tribe-events-calendar td.mobile-active,
#tribe-events-content .tribe-events-calendar td.mobile-active:hover {
	color: {$colors['text_link']};
	background-color: transparent;
}
#tribe-events-content .tribe-events-calendar td.mobile-active div[id*="tribe-events-daynum-"] {
	color: {$colors['text_link']};
	background-color: {$colors['text_dark']};
}
#tribe-events-content .tribe-events-calendar td.tribe-events-othermonth.mobile-active div[id*="tribe-events-daynum-"] a,
.tribe-events-calendar .mobile-active div[id*="tribe-events-daynum-"] a {
	background-color: transparent;
	color: {$colors['text_hover']};
}
.tribe-events-calendar td.tribe-events-othermonth.tribe-events-future div[id*="tribe-events-daynum-"] {
	background-color: transparent;
}
.tribe-events-read-more {
	color: {$colors['text_link']};
	border-color: {$colors['text_link']};
}
.tribe-events-read-more:hover {
	color: {$colors['text_link']};
	border-color: transparent;
}

/* Tooltip */
.recurring-info-tooltip,
.tribe-events-calendar .tribe-events-tooltip,
.tribe-events-week .tribe-events-tooltip,
.tribe-events-tooltip .tribe-events-arrow {
	color: {$colors['alter_text']};
	background: {$colors['bg_color']};
}
#tribe-events-content .tribe-events-tooltip h3 { 
	color: {$colors['text_link']};
	background: {$colors['text_dark']};
}
.tribe-events-tooltip .tribe-event-duration {
	color: {$colors['text_hover']};
}

/* Events list */
.tribe-events-list-separator-month {
	color: {$colors['text_dark']};
}
.tribe-events-list-separator-month:after {
	border-color: {$colors['bd_color']};
}
.tribe-events-list .type-tribe_events + .type-tribe_events,
.tribe-events-day .tribe-events-day-time-slot + .tribe-events-day-time-slot + .tribe-events-day-time-slot {
	border-color: {$colors['bd_color']};
}
.tribe-events-list .tribe-events-event-cost span {
	color: {$colors['bg_color']};
	border-color: {$colors['text_dark']};
	background: {$colors['text_dark']};
}
.tribe-mobile .tribe-events-loop .tribe-events-event-meta {
	color: {$colors['alter_text']};
	border-color: {$colors['alter_bd_color']};
	background-color: {$colors['alter_bg_color']};
}
.tribe-mobile .tribe-events-loop .tribe-events-event-meta a {
	color: {$colors['alter_link']};
}
.tribe-mobile .tribe-events-loop .tribe-events-event-meta a:hover {
	color: {$colors['alter_hover']};
}
.tribe-mobile .tribe-events-list .tribe-events-venue-details {
	border-color: {$colors['alter_bd_color']};
}

/* Events day */
.tribe-events-day .tribe-events-day-time-slot h5 {
	color: {$colors['bg_color']};
	background: {$colors['text_dark']};
}

/* Single Event */
.single-tribe_events .tribe-events-venue-map {
	color: {$colors['alter_text']};
	border-color: {$colors['alter_bd_hover']};
	background: {$colors['alter_bg_hover']};
}
.single-tribe_events .tribe-events-schedule .tribe-events-cost {
	color: {$colors['text_dark']};
}
.single-tribe_events .type-tribe_events {
	border-color: {$colors['bd_color']};
}

.tribe-common .tribe-common-c-loader__dot circle{
	fill: {$colors['text_link']};
}

.tribe-common.tribe-events .tribe-events-calendar-month__multiday-event-bar-inner,
.tribe-common.tribe-events .datepicker .day.current,
.tribe-common.tribe-events .datepicker .month.current,
.tribe-common.tribe-events .tribe-events-c-events-bar__search-button:before,
.tribe-common.tribe-events .tribe-events-c-view-selector__button:before,
.tribe-common.tribe-events .tribe-events-calendar-month__mobile-events-icon--event{
	background-color: {$colors['text_hover']};
}

.tribe-events .datepicker .day.active,
.tribe-events .datepicker .day.active.focused,
.tribe-events .datepicker .day.active:focus,
.tribe-events .datepicker .day.active:hover,
.tribe-events .datepicker .month.active,
.tribe-events .datepicker .month.active.focused,
.tribe-events .datepicker .month.active:focus,
.tribe-events .datepicker .month.active:hover,
.tribe-events .datepicker .year.active,
.tribe-events .datepicker .year.active.focused,
.tribe-events .datepicker .year.active:focus,
.tribe-events .datepicker .year.active:hover,
.tribe-common.tribe-events .datepicker .day:hover,
.tribe-common.tribe-events .datepicker .day.active,
.tribe-common.tribe-events .datepicker .month:hover,
.tribe-common.tribe-events .datepicker .month.focused,
.tribe-common.tribe-events .datepicker .year:hover,
.tribe-common.tribe-events .datepicker .year.focused {
    background-color: {$colors['text_link']};
    color: {$colors['inverse_link']};
}

.tribe-common.tribe-events .tribe-events-calendar-month__day--current .tribe-events-calendar-month__day-date,
.tribe-common.tribe-events .tribe-events-calendar-month__day--current .tribe-events-calendar-month__day-date time,
.tribe-common.tribe-events .tribe-events-calendar-month__day--current .tribe-events-calendar-month__day-date-link {
	color: {$colors['text_link']};
}

.tribe-common--breakpoint-medium.tribe-common .tribe-common-form-control-text__input{
	border-color: {$colors['bd_color']};
}

.tribe-common.tribe-events .tribe-events-c-search__button{
	background-color: {$colors['text_link']};
	border-color: {$colors['text_link']};
}

.tribe-common.tribe-events .tribe-events-c-search__button:hover{
	background-color: {$colors['text_hover']};
}

.tribe-common.tribe-events .tribe-events-c-top-bar__datepicker .tribe-events-c-top-bar__datepicker-button{
	background-color: {$colors['text_link']};
	color: {$colors['inverse_text']};
}

.tribe-common.tribe-events .tribe-events-c-nav__prev,
.tribe-common.tribe-events .tribe-events-c-nav__next,
.tribe-common.tribe-events .tribe-events-c-ical .tribe-events-c-ical__link{
	background-color: {$colors['text_link']};
	border-color: {$colors['text_link']};
	color: {$colors['inverse_text']};
}

.tribe-common.tribe-events .tribe-events-c-nav__prev:hover, .tribe-common.tribe-events .tribe-events-c-nav__next:hover,
.tribe-common.tribe-events .tribe-events-c-ical .tribe-events-c-ical__link:hover{
	background-color: {$colors['text_hover']};
	border-color: {$colors['text_hover']};
}

.tribe-common.tribe-events .tribe-events-calendar-month__multiday-event .tribe-common-h8{
	color: {$colors['inverse_text']};
}

.tribe-common.tribe-events .tribe-events-c-events-bar__search-filters-container .tribe-events-c-search__input-group{
	background-color: {$colors['inverse_text']};
}

.tribe-events .tribe-events-calendar-month__day-cell--selected .tribe-events-calendar-month__day-date{
	color: {$colors['text_link']};
}

.tribe-events .datepicker .day.past,
.tribe-events .datepicker .month.past,
.tribe-events .datepicker .year.past {
	color: {$colors['text_light']};
}
.tooltipster-base .tooltipster-content .tribe-events-calendar-month__calendar-event-tooltip-description,
.tribe-common .tribe-events-calendar-list__event-wrapper .tribe-events-calendar-list__event-description,
.tribe-common .tribe-common-c-btn-border-small, .tribe-common a.tribe-common-c-btn-border-small,
.tribe-events .tribe-events-calendar-list__event-date-tag-weekday,
.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-datetime,
.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-description,
.tribe-events .tribe-events-calendar-day__event-details address,
.tribe-events .tribe-events-calendar-day__event-datetime,
.tribe-events .tribe-events-calendar-list__event-details address,
.tribe-events .tribe-events-calendar-list__event-datetime{
	color: {$colors['text']};
}

.tribe-events a.tribe-events-c-view-selector__list-item-link:visited,
.tribe-events a.tribe-events-c-view-selector__list-item-link,
.tribe-events-meta-group .tribe-events-single-section-title,
.tribe-events .tribe-events-calendar-month__day-date-daynum,
.tribe-events .tribe-events-c-search__input-control-icon-svg,
.tribe-common .tribe-common-b3,
.tribe-common .tribe-common-h5, .tribe-common .tribe-common-h7,
.tribe-events a.tribe-events-calendar-month__calendar-event-tooltip-title-link:active,
.tribe-events .tribe-events-calendar-month__calendar-event-title-link, 
.tribe-events a.tribe-events-calendar-month__calendar-event-tooltip-title-link,
.tribe-events a.tribe-events-calendar-day__event-title-link,
.tribe-events a.tribe-events-calendar-day__event-title-link:active,
.tribe-events a.tribe-events-calendar-list__event-title-link:active,
.tribe-events a.tribe-events-calendar-list__event-title-link{
	color: {$colors['text_dark']};
}

.tribe-events .datepicker .day, .tribe-events .datepicker .dow,
.tribe-events .datepicker .datepicker-switch,
.tribe-events .datepicker .month, .tribe-events .datepicker .year {
	color: {$colors['extra_link2']};
}

.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-top-bar__today-button.tribe-common-c-btn-border-small:hover,
.tribe-events a.tribe-events-c-view-selector__list-item-link:focus,
.tribe-events a.tribe-events-c-view-selector__list-item-link:hover,
.tribe-events .tribe-events-calendar-month__calendar-event-title-link:active,
.tribe-events .tribe-events-calendar-month__calendar-event-title-link:focus,
.tribe-events .tribe-events-calendar-month__calendar-event-title-link:hover,
.tribe-events a.tribe-events-calendar-month__calendar-event-tooltip-title-link:focus,
.tribe-events a.tribe-events-calendar-month__calendar-event-tooltip-title-link:hover,
.tribe-events a.tribe-events-calendar-day__event-title-link:focus,
.tribe-events a.tribe-events-calendar-day__event-title-link:hover,
.tribe-events a.tribe-events-calendar-list__event-title-link:focus, 
.tribe-events a.tribe-events-calendar-list__event-title-link:hover{
	color: {$colors['text_link']};
}

.tribe-events-single .tribe-events-sub-nav .tribe-events-nav-next a, 
.tribe-events-single .tribe-events-sub-nav .tribe-events-nav-previous a {
	color: {$colors['inverse_link']};
}

.tribe-common.tribe-events .tribe-events-c-top-bar__datepicker-button .tribe-common-c-svgicon__svg-fill{
	fill: {$colors['inverse_link']};
}
.tribe-common .tribe-common-c-svgicon__svg-fill,
.tribe-events .tribe-events-c-events-bar__search-button-icon-svg path,
.tribe-events .datepicker .next .tribe-events-c-top-bar__datepicker-nav-icon-svg path,
.tribe-events .datepicker .prev .tribe-events-c-top-bar__datepicker-nav-icon-svg path {
	fill: {$colors['extra_link2']};
}

.tribe-events .datepicker .next:active .tribe-events-c-top-bar__datepicker-nav-icon-svg path,
.tribe-events .datepicker .next:focus .tribe-events-c-top-bar__datepicker-nav-icon-svg path,
.tribe-events .datepicker .next:hover .tribe-events-c-top-bar__datepicker-nav-icon-svg path,
.tribe-events .datepicker .prev:active .tribe-events-c-top-bar__datepicker-nav-icon-svg path,
.tribe-events .datepicker .prev:focus .tribe-events-c-top-bar__datepicker-nav-icon-svg path,
.tribe-events .datepicker .prev:hover .tribe-events-c-top-bar__datepicker-nav-icon-svg path {
	fill: {$colors['text_link']};
}
.tribe-common .tribe-common-c-btn-border-small, .tribe-common a.tribe-common-c-btn-border-small,
.tribe-events .tribe-events-c-events-bar .tribe-common-form-control-text__input {
	border-color: {$colors['bd_color']};
}
.tribe-common .tribe-common-c-btn-icon--caret-left:disabled .tribe-common-c-btn-icon__icon-svg path,
.tribe-common .tribe-common-c-btn-icon--caret-right:disabled .tribe-common-c-btn-icon__icon-svg path {
	fill: {$colors['text_light']};
}
.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list-item:hover {
	background-color: {$colors['alter_bg_color']};
}
.tribe-common .tribe-common-c-svgicon--messages-not-found path {
	stroke: {$colors['text_light']};
}

.tribe-common.tribe-events .tribe-events-c-view-selector--tabs .tribe-events-c-view-selector__list-item--active .tribe-events-c-view-selector__list-item-link:after{
    background-color: {$colors['text_dark']};
}

.tribe-events .tribe-events-c-events-bar__search-container,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-header--has-event-search .tribe-events-c-events-bar,
.tribe-events .tribe-events-c-view-selector--tabs .tribe-events-c-view-selector__content {
	background-color: transparent;
}

.tribe-common--breakpoint-medium.tribe-common .tribe-common-c-btn-border-small,
.tribe-common--breakpoint-medium.tribe-common a.tribe-common-c-btn-border-small,
.tribe-common.tribe-events .datepicker .next,
.tribe-common.tribe-events .datepicker .prev,
.tribe-common.tribe-events .datepicker .datepicker-months .datepicker-switch,
.tribe-common.tribe-events .datepicker .datepicker-switch,
.tribe-common.tribe-events .datepicker .day,
.tribe-common.tribe-events .datepicker .dow {
	color: {$colors['extra_link2']};
}

.tribe-events .tribe-events-c-messages__message{
	background-color: {$colors['alter_bg_color']};
}

.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list{
	background-color: {$colors['bg_color']};
}

.tribe-events .tribe-events-calendar-day__time-separator::after,
.tribe-events .tribe-events-calendar-list__month-separator::after{
	background-color: {$colors['bd_color']};
}

.single-tribe_events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list,
.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-top-bar__today-button.tribe-common-c-btn-border-small,
.tribe-events .tribe-events-c-events-bar__search-container, 
.tribe-events .tribe-events-c-view-selector__content, 
.tribe-common.tooltipster-base.tribe-events-tooltip-theme,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-month__day,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-month__week,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-month__week:first-child .tribe-events-calendar-month__day,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-events-bar--border{
	border-color: {$colors['bd_color']};
}

.tribe-events .tribe-events-c-events-bar__search-container,
.tribe-events .tribe-events-c-view-selector--tabs .tribe-events-c-view-selector__content,
.tooltipster-sidetip .tooltipster-box,
.tooltipster-base.tribe-events-tooltip-theme{
	background-color: {$colors['bg_color']};
}

CSS;
		}
		
		return $css;
	}
}
?>