<?php
/* Revolution Slider support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('hanani_revslider_theme_setup9')) {
	add_action( 'after_setup_theme', 'hanani_revslider_theme_setup9', 9 );
	function hanani_revslider_theme_setup9() {

		add_filter( 'hanani_filter_merge_styles',				'hanani_revslider_merge_styles' );
		
		if (is_admin()) {
			add_filter( 'hanani_filter_tgmpa_required_plugins','hanani_revslider_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'hanani_revslider_tgmpa_required_plugins' ) ) {
	
	function hanani_revslider_tgmpa_required_plugins($list=array()) {
		if (hanani_storage_isset('required_plugins', 'revslider')) {
			$path = hanani_get_file_dir('plugins/revslider/revslider.zip');
			if (!empty($path) || hanani_get_theme_setting('tgmpa_upload')) {
				$list[] = array(
					'name' 		=> hanani_storage_get_array('required_plugins', 'revslider'),
					'slug' 		=> 'revslider',
					'source'	=> !empty($path) ? $path : 'upload://revslider.zip',
					'required' 	=> false,
					'version' 	=> '6.7.32'
				);
			}
		}
		return $list;
	}
}

// Check if RevSlider installed and activated
if ( !function_exists( 'hanani_exists_revslider' ) ) {
	function hanani_exists_revslider() {
		return function_exists('rev_slider_shortcode');
	}
}
	
// Merge custom styles
if ( !function_exists( 'hanani_revslider_merge_styles' ) ) {
	
	function hanani_revslider_merge_styles($list) {
		if (hanani_exists_revslider()) {
			$list[] = 'plugins/revslider/_revslider.scss';
		}
		return $list;
	}
}
?>