<?php
/* learnpress support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 1 - register filters, that add/remove lists items for the Theme Options
if (!function_exists('hanani_learnpress_theme_setup1')) {
	add_action( 'after_setup_theme', 'hanani_learnpress_theme_setup1', 1 );
	function hanani_learnpress_theme_setup1() {
		if ( ! defined( 'LP_COURSE_CPT' ) ) define( 'LP_COURSE_CPT', 'lp_course' );
		if ( ! defined( 'LP_LESSON_CPT' ) ) define( 'LP_LESSON_CPT', 'lp_lesson' );
		if ( ! defined( 'LP_QUESTION_CPT' ) ) define( 'LP_QUESTION_CPT', 'lp_question' );
		if ( ! defined( 'LP_QUIZ_CPT' ) ) define( 'LP_QUIZ_CPT', 'lp_quiz' );
		if ( ! defined( 'LP_ORDER_CPT' ) ) define( 'LP_ORDER_CPT', 'lp_order' );
		if ( ! defined( 'LP_COURSE_TAXONOMY' ) ) define( 'LP_COURSE_TAXONOMY', 'course_category' );
	}
}

// Theme init priorities:
// 3 - add/remove Theme Options elements
if (!function_exists('hanani_learnpress_theme_setup3')) {
	add_action( 'after_setup_theme', 'hanani_learnpress_theme_setup3', 3 );
	function hanani_learnpress_theme_setup3() {
		if (hanani_exists_learnpress()) {
			// Section 'learnpress'
			hanani_storage_set_array_before('options', 'fonts', array_merge(
				array(
					'learnpress' => array(
						"title" => esc_html__('Learnpress', 'hanani'),
						"desc" => wp_kses_data( __('Select parameters to display the learnpress pages', 'hanani') ),
						"priority" => 80,
						"type" => "section"
						),
				),
				hanani_options_get_list_cpt_options('learnpress')
			));
		}
	}
}

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('hanani_learnpress_theme_setup9')) {
	add_action( 'after_setup_theme', 'hanani_learnpress_theme_setup9', 9 );
	function hanani_learnpress_theme_setup9() {

		if (hanani_exists_learnpress()) {
			add_action( 'hanani_action_override_theme_options',			'hanani_learnpress_override_theme_options');
			add_filter( 'hanani_filter_post_type_taxonomy', 'hanani_learnpress_post_type_taxonomy', 10, 2 );
			if (!is_admin()) {
				add_filter( 'hanani_filter_detect_blog_mode',				'hanani_learnpress_detect_blog_mode');
				add_filter( 'trx_addons_filter_get_blog_title',				'hanani_learnpress_get_blog_title');
			}
			add_filter( 'hanani_filter_merge_styles',							'hanani_learnpress_merge_styles');
		}
		if (is_admin()) {
			add_filter( 'hanani_filter_tgmpa_required_plugins',			'hanani_learnpress_tgmpa_required_plugins' );
		}
		
		
	}
}

// Return taxonomy for current post type
if ( ! function_exists( 'hanani_learnpress_post_type_taxonomy' ) ) {
	//Handler of the add_filter( 'hanani_filter_post_type_taxonomy', 'hanani_learnpress_post_type_taxonomy', 10, 2 );
	function hanani_learnpress_post_type_taxonomy( $tax = '', $post_type = '' ) {
		if ( hanani_exists_learnpress() ) {
			if ( LP_COURSE_CPT == $post_type ) {
				$tax = LP_COURSE_TAXONOMY;
			}
		}
		return $tax;
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'hanani_learnpress_tgmpa_required_plugins' ) ) {
	function hanani_learnpress_tgmpa_required_plugins($list=array()) {
		if (hanani_storage_isset('required_plugins', 'learnpress')) {
			$list[] = array(
					'name' 		=> hanani_storage_get_array('required_plugins', 'learnpress'),
					'slug' 		=> 'learnpress',
					'required' 	=> false
				);
		}
		return $list;
	}
}


// Check if learnpress installed and activated
if ( !function_exists( 'hanani_exists_learnpress' ) ) {
	function hanani_exists_learnpress() {
		return class_exists('LearnPress');
	}
}

// Return true, if current page is any learnpress page
if ( !function_exists( 'hanani_is_learnpress_page' ) ) {
	function hanani_is_learnpress_page() {
		$rez = false;
		if (hanani_exists_learnpress())
			$rez = is_learnpress();
		return $rez;
	}
}


// Override options with stored page meta on 'learnpress' pages
if ( ! function_exists( 'hanani_learnpress_override_theme_options' ) ) {
	//Handler of the add_action( 'hanani_action_override_theme_options', 'hanani_learnpress_override_theme_options' );
	function hanani_learnpress_override_theme_options() {
		if ( is_learnpress() ) {
			$id = learn_press_get_page_id( 'courses' );
			if ( 0 < $id ) {
				// Get Theme Options from the courses page
				$courses_meta = get_post_meta( $id, 'hanani_options', true );
				// Add (override) with current post (course) options
				if ( hanani_storage_isset( 'options_meta' ) && is_array( $courses_meta ) && count( $courses_meta ) > 0 ) {
					$options_meta = hanani_storage_get( 'options_meta' );
					if ( is_array( $options_meta ) ) {
						$courses_meta = array_merge( $courses_meta, $options_meta );
					}
				}
				hanani_storage_set( 'options_meta', $courses_meta );
			}
		}
	}
}


// Check if meta box is allowed
if ( ! function_exists( 'hanani_learnpress_allow_override_options' ) ) {
	if ( ! HANANI_THEME_FREE ) {
		add_filter( 'hanani_filter_allow_override_options', 'hanani_learnpress_allow_override_options', 10, 2);
	}
	function hanani_learnpress_allow_override_options( $allow, $post_type ) {
		return $allow || ( hanani_exists_learnpress() && LP_COURSE_CPT == $post_type );
	}
}

// Return current page title
if ( !function_exists( 'hanani_learnpress_get_blog_title' ) ) {
	function hanani_learnpress_get_blog_title($title='') {
		if (hanani_exists_learnpress() && hanani_is_learnpress_page()
			&& learn_press_is_courses() // if on page courses
		) {
			$id = hanani_learnpress_get_learnpress_page_id();
			$title = $id ? get_the_title($id) : esc_html__('LearnPress', 'hanani');
		}
		return $title;
	}
}

// Return learnpress page ID
if ( !function_exists( 'hanani_learnpress_get_learnpress_page_id' ) ) {
	function hanani_learnpress_get_learnpress_page_id() {
		return get_option('learn_press_courses_page_id');
	}
}


// Decorate learnpress output: Loop
//------------------------------------------------------------------------

// Detect current blog mode
if ( ! function_exists( 'hanani_learnpress_detect_blog_mode' ) ) {
	function hanani_learnpress_detect_blog_mode( $mode = '' ) {
		if ( hanani_is_learnpress_page() ) {
			$mode = 'learnpress';
		}
		return $mode;
	}
}

// Custom styles and scripts
//------------------------------------------------------------------------
	
// Merge custom styles
if ( !function_exists( 'hanani_learnpress_merge_styles' ) ) {
	
	function hanani_learnpress_merge_styles($list) {
		if (hanani_exists_learnpress()) {
			$list[] = 'plugins/learnpress/_learnpress.scss';
		}
		return $list;
	}
}

// Add plugin-specific colors and fonts to the custom CSS
if (hanani_exists_learnpress()) {
	require_once HANANI_THEME_DIR . 'plugins/learnpress/learnpress-styles.php';
}
	
// Plugin activation fix (Give + LearnPress + Mailchimp)
if (!function_exists('hanani_learnpress_cron_interval_fix') ) {
	add_filter( 'lp_query_items_cron_interval', 'hanani_learnpress_cron_interval_fix', 11 );
	function hanani_learnpress_cron_interval_fix( $interval ) {
	  return 'integer' != gettype($interval) ? intval($interval) : $interval;		
  }
}
?>