<?php
// Add plugin-specific colors and fonts to the custom CSS
if (!function_exists('hanani_learnpress_get_css')) {
	add_filter('hanani_filter_get_css', 'hanani_learnpress_get_css', 10, 2);
	function hanani_learnpress_get_css($css, $args) {
		
		if (isset($css['fonts']) && isset($args['fonts'])) {
			$fonts = $args['fonts'];
			$css['fonts'] .= <<<CSS
			
	
		.lp-single-course .course-author .author-name a,
		.lp-courses-bar .search-courses input,
		.learn-press-courses[data-layout=list] .course-title,
		.learn-press-courses .course-instructor-category a,
		.learn-press-courses .course-wrap-meta .meta-item{
			{$fonts['h5_font-family']};
		}

		.learn-press-courses .course-content .course-short-description {
			{$fonts['p_font-family']};
		}

		.lp-archive-courses .learn-press-courses[data-layout="list"] .course .course-item .course-content .course-readmore a,
		.course-summary-sidebar .lp-course-buttons button,
		#popup-content .lp-button {
			{$fonts['button_font-family']}
			{$fonts['button_font-size']}
			{$fonts['button_font-style']}
			{$fonts['button_line-height']}
			{$fonts['button_text-decoration']}
			{$fonts['button_text-transform']}
			{$fonts['button_letter-spacing']}
		}
	
CSS;
		}		

		if (isset($css['vars']) && isset($args['vars'])) {
			$vars = $args['vars'];
			
			$css['vars'] .= <<<CSS

CSS;
		}
		
		if (isset($css['colors']) && isset($args['colors'])) {
			$colors = $args['colors'];
			$css['colors'] .= <<<CSS
	
		#learn-press-profile-header {
			background-color: {$colors['text_dark']};
		}
		
		.lp-single-course .course-price .price,
		ul.learn-press-courses .course .course-info .course-price{
			color: {$colors['text_hover']};
		}
		
		
		ul.learn-press-courses .course .lp-course-buttons form button{
			color: {$colors['text_link']};
			border-color: {$colors['text_link']};
		}
		
		ul.learn-press-courses .course .lp-course-buttons form button:hover{
			border-color: transparent;
		}
		
		#learn-press-profile-nav .tabs > li ul li.active a{
			color: {$colors['text_hover']};
		}

		button.write-a-review,
		.learnpress-page .lp-button,
		.learnpress-page .wishlist-button,
		form.lp-archive-courses .learn-press-courses[data-layout="list"] .course .course-item .course-content .course-readmore a,
		.lp-archive-courses .learn-press-courses[data-layout="list"] .course .course-item .course-content .course-readmore a,
		.learn-press-courses .course-content .course-readmore a {
			color: {$colors['inverse_link']};
			background-color: {$colors['text_link']};
			border-color: {$colors['text_link']};
		}

		button.write-a-review:hover,
		button.write-a-review:focus,
		.learnpress-page .lp-button:hover,
		.learnpress-page .lp-button:focus,
		.learnpress-page .wishlist-button:hover,
		.learnpress-page .wishlist-button:focus,
		.lp-archive-courses .learn-press-courses[data-layout="list"] .course .course-item .course-content .course-readmore a:hover,
		.lp-archive-courses .learn-press-courses[data-layout="list"] .course .course-item .course-content .course-readmore a:focus,
		.learn-press-courses .course-content .course-readmore a:hover,
		.learn-press-courses .course-content .course-readmore a:focus {
			color: {$colors['inverse_link']};
			background-color: {$colors['text_hover']};
			border-color: {$colors['text_hover']};
		}
		.lp-modal-dialog .lp-modal-header {
			background-color: {$colors['text_link']};
		}
		.course-tab-panel .lp-course-author .author-title a:hover,
		.lp-courses-bar .search-courses button:hover,
		.learn-press-pagination .page-numbers > li .page-numbers:hover,
		.learn-press-pagination .page-numbers > li .page-numbers.current,
		.lp-archive-courses .learn-press-courses .course .course-item .course-content .course-instructor a {
			color: {$colors['text_link']};
		}
		.lp-archive-courses .learn-press-courses .course .course-item .course-content .course-instructor a:hover {
			color: {$colors['text_hover']};
		}
		.course-tab-panel .lp-course-author .author-title a,
		.course-sidebar-preview .course-price .price,
		.lp-archive-courses .course-content .course-info .course-price .origin-price,
		.lp-archive-courses .course-content .course-info .course-price .price,
		.learn-press-courses[data-layout=list] .course-wrap-meta,
		.lp-courses-bar .search-courses button,
		.learn-press-pagination .page-numbers > li .page-numbers,
		.lp-archive-courses .course-title,
		.learn-press-nav-tabs li label,
		.course-curriculum .course-item .item-name {
			color: {$colors['text_dark']};
		}
		.single.single-lp_course .course-title {
			color: {$colors['inverse_link']};
		}
		.course-summary-sidebar .course-results-progress .number,
		.course-sidebar-preview .course-time-row time,
		.course-tab-panel .course-description,
		.lp-archive-courses .course-content .course-excerpt,
		.course-tab-panel .lp-course-author .author-description {
			color: {$colors['text']};
		}
		.lp-archive-courses .course-meta__pull-left .meta-item__value label {
			color: {$colors['inverse_link']};
			opacity: 0.8;
		}
		.learn-press-progress .progress-bg {
			background-color: {$colors['alter_bg_color']};
		}
		.lp-courses-bar .search-courses input[type='text'] {
			background-color: {$colors['bg_color']};
			border-color: {$colors['bd_color']};
		}
		#popup-course #popup-footer .course-item-nav .prev:before,
		#popup-course #popup-footer .course-item-nav .next:before,
		#popup-course #popup-footer .course-item-nav .prev a,
		#popup-course #popup-footer .course-item-nav .next a,
		.course-summary-sidebar .course-results-progress .items-progress__heading,
		.course-sidebar-preview .course-time-row strong,
		.lp-courses-bar .switch-layout .switch-btn::before {
			color: {$colors['text_dark']};
		}
		#popup-course #popup-footer .course-item-nav .prev:hover:before,
		#popup-course #popup-footer .course-item-nav .next:hover:before,
		#popup-course #popup-footer .course-item-nav .prev:hover a,
		#popup-course #popup-footer .course-item-nav .next:hover a {
			color: {$colors['text_link']};
		}
		.learn-press-courses[data-layout=grid] .course-content .course-footer {
			border-color: {$colors['bd_color']};
		}
		.course-curriculum .section-content .course-item-meta .count-questions {
			background-color: {$colors['text_link']};
		}
		.course-curriculum .section-content .course-item-meta .count-questions:hover {
			background-color: {$colors['text_hover']};
		}
		.question .question-content {
			color: {$colors['text']};
		}
		.question .question-title,
		.content-item-wrap .course-item-title {
			color: {$colors['text_dark']};
		}
		#checkout-order th,
		#checkout-order tfoot .order-total th {
			color: {$colors['text']};
		}
		.learn-press-courses .course-price .free {
			color: {$colors['text_link']};
		}
		.learn-press-courses .course-content .course-permalink:hover span {
			color: {$colors['text_hover']};
		}

CSS;
		}

		return $css;
	}
}
?>