<?php
/* Give support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('hanani_give_theme_setup9')) {
    add_action( 'after_setup_theme', 'hanani_give_theme_setup9', 9 );
    function hanani_give_theme_setup9() {
        if (hanani_exists_give()) {
            add_filter( 'give_form_grid_image_size', 'hanani_give_size');
        }
		
		add_filter( 'hanani_filter_merge_styles',						'hanani_give_merge_styles');
		
		
        if (is_admin()) {
            add_filter( 'hanani_filter_tgmpa_required_plugins',		'hanani_give_tgmpa_required_plugins' );
        }
    }
}
if ( !function_exists( 'hanani_give_size' ) ) {
    function hanani_give_size()    {
        $image_size = hanani_get_thumb_size('huge');
        return $image_size;
    }
}

// Filter to add in the required plugins list
if ( ! function_exists( 'hanani_give_tgmpa_required_plugins' ) ) {
	
	function hanani_give_tgmpa_required_plugins( $list = array() ) {
		if ( hanani_storage_isset( 'required_plugins', 'give' ) ) {
			$list[] = array(
				'name'     => hanani_storage_get_array( 'required_plugins', 'give'),
				'slug'     => 'give',
				'required' => false,
			);
		}
		return $list;
	}
}


// Check if plugin installed and activated
if ( !function_exists( 'hanani_exists_give' ) ) {
    function hanani_exists_give() {
		return class_exists( 'Give' );
    }
}

// Custom styles and scripts
//------------------------------------------------------------------------
	
// Merge custom styles
if ( !function_exists( 'hanani_give_merge_styles' ) ) {
	
	function hanani_give_merge_styles($list) {
		if (hanani_exists_give()) {
			$list[] = 'plugins/give/_give.scss';
		}
		return $list;
	}
}

// Add plugin-specific colors and fonts to the custom CSS
if (hanani_exists_give()) { require_once HANANI_THEME_DIR . 'plugins/give/give-styles.php'; }

?>