<?php
/* Essential Grid support functions
------------------------------------------------------------------------------- */


// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('hanani_essential_grid_theme_setup9')) {
	add_action( 'after_setup_theme', 'hanani_essential_grid_theme_setup9', 9 );
	function hanani_essential_grid_theme_setup9() {
		
		add_filter( 'hanani_filter_merge_styles',						'hanani_essential_grid_merge_styles' );

		if (is_admin()) {
			add_filter( 'hanani_filter_tgmpa_required_plugins',		'hanani_essential_grid_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'hanani_essential_grid_tgmpa_required_plugins' ) ) {
	
	function hanani_essential_grid_tgmpa_required_plugins($list=array()) {
		if (hanani_storage_isset('required_plugins', 'essential-grid')) {
			$path = hanani_get_file_dir('plugins/essential-grid/essential-grid.zip');
			if (!empty($path) || hanani_get_theme_setting('tgmpa_upload')) {
				$list[] = array(
						'name' 		=> hanani_storage_get_array('required_plugins', 'essential-grid'),
						'slug' 		=> 'essential-grid',
						'source'	=> !empty($path) ? $path : 'upload://essential-grid.zip',
						'required' 	=> false,
						'version' 	=> '3.1.9'
				);
			}
		}
		return $list;
	}
}

// Check if plugin installed and activated
if ( !function_exists( 'hanani_exists_essential_grid' ) ) {
	function hanani_exists_essential_grid() {
		return defined('EG_PLUGIN_PATH') || defined( 'ESG_PLUGIN_PATH' );
	}
}
	
// Merge custom styles
if ( !function_exists( 'hanani_essential_grid_merge_styles' ) ) {
	
	function hanani_essential_grid_merge_styles($list) {
		if (hanani_exists_essential_grid()) {
			$list[] = 'plugins/essential-grid/_essential-grid.scss';
		}
		return $list;
	}
}
?>