<?php
/* Elementor Builder support functions
------------------------------------------------------------------------------- */

if (!defined('HANANI_ELEMENTOR_PADDINGS')) define('HANANI_ELEMENTOR_PADDINGS', 15);

// Theme init priorities:

// 1 - register filters to add/remove lists items in the Theme Options
if ( ! function_exists( 'hanani_elm_theme_setup1' ) ) {
	add_action( 'after_setup_theme', 'hanani_elm_theme_setup1', 1 );
	function hanani_elm_theme_setup1() {
		if ( hanani_exists_elementor() ) {
			add_filter( 'hanani_filter_update_post_options', 'hanani_elm_update_post_options', 10, 2 );
			add_action( 'hanani_action_just_save_options', 'hanani_elm_just_save_options', 10, 1 );
		}
	}
}



// 9 - register other filters (for installer, etc.)
if (!function_exists('hanani_elm_theme_setup9')) {
	add_action( 'after_setup_theme', 'hanani_elm_theme_setup9', 9 );
	function hanani_elm_theme_setup9() {
		
		add_filter( 'hanani_filter_merge_styles',					'hanani_elm_merge_styles' );
		add_filter( 'hanani_filter_merge_styles_responsive', 		'hanani_elm_merge_styles_responsive');

		if (hanani_exists_elementor()) {
			add_action( 'init',										'hanani_elm_init_once', 3 );
			add_action( 'elementor/editor/before_enqueue_scripts',	'hanani_elm_editor_scripts');
			add_action( 'elementor/element/before_section_end',		'hanani_elm_add_color_scheme_control', 10, 3 );
			add_action( 'elementor/element/after_section_end',		'hanani_elm_add_page_options', 10, 3 );

			// before Elementor 2.0.0
			add_filter( 'elementor/page/settings/success_response_data', 'hanani_elm_page_options_save', 10, 3 );
			add_filter( 'elementor/general/settings/success_response_data', 'hanani_elm_general_options_save', 10, 3 );
			// after Elementor 2.0.0
			add_filter( 'elementor/settings/page/success_response_data', 'hanani_elm_page_options_save', 10, 3 );
			add_filter( 'elementor/settings/post/success_response_data', 'hanani_elm_page_options_save', 10, 3 );
			add_filter( 'elementor/settings/general/success_response_data', 'hanani_elm_general_options_save', 10, 3 );
			add_filter( 'elementor/documents/ajax_save/return_data', 'hanani_elm_page_options_save_document', 10, 2 );

		}
		if (is_admin()) {
			add_filter( 'hanani_filter_tgmpa_required_plugins',	'hanani_elm_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'hanani_elm_tgmpa_required_plugins' ) ) {
	
	function hanani_elm_tgmpa_required_plugins($list=array()) {
		if (hanani_storage_isset('required_plugins', 'elementor')) {
			$list[] = array(
				'name' 		=> hanani_storage_get_array('required_plugins', 'elementor'),
				'slug' 		=> 'elementor',
				'required' 	=> false
			);
		}
		return $list;
	}
}

// Check if Elementor is installed and activated
if ( !function_exists( 'hanani_exists_elementor' ) ) {
	function hanani_exists_elementor() {
		return class_exists('Elementor\Plugin');
	}
}

// Return true if Elementor exists and current mode is preview
if ( !function_exists( 'hanani_elm_is_preview' ) ) {
	function hanani_elm_is_preview() {
		return hanani_exists_elementor() 
				&& (\Elementor\Plugin::$instance->preview->is_preview_mode()
					|| (hanani_get_value_gp('post') > 0
						&& hanani_get_value_gp('action') == 'elementor'
						)
					);
	}
}

// Merge custom styles
if ( !function_exists( 'hanani_elm_merge_styles' ) ) {
	
	function hanani_elm_merge_styles($list) {
		if (hanani_exists_elementor()) {
			$list[] = 'plugins/elementor/_elementor.scss';
		}
		return $list;
	}
}

// Merge responsive styles
if ( !function_exists( 'hanani_elm_merge_styles_responsive' ) ) {
	
	function hanani_elm_merge_styles_responsive($list) {
		if (hanani_exists_elementor()) {
			$list[] = 'plugins/elementor/_elementor-responsive.scss';
		}
		return $list;
	}
}


// Load required styles and scripts for Elementor Editor mode
if ( !function_exists( 'hanani_elm_editor_scripts' ) ) {
	
	function hanani_elm_editor_scripts() {
		// Load font icons
		wp_enqueue_style(  'fontello-style', hanani_get_file_url('css/font-icons/css/fontello-embedded.css'), array(), null );
		wp_enqueue_script( 'hanani-elementor-editor', hanani_get_file_url('plugins/elementor/elementor-editor.js'), array('jquery'), null, true );
	}
}


// Set Elementor's options at once
if (!function_exists('hanani_elm_init_once')) {
	
	function hanani_elm_init_once() {
		if (hanani_exists_elementor() && !get_option('hanani_setup_elementor_options', false)) {
			// Set theme-specific values to the Elementor's options
			update_option('elementor_disable_color_schemes', 'yes');
			update_option('elementor_disable_typography_schemes', 'yes');
			update_option('elementor_container_width', hanani_get_theme_option('page_width') + 2 * HANANI_ELEMENTOR_PADDINGS);	// Theme-specific width + paddings of the columns
			update_option('elementor_space_between_widgets', 0);
			update_option('elementor_stretched_section_container', '.page_wrap');
			update_option('elementor_page_title_selector', '.sc_layouts_title_caption');
			// Set flag to prevent change Elementor's options again
			update_option('hanani_setup_elementor_options', 1);
		}
	}
}



// Modify Elementor's options after the Theme Options saved
if ( ! function_exists( 'hanani_elm_just_save_options' ) ) {
	
	function hanani_elm_just_save_options( $values ) {
		$w = ! empty( $values['page_width'] )
			? $values['page_width']
			: hanani_get_theme_option_std( 'page_width', hanani_storage_get_array( 'options', 'page_width', 'std' ) );
		if ( ! empty( $w ) ) {
			// Theme-specific width + 2 * paddings of the columns
			update_option( 'elementor_container_width', $w + 2 * HANANI_ELEMENTOR_PADDINGS );
		}
	}
}



// Save General Options via AJAX from Elementor Editor
// (called when any option is changed)
if (!function_exists('hanani_elm_general_options_save')) {
	
	
	function hanani_elm_general_options_save($response_data, $post_id, $data) {
		if (!empty($data['elementor_container_width']) && $data['elementor_container_width'] != hanani_get_theme_option('page_width') + 2 * HANANI_ELEMENTOR_PADDINGS)
			set_theme_mod('page_width', $data['elementor_container_width'] - 2 * HANANI_ELEMENTOR_PADDINGS);	// // Elementor width - paddings of the columns
		return $response_data;
	}
}


// Add theme-specific controls to sections and columns
if (!function_exists('hanani_elm_add_color_scheme_control')) {
	
	function hanani_elm_add_color_scheme_control($element, $section_id, $args) {
		if ( is_object($element) ) {
			$el_name = $element->get_name();
			// Add color scheme selector
			if (apply_filters('hanani_filter_add_scheme_in_elements', 
							  (in_array($el_name, array('section', 'column')) && $section_id === 'section_advanced')
							  || ($el_name === 'common' && $section_id === '_section_style'),
							  $element, $section_id, $args)) {
				$element->add_control('scheme', array(
						'type' => \Elementor\Controls_Manager::SELECT,
						'label' => esc_html__("Color scheme", 'hanani'),
						'label_block' => true,
						'options' => hanani_array_merge(array('' => esc_html__('Inherit', 'hanani')), hanani_get_list_schemes()),
						'default' => '',
						'prefix_class' => 'scheme_'
						) );
			}
			// Add 'Override section width'
			if ($el_name == 'section' && $section_id === 'section_advanced') {
				$element->add_control('justify_columns', array(
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'label' => esc_html__('Justify columns', 'hanani'),
						'description' => wp_kses_data( __("Stretch columns to align the left and right edges to the site content area", 'hanani') ),
						'label_off' => esc_html__( 'Off', 'hanani' ),
						'label_on' => esc_html__( 'On', 'hanani' ),
						'return_value' => 'justified',
						'prefix_class' => 'elementor-section-'
						) );
			}
			// Set default gap between columns to 'Extended'
			if ($el_name == 'section' && $section_id === 'section_layout') {
				$element->update_control('gap', array(
						'default' => 'extended'
						) );
			}
		}
	}
}


// Add tab with theme-specific Page Options to the Page Settings
//---------------------------------------------------------------
if (!function_exists('hanani_elm_add_page_options')) {
	
	function hanani_elm_add_page_options($element, $section_id, $args) {
		if ( is_object($element) ) {
			$el_name = $element->get_name();
			if ( in_array( $el_name, array( 'page-settings', 'post', 'wp-post', 'wp-page' ) ) && 'section_page_style' == $section_id ) {
				$post_id = get_the_ID();
				$post_type = get_post_type($post_id);
				if ($post_id > 0 && hanani_options_override_allow($post_type)) {
					// Load saved options 
					$meta = get_post_meta($post_id, 'hanani_options', true);
					$sections = array();
					global $HANANI_STORAGE;
					// Refresh linked data if this field is controller for the another (linked) field
					// Do this before show fields to refresh data in the $HANANI_STORAGE
					foreach ($HANANI_STORAGE['options'] as $k=>$v) {
						if (!isset($v['override']) || strpos($v['override']['mode'], $post_type)===false) continue;
						if (!empty($v['linked'])) {
							$v['val'] = isset($meta[$k]) ? $meta[$k] : 'inherit';
							if (!empty($v['val']) && !hanani_is_inherit($v['val']))
								hanani_refresh_linked_data($v['val'], $v['linked']);
						}
					}
					// Collect fields to the tabs
					foreach ($HANANI_STORAGE['options'] as $k=>$v) {
						if (!isset($v['override']) || strpos($v['override']['mode'], $post_type)===false || $v['type'] == 'hidden') continue;
						$sec = empty($v['override']['section']) ? esc_html__('General', 'hanani') : $v['override']['section'];
						if (!isset($sections[$sec])) {
							$sections[$sec] = array();
						}
						$v['val'] = isset($meta[$k]) ? $meta[$k] : 'inherit';
						$sections[$sec][$k] = $v;
					}
					if (count($sections) > 0) {
						$cnt = 0;
						foreach ($sections as $sec => $v) {
							$cnt++;
							$element->start_controls_section(
								"section_theme_options_{$cnt}",
								array(
									'label' => $sec,
									'tab' => \Elementor\Controls_Manager::TAB_ADVANCED,
								)
							);
							foreach ($v as $field_id => $params) {
								hanani_elm_add_page_options_field($element, $field_id, $params);
							}
							$element->end_controls_section();
						}
					}
				}
			}
		}
	}
}


// Add control for the specified field
if (!function_exists('hanani_elm_add_page_options_field')) {
	function hanani_elm_add_page_options_field($element, $id, $field) {
		$id_field = "hanani_options_field_{$id}";
		$id_override = "hanani_options_override_{$id}";
		// If fields is inherit
		$inherit_state = isset($field['val']) && hanani_is_inherit($field['val']);
		// Condition
		$condition = array();
		if (!empty($field['dependency'])) {
			foreach ($field['dependency'] as $k => $v) {
				$condition[substr($k, 0, 1) == '#' 
										? str_replace(array('#page_template', '#'), array('template', ''), $k) 
										: "hanani_options_field_{$k}"
									] = $v;
			}
		}
		// Inherit param
		$element->add_control( $id_override, array(
			'label' => $field['title'],
			'label_block' => in_array($field['type'], array('media')),
			'description' => !empty($field['override']['desc']) ? $field['override']['desc'] : (!empty($field['desc']) ? $field['desc'] : ''),
			'separator' => 'before',
			'type' => \Elementor\Controls_Manager::SWITCHER,
			'label_off' => esc_html__( 'Inherit', 'hanani' ),
			'label_on' => esc_html__( 'Override', 'hanani' ),
			'return_value' => '1',
			'condition' => $condition
		) );

		// Field params
		$params = array(
					'label' => esc_html__('New value', 'hanani'),
					'label_block' => in_array($field['type'], array('media', 'info')),
					);
		// Add dependency to params
		$condition[$id_override] = '1';
		$params['condition'] = $condition;
		// Type 'checkbox'
		if ($field['type'] == 'checkbox') {
			$params = array_merge($params, array(
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'label_off' => esc_html__( 'Off', 'hanani' ),
						'label_on' => esc_html__( 'On', 'hanani' ),
						'return_value' => '1'
					));
			$element->add_control( $id_field, $params );

		// Type 'switch' (2 choises) or 'radio' (3+ choises) or 'select'
		} else if (in_array($field['type'], array('switch', 'radio', 'select'))) {
			$field['options'] = apply_filters('hanani_filter_options_get_list_choises', $field['options'], $id);
			$params = array_merge($params, array(
						'type' => \Elementor\Controls_Manager::SELECT,
						'options' => $field['options']
					));
			$element->add_control( $id_field, $params );

		// Type 'checklist', 'select2' and 'icon'
		} else if (in_array($field['type'], array('checklist', 'select2', 'icon'))) {
			$field['options'] = apply_filters('hanani_filter_options_get_list_choises', $field['options'], $id);
			$params = array_merge($params, array(
						'type' => \Elementor\Controls_Manager::SELECT2,
						'options' => $field['options'],
						'multiple' => $field['type']=='checklist' || !empty($field['multiple'])
					));
			$element->add_control( $id_field, $params );

		// Type 'text' or 'time'
		} else if (in_array($field['type'], array('text', 'time'))) {
			$params = array_merge($params, array(
						'type' => \Elementor\Controls_Manager::TEXT
					));
			$element->add_control( $id_field, $params );

		// Type 'date'
		} else if ($field['type'] == 'date') {
			$params = array_merge($params, array(
						'type' => \Elementor\Controls_Manager::DATE_TIME
					));
			$element->add_control( $id_field, $params );

		// Type 'textarea'
		} else if ($field['type'] == 'textarea') {
			$params = array_merge($params, array(
						'type' => \Elementor\Controls_Manager::TEXTAREA,
						'rows' => !empty($field['rows']) ? max(1, $field['rows']) : 5
					));
			$element->add_control( $id_field, $params );

		// Type 'text_editor'
		} else if ($field['type'] == 'text_editor') {
			$params = array_merge($params, array(
						'type' => \Elementor\Controls_Manager::WYSIWYG
					));
			$element->add_control( $id_field, $params );

		// Type 'media'
		} else if (in_array($field['type'], array('image', 'media', 'video', 'audio'))) {
			$params = array_merge($params, array(
						'type' => \Elementor\Controls_Manager::MEDIA,
						'default' => array(
							'id' => !empty($field['val']) && !hanani_is_inherit($field['val']) ? attachment_url_to_postid(hanani_clear_thumb_size($field['val'])) : 0,
							'url' => !empty($field['val']) && !hanani_is_inherit($field['val']) ? $field['val'] : ''
						)
					));
			$element->add_control( $id_field, $params );

		// Type 'color'
		} else if ($field['type'] == 'color') {
			$params = array_merge($params, array(
						'type' => \Elementor\Controls_Manager::COLOR,
					));
			$element->add_control( $id_field, $params );

		// Type 'slider' or 'range'
		} else if (in_array($field['type'], array('slider', 'range'))) {
			$params = array_merge($params, array(
						'type' => \Elementor\Controls_Manager::SLIDER,
						'default' => array(
							'size' => !empty($field['val']) && !hanani_is_inherit($field['val']) ? $field['val'] : '',
							'unit' => 'px'
						),
						'range' => array(
							'px' => array(
								'min' => !empty($field['min']) ? $field['min'] : 0,
								'max' => !empty($field['max']) ? $field['max'] : 1000
							)
						)
					));
			$element->add_control( $id_field, $params );

		}
	}
}


// Save Page Options via AJAX from Elementor Editor
// (called when any option is changed)
if (!function_exists('hanani_elm_page_options_save')) {
	
	
	function hanani_elm_page_options_save($response_data, $post_id, $data) {
		if ($post_id > 0 && is_array($data)) {
			$options = hanani_storage_get('options');
			$meta = get_post_meta($post_id, 'hanani_options', true);
			if (empty($meta)) $meta = array();
			foreach ($options as $k=>$v) {
				$id_field = "hanani_options_field_{$k}";
				$id_override = "hanani_options_override_{$k}";
				if (isset($data[$id_override])) {
					$meta[$k] = isset($data[$id_field]) 
									? (is_array($data[$id_field]) && isset($data[$id_field]['url'])
											? $data[$id_field]['url']
											: $data[$id_field]
											) 
									: (!empty($meta[$k]) && !hanani_is_inherit($meta[$k])
											? $meta[$k]
											: $v['std']
											);
				} else if (isset($meta[$k]))
					unset($meta[$k]);
			}
			update_post_meta( $post_id, 'hanani_options', apply_filters( 'hanani_filter_update_post_options', $meta, $post_id ) );

			// Save separate meta options to search template pages
			if (get_post_type($post_id)=='page' && !empty($data['template']) && $data['template']=='blog.php') {
				update_post_meta($post_id, 'hanani_options_post_type', isset($meta['post_type']) ? $meta['post_type'] : 'post');
				update_post_meta($post_id, 'hanani_options_parent_cat', isset($meta['parent_cat']) ? $meta['parent_cat'] : 0);
			}
		}
		return $response_data;
	}
}


// Save Page Options via AJAX from Elementor Editor
// (called when any option is changed)
if (!function_exists('hanani_elm_page_options_save_document')) {
	
	function hanani_elm_page_options_save_document($response_data, $document) {
		if ( ($post_id = $document->get_main_id()) > 0 ) {
			$actions = json_decode(hanani_get_value_gp('actions'), true);
			if (is_array($actions) && isset($actions['save_builder']['data']['settings']) && is_array($actions['save_builder']['data']['settings'])) {
				$settings = $actions['save_builder']['data']['settings'];
				if (is_array($settings)) {
					hanani_elm_page_options_save('', $post_id, $actions['save_builder']['data']['settings']);
				}
			}
		}
		return $response_data;
	}
}


// Save Page Options when page is updated (saved) from WordPress Editor
if (!function_exists('hanani_elm_update_post_options')) {
	
	function hanani_elm_update_post_options($meta, $post_id) {
		if (doing_filter('save_post')) {
			$elm_meta = get_post_meta($post_id, '_elementor_page_settings', true);
			if (is_array($elm_meta)) {
				foreach ($elm_meta as $k=>$v) {
					if (strpos($k, 'hanani_options_') !== false)
						unset($elm_meta[$k]);
				}
			} else {
				$elm_meta = array();
			}
			$options = hanani_storage_get('options');
			foreach ($meta as $k => $v) {
				$elm_meta["hanani_options_field_{$k}"] = in_array($options[$k]['type'], array('image','video','audio','media'))
																? array(
																	'id' => attachment_url_to_postid(hanani_clear_thumb_size($v)),
																	'url' => $v
																	)
																: $v;
				$elm_meta["hanani_options_override_{$k}"] = '1';
			}
			update_post_meta($post_id, '_elementor_page_settings', apply_filters( 'hanani_filter_elementor_update_page_settings', $elm_meta, $post_id ));
		}
		return $meta;
	}
}

// Elementor 3.21.0+ - add default value for the 'spacer' widget
//--------------------------------------------------
if ( ! function_exists( 'trx_addons_elm_add_spacer_default_value' ) ) {
	add_action( 'trx_addons_action_is_new_version_of_plugin', 'trx_addons_elm_add_spacer_default_value', 10, 2 );
	add_action( 'trx_addons_action_importer_import_end', 'trx_addons_elm_add_spacer_default_value' );
	/**
	 * Add a default value to all widgets 'Spacer' after update plugin ThemeREX Addons to the new version or after import demo data
	 * (because a new version of Elementor don't display the 'Spacer' widget with an empty value)
	 *
	 * @hooked trx_addons_action_is_new_version_of_plugin
	 * @hooked trx_addons_action_importer_import_end
	 * 
	 * @param string $new_version New version of the plugin.
	 * @param string $old_version Old version of the plugin.
	 */
	function trx_addons_elm_add_spacer_default_value( $new_version = '', $old_version = '' ) {
		if ( empty( $old_version ) ) {
			$old_version = get_option( 'trx_addons_version', '1.0' );
		}
		if ( version_compare( $old_version, '2.29.1', '<' ) || current_action() == 'trx_addons_action_importer_import_end' ) {
			global $wpdb;
			$rows = $wpdb->get_results( "SELECT post_id, meta_id, meta_value
											FROM {$wpdb->postmeta}
											WHERE meta_key='_elementor_data' && meta_value!=''"
										);
			if ( is_array( $rows ) && count( $rows ) > 0 ) {
				foreach ( $rows as $row ) {
					$data = json_decode( $row->meta_value, true );
					if ( trx_addons_elm_convert_spacer_default_value( $data ) ) {
						$wpdb->query( "UPDATE {$wpdb->postmeta} SET meta_value = '" . wp_slash( wp_json_encode( $data ) ) . "' WHERE meta_id = {$row->meta_id} LIMIT 1" );
					}
				}
			}
		}
	}
}

if ( ! function_exists( 'trx_addons_elm_convert_spacer_default_value' ) ) {
	/**
	 * Add a default value to all widgets 'Spacer' to the all elements in the Elementor data
	 * Attention! The parameter $elements passed by reference and modified inside this function!
	 * Return true if $elements is modified (converted) and needs to be saved
	 *
	 * @param array $elements  Array of elements. Passed by reference and modified inside this function!
	 * 
	 * @return boolean True if parameters was changed and needs to be saved
	 */
	function trx_addons_elm_convert_spacer_default_value( &$elements ) {
		$modified = false;
		$sc = array( 'spacer' );
		if ( is_array( $elements ) ) {
			foreach( $elements as $k => $elm ) {
				// Convert parameters
				if (   ! empty( $elm['widgetType'] )
					&&   in_array( $elm['widgetType'], $sc )
					&& ! empty( $elm['settings']['alter_height'] )
					&& ! empty( $elm['settings']['space'] )
					&&   empty( $elm['settings']['space']['size'] )
				) {
					unset( $elements[ $k ]['settings']['space'] );
					$modified = true;
				}
				// Process inner elements
				if ( ! empty( $elm['elements'] ) && is_array( $elm['elements'] ) ) {
					$modified = trx_addons_elm_convert_spacer_default_value( $elements[ $k ]['elements'] ) || $modified;
				}
			}
		}
		return $modified;
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if (hanani_exists_elementor()) { require_once HANANI_THEME_DIR . 'plugins/elementor/elementor-styles.php'; }
?>