<?php
/* Contact Form 7 support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('hanani_cf7_theme_setup9')) {
	add_action( 'after_setup_theme', 'hanani_cf7_theme_setup9', 9 );
	function hanani_cf7_theme_setup9() {
		add_filter('wpcf7_autop_or_not', '__return_false');
		add_filter( 'hanani_filter_merge_scripts',	'hanani_cf7_merge_scripts');
		add_filter( 'hanani_filter_merge_styles',	'hanani_cf7_merge_styles' );

		if (hanani_exists_cf7()) {
			add_action( 'wp_enqueue_scripts',		'hanani_cf7_frontend_scripts', 1100 );
		}

		if (is_admin()) {
			add_filter( 'hanani_filter_tgmpa_required_plugins',	'hanani_cf7_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'hanani_cf7_tgmpa_required_plugins' ) ) {
	
	function hanani_cf7_tgmpa_required_plugins($list=array()) {
		if (hanani_storage_isset('required_plugins', 'contact-form-7')) {
			// CF7 plugin
			$list[] = array(
					'name' 		=> hanani_storage_get_array('required_plugins', 'contact-form-7'),
					'slug' 		=> 'contact-form-7',
					'required' 	=> false
			);
		}
		return $list;
	}
}



// Check if cf7 installed and activated
if ( !function_exists( 'hanani_exists_cf7' ) ) {
	function hanani_exists_cf7() {
		return class_exists('WPCF7');
	}
}

// Enqueue custom scripts
if ( !function_exists( 'hanani_cf7_frontend_scripts' ) ) {
	
	function hanani_cf7_frontend_scripts() {
		if (hanani_exists_cf7()) {
			if (hanani_is_on(hanani_get_theme_option('debug_mode')) && ($hanani_url = hanani_get_file_url('plugins/contact-form-7/contact-form-7.js')) != '')
				wp_enqueue_script( 'hanani-cf7', $hanani_url, array('jquery'), null, true );
		}
	}
}
	
// Merge custom scripts
if ( !function_exists( 'hanani_cf7_merge_scripts' ) ) {
	
	function hanani_cf7_merge_scripts($list) {
		if (hanani_exists_cf7()) {
			$list[] = 'plugins/contact-form-7/contact-form-7.js';
		}
		return $list;
	}
}

// Merge custom styles
if ( !function_exists( 'hanani_cf7_merge_styles' ) ) {
	
	function hanani_cf7_merge_styles($list) {
		if (hanani_exists_cf7()) {
			$list[] = 'plugins/contact-form-7/_contact-form-7.scss';
		}
		return $list;
	}
}
?>