<?php
/**
 * The template for homepage posts with "Portfolio" style
 *
 * @package WordPress
 * @subpackage HANANI
 * @since HANANI 1.0
 */

hanani_storage_set('blog_archive', true);

get_header(); 

if (have_posts()) {

	hanani_blog_archive_start();

	$hanani_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$hanani_sticky_out = hanani_get_theme_option('sticky_style')=='columns' 
							&& is_array($hanani_stickies) && count($hanani_stickies) > 0 && get_query_var( 'paged' ) < 1;
	
	// Show filters
	$hanani_cat = hanani_get_theme_option('parent_cat');
	$hanani_post_type = hanani_get_theme_option('post_type');
	$hanani_taxonomy = hanani_get_post_type_taxonomy($hanani_post_type);
	$hanani_show_filters = hanani_get_theme_option('show_filters');
	$hanani_tabs = array();
	if (!hanani_is_off($hanani_show_filters)) {
		$hanani_args = array(
			'type'			=> $hanani_post_type,
			'child_of'		=> $hanani_cat,
			'orderby'		=> 'name',
			'order'			=> 'ASC',
			'hide_empty'	=> 1,
			'hierarchical'	=> 0,
			'taxonomy'		=> $hanani_taxonomy,
			'pad_counts'	=> false
		);
		$hanani_portfolio_list = get_terms($hanani_args);
		if (is_array($hanani_portfolio_list) && count($hanani_portfolio_list) > 0) {
			$hanani_tabs[$hanani_cat] = esc_html__('All', 'hanani');
			foreach ($hanani_portfolio_list as $hanani_term) {
				if (isset($hanani_term->term_id)) $hanani_tabs[$hanani_term->term_id] = $hanani_term->name;
			}
		}
	}
	if (count($hanani_tabs) > 0) {
		$hanani_portfolio_filters_ajax = true;
		$hanani_portfolio_filters_active = $hanani_cat;
		$hanani_portfolio_filters_id = 'portfolio_filters';
		?>
		<div class="portfolio_filters hanani_tabs hanani_tabs_ajax">
			<ul class="portfolio_titles hanani_tabs_titles">
				<?php
				foreach ($hanani_tabs as $hanani_id=>$hanani_title) {
					?><li><a href="<?php echo esc_url(hanani_get_hash_link(sprintf('#%s_%s_content', $hanani_portfolio_filters_id, $hanani_id))); ?>" data-tab="<?php echo esc_attr($hanani_id); ?>"><?php echo esc_html($hanani_title); ?></a></li><?php
				}
				?>
			</ul>
			<?php
			$hanani_ppp = hanani_get_theme_option('posts_per_page');
			if (hanani_is_inherit($hanani_ppp)) $hanani_ppp = '';
			foreach ($hanani_tabs as $hanani_id=>$hanani_title) {
				$hanani_portfolio_need_content = $hanani_id==$hanani_portfolio_filters_active || !$hanani_portfolio_filters_ajax;
				?>
				<div id="<?php echo esc_attr(sprintf('%s_%s_content', $hanani_portfolio_filters_id, $hanani_id)); ?>"
					class="portfolio_content hanani_tabs_content"
					data-blog-template="<?php echo esc_attr(hanani_storage_get('blog_template')); ?>"
					data-blog-style="<?php echo esc_attr(hanani_get_theme_option('blog_style')); ?>"
					data-posts-per-page="<?php echo esc_attr($hanani_ppp); ?>"
					data-post-type="<?php echo esc_attr($hanani_post_type); ?>"
					data-taxonomy="<?php echo esc_attr($hanani_taxonomy); ?>"
					data-cat="<?php echo esc_attr($hanani_id); ?>"
					data-parent-cat="<?php echo esc_attr($hanani_cat); ?>"
					data-need-content="<?php echo (false===$hanani_portfolio_need_content ? 'true' : 'false'); ?>"
				>
					<?php
					if ($hanani_portfolio_need_content) 
						hanani_show_portfolio_posts(array(
							'cat' => $hanani_id,
							'parent_cat' => $hanani_cat,
							'taxonomy' => $hanani_taxonomy,
							'post_type' => $hanani_post_type,
							'page' => 1,
							'sticky' => $hanani_sticky_out
							)
						);
					?>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	} else {
		hanani_show_portfolio_posts(array(
			'cat' => $hanani_cat,
			'parent_cat' => $hanani_cat,
			'taxonomy' => $hanani_taxonomy,
			'post_type' => $hanani_post_type,
			'page' => 1,
			'sticky' => $hanani_sticky_out
			)
		);
	}

	hanani_blog_archive_end();

} else {

	if ( is_search() )
		get_template_part( apply_filters('hanani_filter_get_template_part', 'content', 'none-search'), 'none-search' );
	else
		get_template_part( apply_filters('hanani_filter_get_template_part', 'content', 'none-archive'), 'none-archive' );

}

get_footer();
?>