<?php
/**
 * The template for homepage posts with "Excerpt" style
 *
 * @package WordPress
 * @subpackage HANANI
 * @since HANANI 1.0
 */

hanani_storage_set('blog_archive', true);

get_header(); 

if (have_posts()) {

	hanani_blog_archive_start();

	?><div class="posts_container"><?php
	
	$hanani_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$hanani_sticky_out = hanani_get_theme_option('sticky_style')=='columns' 
							&& is_array($hanani_stickies) && count($hanani_stickies) > 0 && get_query_var( 'paged' ) < 1;
	if ($hanani_sticky_out) {
		?><div class="sticky_wrap columns_wrap"><?php	
	}
	while ( have_posts() ) { the_post(); 
		if ($hanani_sticky_out && !is_sticky()) {
			$hanani_sticky_out = false;
			?></div><?php
		}
		$hanani_part = $hanani_sticky_out && is_sticky() ? 'sticky' : 'excerpt';
		get_template_part( apply_filters('hanani_filter_get_template_part', 'content', $hanani_part), $hanani_part );
	}
	if ($hanani_sticky_out) {
		$hanani_sticky_out = false;
		?></div><?php
	}
	
	?></div><?php

	hanani_show_pagination();

	hanani_blog_archive_end();

} else {

	if ( is_search() )
		get_template_part( apply_filters('hanani_filter_get_template_part', 'content', 'none-search'), 'none-search' );
	else
		get_template_part( apply_filters('hanani_filter_get_template_part', 'content', 'none-archive'), 'none-archive' );

}

get_footer();
?>