<?php
/**
 * The Sticky template to display the sticky posts
 *
 * Used for index/archive
 *
 * @package WordPress
 * @subpackage HANANI
 * @since HANANI 1.0
 */

$hanani_columns = max(1, min(3, count(get_option( 'sticky_posts' ))));
$hanani_post_format = get_post_format();
$hanani_post_format = empty($hanani_post_format) ? 'standard' : str_replace('post-format-', '', $hanani_post_format);
$hanani_animation = hanani_get_theme_option('blog_animation');

?><div class="column-1_<?php echo esc_attr($hanani_columns); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_sticky post_format_'.esc_attr($hanani_post_format) ); ?>
	<?php echo (!hanani_is_off($hanani_animation) ? ' data-animation="'.esc_attr(hanani_get_animation_classes($hanani_animation)).'"' : ''); ?>
	>

	<?php
	if ( is_sticky() && is_home() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	hanani_show_post_featured(array(
		'thumb_size' => hanani_get_thumb_size($hanani_columns==1 ? 'big' : ($hanani_columns==2 ? 'med' : 'avatar'))
	));

	if ( !in_array($hanani_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( sprintf( '<h6 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h6>' );
			// Post meta
			hanani_show_post_meta(apply_filters('hanani_filter_post_meta_args', array(), 'sticky', $hanani_columns));
			?>
		</div><!-- .entry-header -->
		<?php
	}
	?>
</article></div>