<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage HANANI
 * @since HANANI 1.0
 */

$hanani_template_args = get_query_var( 'hanani_template_args' );
if ( is_array( $hanani_template_args ) ) {
    $hanani_columns    = empty( $hanani_template_args['columns'] ) ? 2 : max( 1, $hanani_template_args['columns'] );
    $hanani_blog_style = array( $hanani_template_args['type'], $hanani_columns );
    $hanani_columns_class = trx_addons_get_column_class( 1, $hanani_columns, ! empty( $hanani_template_args['columns_tablet']) ? $hanani_template_args['columns_tablet'] : '', ! empty($hanani_template_args['columns_mobile']) ? $hanani_template_args['columns_mobile'] : '' );
} else {
    $hanani_blog_style = explode( '_', hanani_get_theme_option( 'blog_style' ) );
    $hanani_columns    = empty( $hanani_blog_style[1] ) ? 2 : max( 1, $hanani_blog_style[1] );
    $hanani_columns_class = trx_addons_get_column_class( 1, $hanani_columns );
}
$hanani_post_format = get_post_format();
$hanani_post_format = empty($hanani_post_format) ? 'standard' : str_replace('post-format-', '', $hanani_post_format);
$hanani_animation = hanani_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" <?php
	post_class( 'post_item'
				. ' post_layout_portfolio'
				. ' post_layout_portfolio_'.esc_attr($hanani_columns)
				. ' post_format_'.esc_attr($hanani_post_format)
				. (is_sticky() && !is_paged() ? ' sticky' : '')
				. (!empty($hanani_template_args['slider']) ? ' slider-slide swiper-slide' : '')
			);
	echo (!hanani_is_off($hanani_animation) && empty($hanani_template_args['slider']) ? ' data-animation="'.esc_attr(hanani_get_animation_classes($hanani_animation)).'"' : '');
?>><?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	$hanani_image_hover = !empty($hanani_template_args['hover']) && !hanani_is_inherit($hanani_template_args['hover'])
								? $hanani_template_args['hover']
								: hanani_get_theme_option('image_hover');
	// Featured image
	hanani_show_post_featured(array(
		'singular' => false,
		'hover' => $hanani_image_hover,
		'no_links' => !empty($hanani_template_args['no_links']),
		'thumb_size' => hanani_get_thumb_size(strpos(hanani_get_theme_option('body_style'), 'full')!==false || $hanani_columns < 3 
								? 'masonry-big' 
								: 'masonry'),
		'show_no_image' => true,
		'class' => $hanani_image_hover == 'dots' ? 'hover_with_info' : '',
		'post_info' => $hanani_image_hover == 'dots' ? '<div class="post_info">'.esc_html(get_the_title()).'</div>' : ''
	));
	?>
</article>