<?php
/**
 * The Gallery template to display posts
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage HANANI
 * @since HANANI 1.0
 */

$hanani_template_args = get_query_var( 'hanani_template_args' );
if ( is_array( $hanani_template_args ) ) {
    $hanani_columns    = empty( $hanani_template_args['columns'] ) ? 2 : max( 1, $hanani_template_args['columns'] );
    $hanani_blog_style = array( $hanani_template_args['type'], $hanani_columns );
    $hanani_columns_class = trx_addons_get_column_class( 1, $hanani_columns, ! empty( $hanani_template_args['columns_tablet']) ? $hanani_template_args['columns_tablet'] : '', ! empty($hanani_template_args['columns_mobile']) ? $hanani_template_args['columns_mobile'] : '' );
} else {
    $hanani_blog_style = explode( '_', hanani_get_theme_option( 'blog_style' ) );
    $hanani_columns    = empty( $hanani_blog_style[1] ) ? 2 : max( 1, $hanani_blog_style[1] );
    $hanani_columns_class = trx_addons_get_column_class( 1, $hanani_columns );
}
$hanani_post_format = get_post_format();
$hanani_post_format = empty($hanani_post_format) ? 'standard' : str_replace('post-format-', '', $hanani_post_format);
$hanani_animation = hanani_get_theme_option('blog_animation');
$hanani_image = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' );

?><article id="post-<?php the_ID(); ?>" <?php
	post_class( 'post_item'
				. ' post_layout_portfolio'
				. ' post_layout_gallery'
				. ' post_layout_gallery_'.esc_attr($hanani_columns)
				. ' post_format_'.esc_attr($hanani_post_format)
				. (!empty($hanani_template_args['slider']) ? ' slider-slide swiper-slide' : '')
			);
	echo (!hanani_is_off($hanani_animation) && empty($hanani_template_args['slider']) ? ' data-animation="'.esc_attr(hanani_get_animation_classes($hanani_animation)).'"' : '');
	?>
	data-size="<?php if (!empty($hanani_image[1]) && !empty($hanani_image[2])) echo intval($hanani_image[1]) .'x' . intval($hanani_image[2]); ?>"
	data-src="<?php if (!empty($hanani_image[0])) echo esc_url($hanani_image[0]); ?>"
><?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	$hanani_image_hover = 'icon';
	if (in_array($hanani_image_hover, array('icons', 'zoom'))) $hanani_image_hover = 'dots';
	$hanani_components = hanani_array_get_keys_by_value(hanani_get_theme_option('meta_parts'));
	$hanani_counters = hanani_array_get_keys_by_value(hanani_get_theme_option('counters'));
	hanani_show_post_featured(array(
		'hover' => $hanani_image_hover,
		'singular' => false,
		'no_links' => !empty($hanani_template_args['no_links']),
		'thumb_size' => hanani_get_thumb_size( strpos(hanani_get_theme_option('body_style'), 'full')!==false || $hanani_columns < 3 ? 'masonry-big' : 'masonry' ),
		'thumb_only' => true,
		'show_no_image' => true,
		'post_info' => '<div class="post_details">'
							. '<h2 class="post_title">'
								. (empty($hanani_template_args['no_links']) 
									? '<a href="'.esc_url(get_permalink()).'">' . esc_html(get_the_title()) . '</a>'
									: esc_html(get_the_title())
									)
							. '</h2>'
							. '<div class="post_description">'
								. (!empty($hanani_components)
									? hanani_show_post_meta(apply_filters('hanani_filter_post_meta_args', array(
											'components' => $hanani_components,
											'counters' => $hanani_counters,
											'seo' => false,
											'echo' => false
											), $hanani_blog_style[0], $hanani_columns))
									: ''
									)
								. (empty($hanani_template_args['hide_excerpt'])
									? '<div class="post_description_content">' . get_the_excerpt() . '</div>'
									: ''
									)
								. (empty($hanani_template_args['no_links']) 
									? '<a href="'.esc_url(get_permalink()).'" class="theme_button post_readmore"><span class="post_readmore_label">' . esc_html__('Learn more', 'hanani') . '</span></a>' 
									: ''
									)
							. '</div>'
						. '</div>'
	));
?></article>