<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage HANANI
 * @since HANANI 1.0
 */

$hanani_template_args = get_query_var( 'hanani_template_args' );
$hanani_columns = 1;
if ( is_array( $hanani_template_args ) ) {
    $hanani_columns    = empty( $hanani_template_args['columns'] ) ? 1 : max( 1, $hanani_template_args['columns'] );
    $hanani_blog_style = array( $hanani_template_args['type'], $hanani_columns );
    if ( ! empty( $hanani_template_args['slider'] ) ) {
        ?><div class="slider-slide swiper-slide">
        <?php
    } elseif ( $hanani_columns > 1 ) {
        $hanani_columns_class = trx_addons_get_column_class( 1, $hanani_columns, ! empty( $hanani_template_args['columns_tablet']) ? $hanani_template_args['columns_tablet'] : '', ! empty($hanani_template_args['columns_mobile']) ? $hanani_template_args['columns_mobile'] : '' );
        ?>
        <div class="<?php echo esc_attr( $hanani_columns_class ); ?>">
        <?php
    }
}

$hanani_expanded = !hanani_sidebar_present() && hanani_is_on(hanani_get_theme_option('expand_content'));
$hanani_post_format = get_post_format();
$hanani_post_format = empty($hanani_post_format) ? 'standard' : str_replace('post-format-', '', $hanani_post_format);
$hanani_animation = hanani_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_excerpt post_format_'.esc_attr($hanani_post_format) ); ?>
	<?php echo (!hanani_is_off($hanani_animation) && empty($hanani_template_args['slider']) ? ' data-animation="'.esc_attr(hanani_get_animation_classes($hanani_animation)).'"' : ''); ?>
	><?php


	// Post meta
	$hanani_components = hanani_array_get_keys_by_value(hanani_get_theme_option('meta_parts'));
	$hanani_counters = hanani_array_get_keys_by_value(hanani_get_theme_option('counters'));

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	$hanani_hover = !empty($hanani_template_args['hover']) && !hanani_is_inherit($hanani_template_args['hover'])
						? $hanani_template_args['hover'] 
						: hanani_get_theme_option('image_hover');

	if (!in_array($hanani_post_format, array('audio', 'link', 'aside', 'status', 'quote'))) {
		$cats = get_post_type() == 'post' ? get_the_category_list(' ') : apply_filters('hanani_filter_get_post_categories', '');
	}
	hanani_show_post_featured(array(
									'singular' => false,
									'no_links' => !empty($hanani_template_args['no_links']),
									'hover' => $hanani_hover,
									'thumb_size' => hanani_get_thumb_size( strpos(hanani_get_theme_option('body_style'), 'full')!==false ? 'full' : ($hanani_expanded ? 'huge' : 'big') ),
									'post_info' => !empty($cats) ? '<div class="post_info post_info_categories"><div class="post_categories">'.$cats.'</div></div>' : ''
	));

	// Title and post meta
	if (get_the_title() != '') {
		?>
		<div class="post_header entry-header">
			<?php
			do_action('hanani_action_before_post_title'); 

			// Post title
			if (empty($hanani_template_args['no_links']))
				the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
			else
				the_title( '<h4 class="post_title entry-title">', '</h4>' );

			do_action('hanani_action_before_post_meta'); 

			if (!empty($hanani_components) && !in_array($hanani_hover, array('border', 'pull', 'slide', 'fade')))
				hanani_show_post_meta(apply_filters('hanani_filter_post_meta_args', array(
					'components' => $hanani_components,
					'counters' => $hanani_counters,
					'seo' => false
					), 'excerpt', 1)
				);
			?>
		</div><!-- .post_header --><?php
	}
	
	// Post content
	if (empty($hanani_template_args['hide_excerpt'])) {

		?><div class="post_content entry-content"><?php
			if (hanani_get_theme_option('blog_content') == 'fullpost') {
				// Post content area
				?><div class="post_content_inner"><?php
					the_content( '' );
				?></div><?php
				// Inner pages
				wp_link_pages( array(
					'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'hanani' ) . '</span>',
					'after'       => '</div>',
					'link_before' => '<span>',
					'link_after'  => '</span>',
					'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'hanani' ) . ' </span>%',
					'separator'   => '<span class="screen-reader-text">, </span>',
				) );
			} else {
				// Post content area
				?><div class="post_content_inner"><?php
					if (has_excerpt()) {
						the_excerpt();
					} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
						the_content( '' );
					} else if (in_array($hanani_post_format, array('link', 'aside', 'status'))) {
						the_content();
					} else if ($hanani_post_format == 'quote') {
						if (($quote = hanani_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
							hanani_show_layout(wpautop($quote));
						else
							the_excerpt();
					} else if (substr(get_the_content(), 0, 4)!='[vc_') {
						the_excerpt();
					}
				?></div><div class="bottom_info_wrapper"><?php


					// More button
					if ( empty($hanani_template_args['no_links']) && !in_array($hanani_post_format, array('link', 'aside', 'status', 'quote')) ) {
						?><p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'hanani'); ?></a></p><?php


						$pos = strripos($hanani_components, 'share');
						if ($pos !== false) {
							hanani_show_share_links(array(
								'type' => '',
								'caption' => '',
								'before' => '<span class="post_meta_item post_share">',
								'after' => '</span>',
								'post_title' => get_the_title()
							));

						}

					}





			}
		?></div></div><!-- .entry-content --><?php
	}
?></article><?php

if (is_array($hanani_template_args)) {
	if (!empty($hanani_template_args['slider']) || $hanani_columns > 1) {
		?></div><?php
	}
}
?>