<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage HANANI
 * @since HANANI 1.0
 */

$hanani_template_args = get_query_var( 'hanani_template_args' );

if ( is_array( $hanani_template_args ) ) {
    $hanani_columns       = empty( $hanani_template_args['columns'] ) ? 2 : max( 1, $hanani_template_args['columns'] );
    $hanani_blog_style    = array( $hanani_template_args['type'], $hanani_columns );
    $hanani_columns_class = trx_addons_get_column_class( 1, $hanani_columns, ! empty( $hanani_template_args['columns_tablet']) ? $hanani_template_args['columns_tablet'] : '', ! empty($hanani_template_args['columns_mobile']) ? $hanani_template_args['columns_mobile'] : '' );
} else {
    $hanani_blog_style    = explode( '_', hanani_get_theme_option( 'blog_style' ) );
    $hanani_columns       = empty( $hanani_blog_style[1] ) ? 2 : max( 1, $hanani_blog_style[1] );
    $hanani_columns_class = trx_addons_get_column_class( 1, $hanani_columns );
}

$hanani_expanded = !hanani_sidebar_present() && hanani_is_on(hanani_get_theme_option('expand_content'));
$hanani_animation = hanani_get_theme_option('blog_animation');
$hanani_components = hanani_array_get_keys_by_value(hanani_get_theme_option('meta_parts'));
$hanani_counters = hanani_array_get_keys_by_value(hanani_get_theme_option('counters'));

$hanani_post_format = get_post_format();
$hanani_post_format = empty($hanani_post_format) ? 'standard' : str_replace('post-format-', '', $hanani_post_format);

?><div class="<?php
if (!empty($hanani_template_args['slider']))
    echo ' slider-slide swiper-slide';
else
    echo ('classic' == $hanani_blog_style[0] ? 'column' : 'masonry_item masonry_item') . '-1_' . esc_attr($hanani_columns);
?>"><?php
	?><article id="post-<?php the_ID(); ?>" <?php
		post_class( 'post_item post_format_'.esc_attr($hanani_post_format)
					. ' post_layout_classic post_layout_classic_'.esc_attr($hanani_columns)
					. ' post_layout_'.esc_attr($hanani_blog_style[0]) 
					. ' post_layout_'.esc_attr($hanani_blog_style[0]).'_'.esc_attr($hanani_columns)
		);
		echo (!hanani_is_off($hanani_animation) && empty($hanani_template_args['slider']) ? ' data-animation="'.esc_attr(hanani_get_animation_classes($hanani_animation)).'"' : '');
	?>><?php


	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	$hanani_hover = !empty($hanani_template_args['hover']) && !hanani_is_inherit($hanani_template_args['hover'])
						? $hanani_template_args['hover'] 
						: hanani_get_theme_option('image_hover');


	if (!in_array($hanani_post_format, array('audio', 'link', 'aside', 'status', 'quote'))) {
		$cats = get_post_type() == 'post' ? get_the_category_list(' ') : apply_filters('hanani_filter_get_post_categories', '');
	}

		hanani_show_post_featured( array( 'thumb_size' => hanani_get_thumb_size($hanani_blog_style[0] == 'classic'
													? (strpos(hanani_get_theme_option('body_style'), 'full')!==false 
															? ( $hanani_columns > 2 ? 'big' : 'huge' )
															: (	$hanani_columns > 2
																? ($hanani_expanded ? 'med' : 'small')
																: ($hanani_expanded ? 'big' : 'med')
																)
														)
													: (strpos(hanani_get_theme_option('body_style'), 'full')!==false 
															? ( $hanani_columns > 2 ? 'masonry-big' : 'full' )
															: (	$hanani_columns <= 2 && $hanani_expanded ? 'masonry-big' : 'masonry')
														)
												),
										'hover' => $hanani_hover,
										'no_links' => !empty($hanani_template_args['no_links']),
										'singular' => false,
										'post_info' => !empty($cats) ? '<div class="post_info post_info_categories"><div class="post_categories">'.$cats.'</div></div>' : ''
								) );

	if ( !in_array($hanani_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php 
			do_action('hanani_action_before_post_title'); 

			// Post title
			if (empty($hanani_template_args['no_links']))
				the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
			else
				the_title( '<h4 class="post_title entry-title">', '</h4>' );

			do_action('hanani_action_before_post_meta');

			// Post meta
			if (!empty($hanani_components)) {
				hanani_show_post_meta(apply_filters('hanani_filter_post_meta_args', array(
						'components' => $hanani_components,
						'counters' => $hanani_counters,
						'seo' => false
					), $hanani_blog_style[0], $hanani_columns)
				);
			}

			do_action('hanani_action_after_post_meta');
			?>
		</div><!-- .entry-header -->
		<?php
	}		
	?>

	<div class="post_content entry-content"><?php
		if (empty($hanani_template_args['hide_excerpt'])) {
			?><div class="post_content_inner">
				<?php
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($hanani_post_format, array('link', 'aside', 'status'))) {
					the_content();
				} else if ($hanani_post_format == 'quote') {
					if (($quote = hanani_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
						hanani_show_layout(wpautop($quote));
					else
						the_excerpt();
				} else if (substr(get_the_content(), 0, 4)!='[vc_') {
					the_excerpt();
				}
			?></div><?php
		}
		// Post meta
		if (in_array($hanani_post_format, array('link', 'aside', 'status', 'quote'))) {
			if (!empty($hanani_components))
				hanani_show_post_meta(apply_filters('hanani_filter_post_meta_args', array(
					'components' => $hanani_components,
					'counters' => $hanani_counters
					), $hanani_blog_style[0], $hanani_columns)
				);
		}
		// More button
		if ( false && empty($hanani_template_args['no_links']) && !in_array($hanani_post_format, array('link', 'aside', 'status', 'quote')) ) {
			?><p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'hanani'); ?></a></p><?php
		}
		?>
	</div><!-- .entry-content -->

</article></div>