<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage HANANI
 * @since HANANI 1.0
 */

$hanani_template_args = get_query_var('hanani_template_args');
if (is_array($hanani_template_args)) {
	$hanani_columns = empty($hanani_template_args['columns']) ? 1 : max(1, min(3, $hanani_template_args['columns']));
	$hanani_blog_style = array($hanani_template_args['type'], $hanani_columns);
} else {
	$hanani_blog_style = explode('_', hanani_get_theme_option('blog_style'));
	$hanani_columns = empty($hanani_blog_style[1]) ? 1 : max(1, min(3, $hanani_blog_style[1]));
}
$hanani_expanded = !hanani_sidebar_present() && hanani_is_on(hanani_get_theme_option('expand_content'));
$hanani_post_format = get_post_format();
$hanani_post_format = empty($hanani_post_format) ? 'standard' : str_replace('post-format-', '', $hanani_post_format);
$hanani_animation = hanani_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" <?php
	post_class( 'post_item'
				. ' post_layout_chess'
				. ' post_layout_chess_'.esc_attr($hanani_columns)
				. ' post_format_'.esc_attr($hanani_post_format)
				. (!empty($hanani_template_args['slider']) ? ' slider-slide swiper-slide' : '')
				);
	echo (!hanani_is_off($hanani_animation) && empty($hanani_template_args['slider']) ? ' data-animation="'.esc_attr(hanani_get_animation_classes($hanani_animation)).'"' : '');
?>>

	<?php
	// Add anchor
	if ($hanani_columns == 1 && !is_array($hanani_template_args) && shortcode_exists('trx_sc_anchor')) {
		echo do_shortcode('[trx_sc_anchor id="post_'.esc_attr(get_the_ID()).'" title="'.the_title_attribute( array( 'echo' => false ) ).'" icon="'.esc_attr(hanani_get_post_icon()).'"]');
	}

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	$hanani_hover = !empty($hanani_template_args['hover']) && !hanani_is_inherit($hanani_template_args['hover'])
						? $hanani_template_args['hover'] 
						: hanani_get_theme_option('image_hover');
	hanani_show_post_featured( array(
											'class' => $hanani_columns == 1 && !is_array($hanani_template_args) ? 'hanani-full-height' : '',
											'singular' => false,
											'hover' => $hanani_hover,
											'no_links' => !empty($hanani_template_args['no_links']),
											'show_no_image' => true,
											'thumb_bg' => true,
											'thumb_size' => hanani_get_thumb_size(
																	strpos(hanani_get_theme_option('body_style'), 'full')!==false
																		? ( $hanani_columns > 1 ? 'huge' : 'original' )
																		: (	$hanani_columns > 2 ? 'big' : 'huge')
																	)
											) 
										);

	?><div class="post_inner"><div class="post_inner_content"><?php 

		?><div class="post_header entry-header"><?php 
			do_action('hanani_action_before_post_title'); 

			// Post title
			if (empty($hanani_template_args['no_links']))
				the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
			else
				the_title( '<h3 class="post_title entry-title">', '</h3>' );
			
			do_action('hanani_action_before_post_meta'); 

			// Post meta
			$hanani_components = hanani_array_get_keys_by_value(hanani_get_theme_option('meta_parts'));
			$hanani_counters = hanani_array_get_keys_by_value(hanani_get_theme_option('counters'));
			$hanani_post_meta = empty($hanani_components) || in_array($hanani_hover, array('border', 'pull', 'slide', 'fade'))
										? '' 
										: hanani_show_post_meta(apply_filters('hanani_filter_post_meta_args', array(
												'components' => $hanani_components,
												'counters' => $hanani_counters,
												'seo' => false,
												'echo' => false
												), $hanani_blog_style[0], $hanani_columns)
											);
			hanani_show_layout($hanani_post_meta);
		?></div><!-- .entry-header -->
	
		<div class="post_content entry-content"><?php
			if (empty($hanani_template_args['hide_excerpt'])) {
				?><div class="post_content_inner"><?php
					if (has_excerpt()) {
						the_excerpt();
					} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
						the_content( '' );
					} else if (in_array($hanani_post_format, array('link', 'aside', 'status'))) {
						the_content();
					} else if ($hanani_post_format == 'quote') {
						if (($quote = hanani_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
							hanani_show_layout(wpautop($quote));
						else
							the_excerpt();
					} else if (substr(get_the_content(), 0, 4)!='[vc_') {
						the_excerpt();
					}
				?></div><?php
			}
			// Post meta
			if (in_array($hanani_post_format, array('link', 'aside', 'status', 'quote'))) {
				hanani_show_layout($hanani_post_meta);
			}
			// More button
			if ( empty($hanani_template_args['no_links']) && !in_array($hanani_post_format, array('link', 'aside', 'status', 'quote')) ) {
				?><p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'hanani'); ?></a></p><?php
			}
			?>
		</div><!-- .entry-content -->

	</div></div><!-- .post_inner -->

</article>